/*
 * Decompiled with CFR 0.152.
 */
package org.jcvi.jillion.fasta.pos;

import org.jcvi.jillion.core.pos.Position;
import org.jcvi.jillion.core.pos.PositionSequence;
import org.jcvi.jillion.core.util.ObjectsUtil;
import org.jcvi.jillion.fasta.FastaRecord;

public final class PositionFastaRecord
implements FastaRecord<Position, PositionSequence> {
    private final String identifier;
    private final String comments;
    private final PositionSequence positions;

    public PositionFastaRecord(String id, PositionSequence positions) {
        this(id, null, positions);
    }

    public PositionFastaRecord(String id, String comments, PositionSequence positions) {
        if (id == null) {
            throw new NullPointerException("id can not be null");
        }
        if (positions == null) {
            throw new NullPointerException("positions can not be null");
        }
        this.identifier = id;
        this.comments = comments;
        this.positions = positions;
    }

    @Override
    public String getId() {
        return this.identifier;
    }

    @Override
    public String getComment() {
        return this.comments;
    }

    public String toString() {
        return "PositionSequenceFastaRecord [identifier=" + this.identifier + ", comments=" + this.comments + ", positions=" + this.positions + "]";
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + this.identifier.hashCode();
        result = 31 * result + this.getSequence().hashCode();
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof PositionFastaRecord)) {
            return false;
        }
        PositionFastaRecord other = (PositionFastaRecord)obj;
        return ObjectsUtil.nullSafeEquals(this.getId(), other.getId()) && ObjectsUtil.nullSafeEquals(this.getSequence(), other.getSequence());
    }

    @Override
    public PositionSequence getSequence() {
        return this.positions;
    }
}

