/*
 * Decompiled with CFR 0.152.
 */
package org.jcvi.jillion.fasta.pos;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.Objects;
import java.util.function.Predicate;
import org.jcvi.jillion.core.datastore.DataStoreProviderHint;
import org.jcvi.jillion.fasta.FastaFileParser;
import org.jcvi.jillion.fasta.FastaParser;
import org.jcvi.jillion.fasta.pos.DefaultPositionFastaFileDataStore;
import org.jcvi.jillion.fasta.pos.LargePositionFastaFileDataStore;
import org.jcvi.jillion.fasta.pos.PositionFastaDataStore;
import org.jcvi.jillion.fasta.pos.PositionFastaRecord;

public class PositionFastaFileDataStoreBuilder {
    private final FastaParser parser;
    private Predicate<String> idFilter = id -> true;
    private Predicate<PositionFastaRecord> recordFilter = null;
    private DataStoreProviderHint hint = DataStoreProviderHint.RANDOM_ACCESS_OPTIMIZE_SPEED;

    public PositionFastaFileDataStoreBuilder(File positionFastaFile) throws IOException {
        this(FastaFileParser.create(positionFastaFile));
    }

    public PositionFastaFileDataStoreBuilder(InputStream positionFastaFileStream) throws IOException {
        this(FastaFileParser.create(positionFastaFileStream));
    }

    public PositionFastaFileDataStoreBuilder(FastaParser parser) {
        Objects.requireNonNull(parser);
        this.parser = parser;
    }

    protected PositionFastaFileDataStoreBuilder hint(DataStoreProviderHint hint) {
        if (hint == null) {
            throw new NullPointerException("hint can not be null");
        }
        this.hint = hint;
        return this;
    }

    public PositionFastaFileDataStoreBuilder filter(Predicate<String> filter) {
        if (filter == null) {
            throw new NullPointerException("filter can not be null");
        }
        this.idFilter = filter;
        return this;
    }

    public PositionFastaFileDataStoreBuilder filterRecords(Predicate<PositionFastaRecord> filter) {
        if (filter == null) {
            throw new NullPointerException("filter can not be null");
        }
        this.recordFilter = filter;
        return this;
    }

    public PositionFastaDataStore build() throws IOException {
        if (this.hint == DataStoreProviderHint.ITERATION_ONLY) {
            return LargePositionFastaFileDataStore.create(this.parser, this.idFilter, this.recordFilter);
        }
        return DefaultPositionFastaFileDataStore.create(this.parser, this.idFilter, this.recordFilter);
    }
}

