/*
 * Decompiled with CFR 0.152.
 */
package org.jcvi.jillion.fasta.pos;

import java.io.IOException;
import java.util.function.Consumer;
import java.util.function.Predicate;
import org.jcvi.jillion.core.datastore.DataStoreException;
import org.jcvi.jillion.core.datastore.DataStoreFilters;
import org.jcvi.jillion.core.pos.Position;
import org.jcvi.jillion.core.pos.PositionSequence;
import org.jcvi.jillion.core.util.iter.StreamingIterator;
import org.jcvi.jillion.fasta.FastaParser;
import org.jcvi.jillion.fasta.FastaRecordVisitor;
import org.jcvi.jillion.fasta.pos.AbstractPositionSequenceFastaRecordVisitor;
import org.jcvi.jillion.fasta.pos.LargePositionFastaIterator;
import org.jcvi.jillion.fasta.pos.PositionFastaDataStore;
import org.jcvi.jillion.fasta.pos.PositionFastaRecord;
import org.jcvi.jillion.fasta.pos.PositionSequenceDataStore;
import org.jcvi.jillion.internal.core.datastore.DataStoreStreamingIterator;
import org.jcvi.jillion.internal.fasta.AbstractLargeFastaFileDataStore;

final class LargePositionFastaFileDataStore
extends AbstractLargeFastaFileDataStore<Position, PositionSequence, PositionFastaRecord, PositionSequenceDataStore>
implements PositionFastaDataStore {
    public static PositionFastaDataStore create(FastaParser parser) {
        return LargePositionFastaFileDataStore.create(parser, DataStoreFilters.alwaysAccept(), null);
    }

    public static PositionFastaDataStore create(FastaParser parser, Predicate<String> filter, Predicate<PositionFastaRecord> recordFilter) {
        return new LargePositionFastaFileDataStore(parser, filter, recordFilter);
    }

    public LargePositionFastaFileDataStore(FastaParser parser, Predicate<String> filter, Predicate<PositionFastaRecord> recordFilter) {
        super(parser, filter, recordFilter);
    }

    @Override
    protected StreamingIterator<PositionFastaRecord> createNewIterator(FastaParser parser, Predicate<String> filter, Predicate<PositionFastaRecord> recordIterator) throws DataStoreException {
        try {
            return DataStoreStreamingIterator.create(this, LargePositionFastaIterator.createNewIteratorFor(parser, filter, recordIterator));
        }
        catch (IOException e) {
            throw new DataStoreException("error iterating over fasta file", e);
        }
    }

    @Override
    protected FastaRecordVisitor createRecordVisitor(String id, String comment, final Consumer<PositionFastaRecord> callback) {
        return new AbstractPositionSequenceFastaRecordVisitor(id, comment){

            @Override
            protected void visitRecord(PositionFastaRecord fastaRecord) {
                callback.accept(fastaRecord);
            }
        };
    }
}

