/*
 * Decompiled with CFR 0.152.
 */
package org.jcvi.jillion.fasta.pos;

import java.io.IOException;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.function.Predicate;
import org.jcvi.jillion.core.datastore.DataStore;
import org.jcvi.jillion.core.pos.Position;
import org.jcvi.jillion.core.pos.PositionSequence;
import org.jcvi.jillion.core.util.Builder;
import org.jcvi.jillion.fasta.FastaParser;
import org.jcvi.jillion.fasta.FastaRecordVisitor;
import org.jcvi.jillion.fasta.FastaVisitor;
import org.jcvi.jillion.fasta.FastaVisitorCallback;
import org.jcvi.jillion.fasta.pos.AbstractPositionSequenceFastaRecordVisitor;
import org.jcvi.jillion.fasta.pos.PositionFastaDataStore;
import org.jcvi.jillion.fasta.pos.PositionFastaRecord;
import org.jcvi.jillion.fasta.pos.PositionSequenceDataStore;
import org.jcvi.jillion.internal.fasta.AdaptedFastaDataStore;

final class DefaultPositionFastaFileDataStore {
    private DefaultPositionFastaFileDataStore() {
    }

    public static PositionFastaDataStore create(FastaParser parser, Predicate<String> filter, Predicate<PositionFastaRecord> recordFilter) throws IOException {
        DefaultPositionFastaFileDataStoreBuilder builder = new DefaultPositionFastaFileDataStoreBuilder(filter, recordFilter);
        parser.parse(builder);
        return builder.build();
    }

    private static class AdaptedPositionFastaDataStore
    extends AdaptedFastaDataStore<Position, PositionSequence, PositionFastaRecord, PositionSequenceDataStore>
    implements PositionFastaDataStore {
        public AdaptedPositionFastaDataStore(Map<String, PositionFastaRecord> map) {
            super(map);
        }

        @Override
        public PositionSequenceDataStore asSequenceDataStore() {
            return DataStore.adapt(PositionSequenceDataStore.class, this, PositionFastaRecord::getSequence);
        }
    }

    private static class DefaultPositionFastaFileDataStoreBuilder
    implements FastaVisitor,
    Builder<PositionFastaDataStore> {
        private final Map<String, PositionFastaRecord> fastaRecords = new LinkedHashMap<String, PositionFastaRecord>();
        private final Predicate<String> filter;
        private final Predicate<PositionFastaRecord> recordFilter;

        public DefaultPositionFastaFileDataStoreBuilder(Predicate<String> filter, Predicate<PositionFastaRecord> recordFilter) {
            this.filter = filter;
            this.recordFilter = recordFilter;
        }

        @Override
        public FastaRecordVisitor visitDefline(FastaVisitorCallback callback, final String id, String optionalComment) {
            if (!this.filter.test(id)) {
                return null;
            }
            return new AbstractPositionSequenceFastaRecordVisitor(id, optionalComment){

                @Override
                protected void visitRecord(PositionFastaRecord fastaRecord) {
                    if (recordFilter == null || recordFilter.test(fastaRecord)) {
                        fastaRecords.put(id, fastaRecord);
                    }
                }
            };
        }

        @Override
        public void visitEnd() {
        }

        @Override
        public void halted() {
        }

        @Override
        public PositionFastaDataStore build() {
            return new AdaptedPositionFastaDataStore(this.fastaRecords);
        }
    }
}

