/*
 * Decompiled with CFR 0.152.
 */
package org.jcvi.jillion.fasta.nt;

import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.charset.Charset;
import java.util.Comparator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import java.util.function.Predicate;
import org.jcvi.jillion.core.datastore.DataStoreException;
import org.jcvi.jillion.core.datastore.DataStoreFilters;
import org.jcvi.jillion.core.residue.nt.Nucleotide;
import org.jcvi.jillion.core.residue.nt.NucleotideSequence;
import org.jcvi.jillion.core.residue.nt.NucleotideSequenceBuilder;
import org.jcvi.jillion.core.util.JoinedStringBuilder;
import org.jcvi.jillion.core.util.MapUtil;
import org.jcvi.jillion.core.util.iter.StreamingIterator;
import org.jcvi.jillion.fasta.FastaWriter;
import org.jcvi.jillion.fasta.nt.FaiNucleotideFastaWriter;
import org.jcvi.jillion.fasta.nt.LargeNucleotideSequenceFastaIterator;
import org.jcvi.jillion.fasta.nt.NucleotideFastaRecord;
import org.jcvi.jillion.fasta.nt.NucleotideFastaRecordBuilder;
import org.jcvi.jillion.fasta.nt.NucleotideFastaWriter;
import org.jcvi.jillion.internal.fasta.FastaUtil;
import org.jcvi.jillion.internal.fasta.InMemorySortedFastaWriter;
import org.jcvi.jillion.internal.fasta.TmpDirSortedFastaWriter;
import org.jcvi.jillion.shared.fasta.AbstractResidueFastaWriter;

public final class NucleotideFastaWriterBuilder
extends AbstractResidueFastaWriter.Builder<Nucleotide, NucleotideSequence, NucleotideSequenceBuilder, NucleotideFastaRecord, NucleotideFastaWriter, NucleotideFastaWriterBuilder> {
    private boolean nonRedundant;
    private Integer expectedCapacity;
    private File outputFile;
    private boolean createIndex;

    public NucleotideFastaWriterBuilder(File outputFile) throws IOException {
        super(outputFile);
        this.outputFile = outputFile;
    }

    public NucleotideFastaWriterBuilder(OutputStream out) {
        super(out);
    }

    @Override
    protected NucleotideFastaWriterBuilder getThis() {
        return this;
    }

    public NucleotideFastaWriterBuilder makeNonRedundant() {
        this.nonRedundant = true;
        this.expectedCapacity = null;
        return this;
    }

    public NucleotideFastaWriterBuilder makeNonRedundant(int expectedSize) {
        if (expectedSize < 1) {
            throw new IllegalArgumentException("expected size must be >= 1");
        }
        this.expectedCapacity = expectedSize;
        this.nonRedundant = true;
        return this;
    }

    public NucleotideFastaWriterBuilder createIndex(boolean createIndex) {
        this.createIndex = createIndex;
        return this;
    }

    @Override
    protected NucleotideFastaWriter create(OutputStream out, int numberOfResiduesPerLine, Charset charSet, String eol) {
        if (this.nonRedundant) {
            if (this.expectedCapacity == null) {
                return new NonRedundantNucleotideSequenceFastaWriter(out, numberOfResiduesPerLine, charSet, eol);
            }
            return new NonRedundantNucleotideSequenceFastaWriter(out, numberOfResiduesPerLine, charSet, eol, this.expectedCapacity);
        }
        return new NucleotideSequenceFastaRecordWriterImpl(out, numberOfResiduesPerLine, charSet, eol);
    }

    @Override
    public NucleotideFastaWriter build() {
        NucleotideFastaWriter writer = (NucleotideFastaWriter)super.build();
        if (this.createIndex && this.outputFile != null) {
            File faiFile = new File(this.outputFile.getParentFile(), this.outputFile.getName() + ".fai");
            return new FaiNucleotideFastaWriter(this.outputFile, faiFile, writer);
        }
        return writer;
    }

    @Override
    protected NucleotideFastaWriter createTmpDirSortedWriterWriter(FastaWriter<Nucleotide, NucleotideSequence, NucleotideFastaRecord> delegate, Comparator<NucleotideFastaRecord> comparator, int cacheSize, File tmpDir) {
        return new TmpDirSortedNucleotideFastaWriter(delegate, comparator, cacheSize, tmpDir);
    }

    @Override
    protected NucleotideFastaWriter createInMemorySortedWriterWriter(FastaWriter<Nucleotide, NucleotideSequence, NucleotideFastaRecord> delegate, Comparator<NucleotideFastaRecord> comparator) {
        return new InMemorySortedNucleotideFastaWriter(delegate, comparator);
    }

    private static final class TmpDirSortedNucleotideFastaWriter
    extends TmpDirSortedFastaWriter<Nucleotide, NucleotideSequence, NucleotideFastaRecord>
    implements NucleotideFastaWriter {
        public TmpDirSortedNucleotideFastaWriter(FastaWriter<Nucleotide, NucleotideSequence, NucleotideFastaRecord> finalWriter, Comparator<NucleotideFastaRecord> comparator, int cacheSize, File tmpDir) {
            super(finalWriter, comparator, tmpDir, cacheSize);
        }

        @Override
        protected StreamingIterator<NucleotideFastaRecord> createStreamingIteratorFor(File tmpFastaFile) throws IOException, DataStoreException {
            return LargeNucleotideSequenceFastaIterator.createNewIteratorFor(tmpFastaFile, (Predicate<String>)DataStoreFilters.alwaysAccept(), null);
        }

        @Override
        protected FastaWriter<Nucleotide, NucleotideSequence, NucleotideFastaRecord> createNewTmpWriter(File tmpFile) throws IOException {
            return new NucleotideFastaWriterBuilder(tmpFile).build();
        }

        @Override
        protected NucleotideFastaRecord createFastaRecord(String id, NucleotideSequence sequence, String optionalComment) {
            return (NucleotideFastaRecord)((NucleotideFastaRecordBuilder)new NucleotideFastaRecordBuilder(id, sequence).comment(optionalComment)).build();
        }
    }

    private static final class InMemorySortedNucleotideFastaWriter
    extends InMemorySortedFastaWriter<Nucleotide, NucleotideSequence, NucleotideFastaRecord>
    implements NucleotideFastaWriter {
        public InMemorySortedNucleotideFastaWriter(FastaWriter<Nucleotide, NucleotideSequence, NucleotideFastaRecord> writer, Comparator<NucleotideFastaRecord> comparator) {
            super(writer, comparator);
        }

        @Override
        protected NucleotideFastaRecord createRecord(String id, NucleotideSequence sequence, String optionalComment) {
            return (NucleotideFastaRecord)((NucleotideFastaRecordBuilder)new NucleotideFastaRecordBuilder(id, sequence).comment(optionalComment)).build();
        }
    }

    private static final class NonRedundantNucleotideSequenceFastaWriter
    implements NucleotideFastaWriter {
        private final Map<NucleotideSequence, Set<NonRedundantEntry>> nonRedundantMap;
        private final NucleotideSequenceFastaRecordWriterImpl delegateWriter;

        public NonRedundantNucleotideSequenceFastaWriter(OutputStream out, int numberOfResiduesPerLine, Charset charSet, String eol) {
            this(out, numberOfResiduesPerLine, charSet, eol, 1000);
        }

        public NonRedundantNucleotideSequenceFastaWriter(OutputStream out, int numberOfResiduesPerLine, Charset charSet, String eol, int expectedSize) {
            this.nonRedundantMap = new LinkedHashMap<NucleotideSequence, Set<NonRedundantEntry>>(MapUtil.computeMinHashMapSizeWithoutRehashing(expectedSize));
            this.delegateWriter = new NucleotideSequenceFastaRecordWriterImpl(out, numberOfResiduesPerLine, charSet, eol);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void close() throws IOException {
            try {
                for (Map.Entry<NucleotideSequence, Set<NonRedundantEntry>> entry : this.nonRedundantMap.entrySet()) {
                    NucleotideSequence sequence = entry.getKey();
                    String ids = JoinedStringBuilder.create((Iterable)entry.getValue()).glue(Character.valueOf(FastaUtil.getNonRedundantSeparator())).transform(NonRedundantEntry::getNonRedundantId).build();
                    this.delegateWriter.write(ids, sequence);
                }
            }
            finally {
                this.delegateWriter.close();
            }
        }

        @Override
        public void write(NucleotideFastaRecord record) throws IOException {
            this.write(record.getId(), (NucleotideSequence)record.getSequence(), record.getComment());
        }

        @Override
        public void write(String id, NucleotideSequence sequence) throws IOException {
            this.write(id, sequence, (String)null);
        }

        @Override
        public void write(String id, NucleotideSequence sequence, String optionalComment) throws IOException {
            NonRedundantEntry entry = optionalComment == null ? new NoCommentedNonRedundantEntry(id) : new CommentedNonRedundantEntry(id, optionalComment);
            this.nonRedundantMap.computeIfAbsent(sequence, k -> new LinkedHashSet()).add(entry);
        }
    }

    private static final class NoCommentedNonRedundantEntry
    implements NonRedundantEntry {
        private final String id;

        public NoCommentedNonRedundantEntry(String id) {
            this.id = id;
        }

        @Override
        public String getId() {
            return this.id;
        }

        @Override
        public String getComment() {
            return null;
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + this.id.hashCode();
            result = 31 * result;
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (!(obj instanceof NonRedundantEntry)) {
                return false;
            }
            NonRedundantEntry other = (NonRedundantEntry)obj;
            if (other.getComment() != null) {
                return false;
            }
            return this.getId().equals(other.getId());
        }
    }

    private static final class CommentedNonRedundantEntry
    implements NonRedundantEntry {
        private final String id;
        private final String comment;

        public CommentedNonRedundantEntry(String id, String comment) {
            this.id = id;
            this.comment = comment;
        }

        @Override
        public String getId() {
            return this.id;
        }

        @Override
        public String getComment() {
            return this.comment;
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + this.id.hashCode();
            result = 31 * result + this.comment.hashCode();
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (!(obj instanceof NonRedundantEntry)) {
                return false;
            }
            NonRedundantEntry other = (NonRedundantEntry)obj;
            if (!this.getComment().equals(other.getComment())) {
                return false;
            }
            return this.getId().equals(other.getId());
        }
    }

    private static interface NonRedundantEntry {
        public String getId();

        public String getComment();

        default public String getNonRedundantId() {
            String id = this.getId();
            String comment = this.getComment();
            StringBuilder builder = new StringBuilder(id.length() + (comment == null ? 0 : comment.length() + 1));
            builder.append(id);
            if (comment != null) {
                builder.append(' ').append(comment);
            }
            return builder.toString();
        }
    }

    private static final class NucleotideSequenceFastaRecordWriterImpl
    extends AbstractResidueFastaWriter<Nucleotide, NucleotideSequence, NucleotideSequenceBuilder, NucleotideFastaRecord>
    implements NucleotideFastaWriter {
        private NucleotideSequenceFastaRecordWriterImpl(OutputStream out, int numberOfResiduesPerLine, Charset charSet, String eol) {
            super(out, numberOfResiduesPerLine, charSet, eol);
        }
    }
}

