/*
 * Decompiled with CFR 0.152.
 */
package org.jcvi.jillion.fasta.nt;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.function.Predicate;
import org.jcvi.jillion.core.datastore.DataStoreProviderHint;
import org.jcvi.jillion.core.io.InputStreamSupplier;
import org.jcvi.jillion.core.residue.nt.Nucleotide;
import org.jcvi.jillion.core.residue.nt.NucleotideSequence;
import org.jcvi.jillion.core.residue.nt.NucleotideSequenceDataStore;
import org.jcvi.jillion.fasta.FastaParser;
import org.jcvi.jillion.fasta.nt.DefaultNucleotideFastaFileDataStore;
import org.jcvi.jillion.fasta.nt.FaiNucleotideFastaFileDataStore;
import org.jcvi.jillion.fasta.nt.IndexedNucleotideSequenceFastaFileDataStore;
import org.jcvi.jillion.fasta.nt.LargeNucleotideSequenceFastaFileDataStore;
import org.jcvi.jillion.fasta.nt.NucleotideFastaFileDataStore;
import org.jcvi.jillion.fasta.nt.NucleotideFastaRecord;
import org.jcvi.jillion.shared.fasta.AbstractFastaFileDataStoreBuilder;

public final class NucleotideFastaFileDataStoreBuilder
extends AbstractFastaFileDataStoreBuilder<Nucleotide, NucleotideSequence, NucleotideFastaRecord, NucleotideSequenceDataStore, NucleotideFastaFileDataStore> {
    private File faiFile;
    private File fastaFile;

    public NucleotideFastaFileDataStoreBuilder(File fastaFile) throws IOException {
        this(fastaFile, new File(fastaFile.getParentFile(), fastaFile.getName() + ".fai"));
    }

    public NucleotideFastaFileDataStoreBuilder(File fastaFile, File faiFile) throws IOException {
        super(fastaFile);
        this.fastaFile = fastaFile;
        this.faiFile = faiFile;
    }

    public NucleotideFastaFileDataStoreBuilder(FastaParser parser) {
        super(parser);
    }

    public NucleotideFastaFileDataStoreBuilder(InputStreamSupplier supplier) throws IOException {
        super(supplier);
    }

    public NucleotideFastaFileDataStoreBuilder(InputStream fastaFileStream) throws IOException {
        super(fastaFileStream);
    }

    @Override
    protected NucleotideFastaFileDataStore createNewInstance(FastaParser parser, DataStoreProviderHint providerHint, Predicate<String> filter, Predicate<NucleotideFastaRecord> recordFilter) throws IOException {
        NucleotideFastaFileDataStore delegate;
        if (parser.isReadOnceOnly()) {
            return DefaultNucleotideFastaFileDataStore.create(parser, filter, recordFilter);
        }
        switch (providerHint) {
            case RANDOM_ACCESS_OPTIMIZE_SPEED: {
                delegate = DefaultNucleotideFastaFileDataStore.create(parser, filter, recordFilter);
                break;
            }
            case RANDOM_ACCESS_OPTIMIZE_MEMORY: {
                delegate = parser.canCreateMemento() ? IndexedNucleotideSequenceFastaFileDataStore.create(parser, filter, recordFilter) : DefaultNucleotideFastaFileDataStore.create(parser, filter, recordFilter);
                break;
            }
            case ITERATION_ONLY: {
                delegate = LargeNucleotideSequenceFastaFileDataStore.create(parser, filter, recordFilter);
                break;
            }
            default: {
                throw new IllegalArgumentException("unknown provider hint : " + (Object)((Object)providerHint));
            }
        }
        if (this.faiFile != null && this.faiFile.exists()) {
            return FaiNucleotideFastaFileDataStore.create(this.fastaFile, this.faiFile, delegate);
        }
        return delegate;
    }

    public NucleotideFastaFileDataStoreBuilder filter(Predicate<String> filter) {
        super.filter(filter);
        return this;
    }

    public NucleotideFastaFileDataStoreBuilder hint(DataStoreProviderHint hint) {
        super.hint(hint);
        return this;
    }

    public NucleotideFastaFileDataStoreBuilder filterRecords(Predicate<NucleotideFastaRecord> filter) {
        super.filterRecords(filter);
        return this;
    }

    @Override
    public NucleotideFastaFileDataStore build() throws IOException {
        return (NucleotideFastaFileDataStore)super.build();
    }
}

