/*
 * Decompiled with CFR 0.152.
 */
package org.jcvi.jillion.fasta.nt;

import java.util.Objects;
import org.jcvi.jillion.core.Range;
import org.jcvi.jillion.core.datastore.DataStore;
import org.jcvi.jillion.core.datastore.DataStoreException;
import org.jcvi.jillion.core.residue.nt.Nucleotide;
import org.jcvi.jillion.core.residue.nt.NucleotideSequence;
import org.jcvi.jillion.core.residue.nt.NucleotideSequenceBuilder;
import org.jcvi.jillion.core.residue.nt.NucleotideSequenceDataStore;
import org.jcvi.jillion.fasta.FastaDataStore;
import org.jcvi.jillion.fasta.FastaRecord;
import org.jcvi.jillion.fasta.nt.NucleotideFastaRecord;

public interface NucleotideFastaDataStore
extends FastaDataStore<Nucleotide, NucleotideSequence, NucleotideFastaRecord, NucleotideSequenceDataStore> {
    @Override
    default public NucleotideSequenceDataStore asSequenceDataStore() {
        return DataStore.adapt(NucleotideSequenceDataStore.class, this, FastaRecord::getSequence);
    }

    @Override
    default public NucleotideSequence getSubSequence(String id, long startOffset) throws DataStoreException {
        if (startOffset < 0L) {
            throw new IllegalArgumentException("start offset can not be negative");
        }
        NucleotideFastaRecord fullSequence = (NucleotideFastaRecord)this.get(id);
        if (fullSequence == null) {
            return null;
        }
        long fullLength = fullSequence.getLength();
        if (fullLength - 1L < startOffset) {
            throw new IllegalArgumentException("start offset is beyond sequence length : " + startOffset);
        }
        Range range = new Range.Builder(fullLength).contractBegin(startOffset).build();
        return new NucleotideSequenceBuilder((NucleotideSequence)fullSequence.getSequence(), range).build();
    }

    @Override
    default public NucleotideSequence getSubSequence(String id, Range includeRange) throws DataStoreException {
        Objects.requireNonNull(includeRange);
        NucleotideFastaRecord fullSequence = (NucleotideFastaRecord)this.get(id);
        if (fullSequence == null) {
            return null;
        }
        return new NucleotideSequenceBuilder((NucleotideSequence)fullSequence.getSequence(), includeRange).build();
    }
}

