/*
 * Decompiled with CFR 0.152.
 */
package org.jcvi.jillion.fasta.nt;

import java.io.File;
import java.io.IOException;
import java.util.function.Predicate;
import org.jcvi.jillion.core.residue.nt.NucleotideSequenceBuilder;
import org.jcvi.jillion.fasta.FastaFileParser;
import org.jcvi.jillion.fasta.FastaParser;
import org.jcvi.jillion.fasta.FastaRecordVisitor;
import org.jcvi.jillion.fasta.FastaVisitor;
import org.jcvi.jillion.fasta.FastaVisitorCallback;
import org.jcvi.jillion.fasta.nt.NucleotideFastaRecord;
import org.jcvi.jillion.fasta.nt.NucleotideFastaRecordBuilder;
import org.jcvi.jillion.internal.core.util.iter.AbstractBlockingStreamingIterator;

final class LargeNucleotideSequenceFastaIterator
extends AbstractBlockingStreamingIterator<NucleotideFastaRecord> {
    private final FastaParser parser;
    private final Predicate<String> filter;
    private final Predicate<NucleotideFastaRecord> recordFilter;

    public static LargeNucleotideSequenceFastaIterator createNewIteratorFor(File fastaFile, Predicate<String> filter, Predicate<NucleotideFastaRecord> recordFilter) throws IOException {
        return LargeNucleotideSequenceFastaIterator.createNewIteratorFor(FastaFileParser.create(fastaFile), filter, recordFilter);
    }

    public static LargeNucleotideSequenceFastaIterator createNewIteratorFor(FastaParser parser, Predicate<String> filter, Predicate<NucleotideFastaRecord> recordFilter) throws IOException {
        LargeNucleotideSequenceFastaIterator iter = new LargeNucleotideSequenceFastaIterator(parser, filter, recordFilter);
        iter.start();
        return iter;
    }

    private LargeNucleotideSequenceFastaIterator(FastaParser parser, Predicate<String> filter, Predicate<NucleotideFastaRecord> recordFilter) {
        if (!parser.canParse()) {
            throw new IllegalStateException("parser must still be able to parse fasta");
        }
        this.parser = parser;
        this.filter = filter;
        this.recordFilter = recordFilter;
    }

    @Override
    protected void backgroundThreadRunMethod() {
        FastaVisitor visitor = new FastaVisitor(){
            NucleotideFastaRecordVisitor recordVisitor;
            {
                this.recordVisitor = new NucleotideFastaRecordVisitor(LargeNucleotideSequenceFastaIterator.this.recordFilter);
            }

            @Override
            public FastaRecordVisitor visitDefline(FastaVisitorCallback callback, String id, String optionalComment) {
                if (!LargeNucleotideSequenceFastaIterator.this.filter.test(id)) {
                    return null;
                }
                this.recordVisitor.prepareNewRecord(callback, id, optionalComment);
                return this.recordVisitor;
            }

            @Override
            public void visitEnd() {
            }

            @Override
            public void halted() {
            }
        };
        try {
            this.parser.parse(visitor);
        }
        catch (IOException e) {
            throw new RuntimeException("can not parse fasta file", e);
        }
    }

    private class NucleotideFastaRecordVisitor
    implements FastaRecordVisitor {
        private String currentId;
        private String currentComment;
        private NucleotideSequenceBuilder builder;
        private FastaVisitorCallback callback;
        private final Predicate<NucleotideFastaRecord> recordFilter;

        public NucleotideFastaRecordVisitor(Predicate<NucleotideFastaRecord> recordFilter) {
            this.recordFilter = recordFilter;
        }

        public void prepareNewRecord(FastaVisitorCallback callback, String id, String optionalComment) {
            this.currentId = id;
            this.currentComment = optionalComment;
            this.callback = callback;
            this.builder = new NucleotideSequenceBuilder();
        }

        @Override
        public void visitBodyLine(String line) {
            this.builder.append(line);
        }

        @Override
        public void visitEnd() {
            NucleotideFastaRecord fastaRecord = (NucleotideFastaRecord)((NucleotideFastaRecordBuilder)new NucleotideFastaRecordBuilder(this.currentId, this.builder.build()).comment(this.currentComment)).build();
            if (this.recordFilter == null || this.recordFilter.test(fastaRecord)) {
                LargeNucleotideSequenceFastaIterator.this.blockingPut(fastaRecord);
                if (LargeNucleotideSequenceFastaIterator.this.isClosed()) {
                    this.callback.haltParsing();
                }
            }
        }

        @Override
        public void halted() {
        }
    }
}

