/*
 * Decompiled with CFR 0.152.
 */
package org.jcvi.jillion.fasta.nt;

import java.io.File;
import java.io.IOException;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.function.Predicate;
import org.jcvi.jillion.core.datastore.DataStoreException;
import org.jcvi.jillion.core.datastore.DataStoreFilters;
import org.jcvi.jillion.core.residue.nt.Nucleotide;
import org.jcvi.jillion.core.residue.nt.NucleotideSequence;
import org.jcvi.jillion.core.residue.nt.NucleotideSequenceDataStore;
import org.jcvi.jillion.core.util.iter.StreamingIterator;
import org.jcvi.jillion.fasta.FastaFileParser;
import org.jcvi.jillion.fasta.FastaParser;
import org.jcvi.jillion.fasta.FastaRecordVisitor;
import org.jcvi.jillion.fasta.nt.AbstractNucleotideFastaRecordVisitor;
import org.jcvi.jillion.fasta.nt.LargeNucleotideSequenceFastaIterator;
import org.jcvi.jillion.fasta.nt.NucleotideFastaFileDataStore;
import org.jcvi.jillion.fasta.nt.NucleotideFastaRecord;
import org.jcvi.jillion.internal.core.datastore.DataStoreStreamingIterator;
import org.jcvi.jillion.internal.fasta.AbstractLargeFastaFileDataStore;

final class LargeNucleotideSequenceFastaFileDataStore
extends AbstractLargeFastaFileDataStore<Nucleotide, NucleotideSequence, NucleotideFastaRecord, NucleotideSequenceDataStore>
implements NucleotideFastaFileDataStore {
    private final File fastaFile;

    public static NucleotideFastaFileDataStore create(FastaParser parser) {
        return LargeNucleotideSequenceFastaFileDataStore.create(parser, DataStoreFilters.alwaysAccept(), null);
    }

    public static NucleotideFastaFileDataStore create(FastaParser parser, Predicate<String> filter, Predicate<NucleotideFastaRecord> recordFilter) {
        return new LargeNucleotideSequenceFastaFileDataStore(parser, filter, recordFilter);
    }

    public LargeNucleotideSequenceFastaFileDataStore(FastaParser parser, Predicate<String> filter, Predicate<NucleotideFastaRecord> recordFilter) {
        super(parser, filter, recordFilter);
        Optional<File> optFile;
        File tmpFile = null;
        if (parser instanceof FastaFileParser && (optFile = ((FastaFileParser)parser).getFile()).isPresent()) {
            tmpFile = optFile.get();
        }
        this.fastaFile = tmpFile;
    }

    @Override
    protected FastaRecordVisitor createRecordVisitor(String id, String comment, final Consumer<NucleotideFastaRecord> consumer) {
        return new AbstractNucleotideFastaRecordVisitor(id, comment){

            @Override
            protected void visitRecord(NucleotideFastaRecord fastaRecord) {
                consumer.accept(fastaRecord);
            }
        };
    }

    @Override
    public Optional<File> getFile() {
        return Optional.ofNullable(this.fastaFile);
    }

    @Override
    protected StreamingIterator<NucleotideFastaRecord> createNewIterator(FastaParser parser, Predicate<String> filter, Predicate<NucleotideFastaRecord> recordIterator) throws DataStoreException {
        try {
            return DataStoreStreamingIterator.create(this, LargeNucleotideSequenceFastaIterator.createNewIteratorFor(parser, filter, recordIterator));
        }
        catch (IOException e) {
            throw new DataStoreException("error iterating over fasta file", e);
        }
    }
}

