/*
 * Decompiled with CFR 0.152.
 */
package org.jcvi.jillion.fasta.nt;

import java.io.File;
import java.io.IOException;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Optional;
import java.util.function.Predicate;
import org.jcvi.jillion.core.datastore.DataStoreClosedException;
import org.jcvi.jillion.core.datastore.DataStoreEntry;
import org.jcvi.jillion.core.datastore.DataStoreException;
import org.jcvi.jillion.core.datastore.DataStoreFilters;
import org.jcvi.jillion.core.util.Builder;
import org.jcvi.jillion.core.util.iter.StreamingIterator;
import org.jcvi.jillion.fasta.FastaFileParser;
import org.jcvi.jillion.fasta.FastaParser;
import org.jcvi.jillion.fasta.FastaRecordVisitor;
import org.jcvi.jillion.fasta.FastaVisitor;
import org.jcvi.jillion.fasta.FastaVisitorCallback;
import org.jcvi.jillion.fasta.nt.AbstractNucleotideFastaRecordVisitor;
import org.jcvi.jillion.fasta.nt.LargeNucleotideSequenceFastaIterator;
import org.jcvi.jillion.fasta.nt.NucleotideFastaFileDataStore;
import org.jcvi.jillion.fasta.nt.NucleotideFastaRecord;
import org.jcvi.jillion.internal.core.datastore.DataStoreStreamingIterator;

final class IndexedNucleotideSequenceFastaFileDataStore
implements NucleotideFastaFileDataStore {
    private volatile boolean closed = false;
    private final FastaParser parser;
    private final Predicate<String> filter;
    private final Predicate<NucleotideFastaRecord> recordFilter;
    private final Map<String, FastaVisitorCallback.FastaVisitorMemento> mementos;
    private final File fastaFile;

    private IndexedNucleotideSequenceFastaFileDataStore(FastaParser parser, Predicate<String> filter, Predicate<NucleotideFastaRecord> recordFilter, Map<String, FastaVisitorCallback.FastaVisitorMemento> mementos) {
        Optional<File> optFile;
        this.parser = parser;
        this.mementos = mementos;
        this.filter = filter;
        this.recordFilter = recordFilter;
        File tmpFile = null;
        if (parser instanceof FastaFileParser && (optFile = ((FastaFileParser)parser).getFile()).isPresent()) {
            tmpFile = optFile.get();
        }
        this.fastaFile = tmpFile;
    }

    @Override
    public Optional<File> getFile() {
        return Optional.ofNullable(this.fastaFile);
    }

    @Override
    public StreamingIterator<String> idIterator() throws DataStoreException {
        this.throwExceptionIfClosed();
        return DataStoreStreamingIterator.create(this, this.mementos.keySet().iterator());
    }

    @Override
    public NucleotideFastaRecord get(String id) throws DataStoreException {
        this.throwExceptionIfClosed();
        if (!this.mementos.containsKey(id)) {
            return null;
        }
        SingleRecordVisitor visitor = new SingleRecordVisitor();
        try {
            this.parser.parse(visitor, this.mementos.get(id));
            return visitor.fastaRecord;
        }
        catch (IOException e) {
            throw new DataStoreException("error reading fasta file", e);
        }
    }

    @Override
    public StreamingIterator<NucleotideFastaRecord> iterator() throws DataStoreException {
        this.throwExceptionIfClosed();
        try {
            return DataStoreStreamingIterator.create(this, LargeNucleotideSequenceFastaIterator.createNewIteratorFor(this.parser, this.filter, this.recordFilter));
        }
        catch (IOException e) {
            throw new DataStoreException("error iterating over fasta file", e);
        }
    }

    @Override
    public StreamingIterator<DataStoreEntry<NucleotideFastaRecord>> entryIterator() throws DataStoreException {
        this.throwExceptionIfClosed();
        try {
            StreamingIterator<DataStoreEntry<NucleotideFastaRecord>> entryIter = new StreamingIterator<DataStoreEntry<NucleotideFastaRecord>>(){
                StreamingIterator<NucleotideFastaRecord> iter;
                {
                    this.iter = LargeNucleotideSequenceFastaIterator.createNewIteratorFor(IndexedNucleotideSequenceFastaFileDataStore.this.parser, (Predicate<String>)IndexedNucleotideSequenceFastaFileDataStore.this.filter, (Predicate<NucleotideFastaRecord>)IndexedNucleotideSequenceFastaFileDataStore.this.recordFilter);
                }

                @Override
                public boolean hasNext() {
                    return this.iter.hasNext();
                }

                @Override
                public void close() {
                    this.iter.close();
                }

                @Override
                public DataStoreEntry<NucleotideFastaRecord> next() {
                    NucleotideFastaRecord next = this.iter.next();
                    return new DataStoreEntry<NucleotideFastaRecord>(next.getId(), next);
                }

                @Override
                public void remove() {
                    throw new UnsupportedOperationException();
                }
            };
            return DataStoreStreamingIterator.create(this, entryIter);
        }
        catch (IOException e) {
            throw new DataStoreException("error iterating over fasta file", e);
        }
    }

    private void throwExceptionIfClosed() throws DataStoreException {
        if (this.closed) {
            throw new DataStoreClosedException("datastore is closed");
        }
    }

    @Override
    public boolean contains(String id) throws DataStoreException {
        this.throwExceptionIfClosed();
        return this.mementos.containsKey(id);
    }

    @Override
    public long getNumberOfRecords() throws DataStoreException {
        this.throwExceptionIfClosed();
        return this.mementos.size();
    }

    @Override
    public boolean isClosed() {
        return this.closed;
    }

    @Override
    public void close() {
        this.closed = true;
    }

    public static NucleotideFastaFileDataStore create(File fastaFile) throws IOException {
        return IndexedNucleotideSequenceFastaFileDataStore.create(fastaFile, (Predicate<String>)DataStoreFilters.alwaysAccept(), null);
    }

    public static NucleotideFastaFileDataStore create(File fastaFile, Predicate<String> filter, Predicate<NucleotideFastaRecord> recordFilter) throws IOException {
        BuilderVisitor builder = IndexedNucleotideSequenceFastaFileDataStore.createBuilder(fastaFile, filter, recordFilter);
        builder.initialize();
        return builder.build();
    }

    public static NucleotideFastaFileDataStore create(FastaParser parser) throws IOException {
        return IndexedNucleotideSequenceFastaFileDataStore.create(parser, (Predicate<String>)DataStoreFilters.alwaysAccept(), null);
    }

    public static NucleotideFastaFileDataStore create(FastaParser parser, Predicate<String> filter, Predicate<NucleotideFastaRecord> recordFilter) throws IOException {
        BuilderVisitor builder = IndexedNucleotideSequenceFastaFileDataStore.createBuilder(parser, filter, recordFilter);
        builder.initialize();
        return builder.build();
    }

    private static BuilderVisitor createBuilder(File fastaFile, Predicate<String> filter, Predicate<NucleotideFastaRecord> recordFilter) throws IOException {
        if (filter == null) {
            throw new NullPointerException("filter can not be null");
        }
        return new BuilderVisitor(fastaFile, filter, recordFilter);
    }

    private static BuilderVisitor createBuilder(FastaParser parser, Predicate<String> filter, Predicate<NucleotideFastaRecord> recordFilter) throws IOException {
        if (filter == null) {
            throw new NullPointerException("filter can not be null");
        }
        if (parser == null) {
            throw new NullPointerException("parser can not be null");
        }
        return new BuilderVisitor(parser, filter, recordFilter);
    }

    private static class SingleRecordVisitor
    implements FastaVisitor {
        private NucleotideFastaRecord fastaRecord = null;

        private SingleRecordVisitor() {
        }

        @Override
        public FastaRecordVisitor visitDefline(FastaVisitorCallback callback, String id, String optionalComment) {
            if (this.fastaRecord != null) {
                callback.haltParsing();
                return null;
            }
            return new AbstractNucleotideFastaRecordVisitor(id, optionalComment){

                @Override
                protected void visitRecord(NucleotideFastaRecord fastaRecord) {
                    fastaRecord = fastaRecord;
                }
            };
        }

        @Override
        public void visitEnd() {
        }

        @Override
        public void halted() {
        }
    }

    private static final class BuilderVisitor
    implements FastaVisitor,
    Builder<NucleotideFastaFileDataStore> {
        private final Predicate<String> filter;
        private final Predicate<NucleotideFastaRecord> recordFilter;
        private final FastaParser parser;
        private final Map<String, FastaVisitorCallback.FastaVisitorMemento> mementos = new LinkedHashMap<String, FastaVisitorCallback.FastaVisitorMemento>();

        public BuilderVisitor(File fastaFile, Predicate<String> filter, Predicate<NucleotideFastaRecord> recordFilter) throws IOException {
            this(FastaFileParser.create(fastaFile), filter, recordFilter);
        }

        public BuilderVisitor(FastaParser parser, Predicate<String> filter, Predicate<NucleotideFastaRecord> recordFilter) {
            this.filter = filter;
            this.parser = parser;
            this.recordFilter = recordFilter;
        }

        public void initialize() throws IOException {
            this.parser.parse(this);
        }

        @Override
        public FastaRecordVisitor visitDefline(FastaVisitorCallback callback, final String id, String optionalComment) {
            if (this.filter.test(id)) {
                if (!callback.canCreateMemento()) {
                    throw new IllegalStateException("must be able to create memento");
                }
                final FastaVisitorCallback.FastaVisitorMemento memento = callback.createMemento();
                if (this.recordFilter == null) {
                    this.mementos.put(id, memento);
                    return null;
                }
                return new AbstractNucleotideFastaRecordVisitor(id, optionalComment){

                    @Override
                    protected void visitRecord(NucleotideFastaRecord fastaRecord) {
                        if (recordFilter.test(fastaRecord)) {
                            mementos.put(id, memento);
                        }
                    }
                };
            }
            return null;
        }

        @Override
        public void visitEnd() {
        }

        @Override
        public void halted() {
        }

        @Override
        public NucleotideFastaFileDataStore build() {
            return new IndexedNucleotideSequenceFastaFileDataStore(this.parser, this.filter, this.recordFilter, this.mementos);
        }
    }
}

