/*
 * Decompiled with CFR 0.152.
 */
package org.jcvi.jillion.fasta.nt;

import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import java.nio.charset.Charset;
import java.util.Objects;
import org.jcvi.jillion.core.io.IOUtil;
import org.jcvi.jillion.core.residue.nt.NucleotideSequenceBuilder;
import org.jcvi.jillion.internal.fasta.FastaUtil;

public final class FaiNucleotideWriterBuilder {
    private final File inputFasta;
    private File outputFai;
    private String eol = String.format("%n", new Object[0]);
    private Charset charset = Charset.defaultCharset();

    public FaiNucleotideWriterBuilder(File inputFasta) throws IOException {
        IOUtil.verifyIsReadable(inputFasta);
        this.inputFasta = inputFasta;
        this.outputFai = new File(inputFasta.getParentFile(), inputFasta.getName() + ".fai");
    }

    public FaiNucleotideWriterBuilder outputFile(File outputFai) {
        Objects.requireNonNull(outputFai);
        this.outputFai = outputFai;
        return this;
    }

    public FaiNucleotideWriterBuilder eol(String eol) {
        Objects.requireNonNull(eol);
        this.eol = eol;
        return this;
    }

    public FaiNucleotideWriterBuilder charset(Charset charset) {
        Objects.requireNonNull(charset);
        this.charset = charset;
        return this;
    }

    public File build() throws IOException {
        IOUtil.mkdirs(this.outputFai.getParentFile());
        try (PrintWriter writer = new PrintWriter(this.outputFai, this.charset.name());){
            FastaUtil.createIndex(this.inputFasta, writer, this.eol, line -> (int)new NucleotideSequenceBuilder((String)line).getLength());
        }
        return this.outputFai;
    }
}

