/*
 * Decompiled with CFR 0.152.
 */
package org.jcvi.jillion.fasta.nt;

import java.io.File;
import java.io.IOException;
import org.jcvi.jillion.core.residue.nt.NucleotideSequence;
import org.jcvi.jillion.fasta.nt.FaiNucleotideWriterBuilder;
import org.jcvi.jillion.fasta.nt.NucleotideFastaRecord;
import org.jcvi.jillion.fasta.nt.NucleotideFastaWriter;

class FaiNucleotideFastaWriter
implements NucleotideFastaWriter {
    private NucleotideFastaWriter delegate;
    private final File inputFasta;
    private final File outputfaiFile;
    private volatile boolean closed = false;

    public FaiNucleotideFastaWriter(File inputFasta, File outputfaiFile, NucleotideFastaWriter delegate) {
        this.inputFasta = inputFasta;
        this.outputfaiFile = outputfaiFile;
        this.delegate = delegate;
    }

    @Override
    public void close() throws IOException {
        if (!this.closed) {
            this.closed = true;
            this.delegate.close();
            new FaiNucleotideWriterBuilder(this.inputFasta).outputFile(this.outputfaiFile).build();
        }
    }

    @Override
    public void write(NucleotideFastaRecord record) throws IOException {
        this.delegate.write(record);
    }

    @Override
    public void write(String id, NucleotideSequence sequence) throws IOException {
        this.delegate.write(id, sequence);
    }

    @Override
    public void write(String id, NucleotideSequence sequence, String optionalComment) throws IOException {
        this.delegate.write(id, sequence, optionalComment);
    }
}

