/*
 * Decompiled with CFR 0.152.
 */
package org.jcvi.jillion.fasta.nt;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.Objects;
import java.util.Optional;
import org.jcvi.jillion.core.Range;
import org.jcvi.jillion.core.datastore.DataStoreClosedException;
import org.jcvi.jillion.core.datastore.DataStoreEntry;
import org.jcvi.jillion.core.datastore.DataStoreException;
import org.jcvi.jillion.core.io.IOUtil;
import org.jcvi.jillion.core.io.InputStreamSupplier;
import org.jcvi.jillion.core.residue.nt.NucleotideSequence;
import org.jcvi.jillion.core.util.iter.StreamingIterator;
import org.jcvi.jillion.core.util.streams.ThrowingBiConsumer;
import org.jcvi.jillion.fasta.nt.NucleotideFastaDataStore;
import org.jcvi.jillion.fasta.nt.NucleotideFastaFileDataStore;
import org.jcvi.jillion.fasta.nt.NucleotideFastaRecord;
import org.jcvi.jillion.internal.fasta.DefaultFastaIndex;
import org.jcvi.jillion.internal.fasta.FastaIndex;
import org.jcvi.jillion.internal.fasta.FastaIndexRecord;

class FaiNucleotideFastaFileDataStore
implements NucleotideFastaFileDataStore {
    private final InputStreamSupplier fastaFileSupplier;
    private final FastaIndex index;
    private final NucleotideFastaDataStore delegate;

    public static FaiNucleotideFastaFileDataStore create(File fastaFile, File faiFile, NucleotideFastaDataStore delegate) throws IOException {
        return new FaiNucleotideFastaFileDataStore(fastaFile, DefaultFastaIndex.parse(faiFile), delegate);
    }

    public FaiNucleotideFastaFileDataStore(File fastaFile, FastaIndex index, NucleotideFastaDataStore delegate) throws IOException {
        Objects.requireNonNull(delegate);
        Objects.requireNonNull(index);
        IOUtil.verifyIsReadable(fastaFile);
        this.fastaFileSupplier = InputStreamSupplier.forFile(fastaFile);
        this.delegate = delegate;
        this.index = index;
    }

    @Override
    public Optional<File> getFile() {
        return this.fastaFileSupplier.getFile();
    }

    private void throwExceptionIfClosed() {
        if (this.isClosed()) {
            throw new DataStoreClosedException("closed");
        }
    }

    @Override
    public NucleotideSequence getSequence(String id) throws DataStoreException {
        return this.getSequence(id, record -> record.newInputStream(this.fastaFileSupplier));
    }

    /*
     * Exception decompiling
     */
    private NucleotideSequence getSequence(String id, InputStreamFactory inputStreamFactory) throws DataStoreException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 3 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    @Override
    public NucleotideSequence getSubSequence(String id, long startOffset) throws DataStoreException {
        return this.getSequence(id, record -> record.newInputStream(this.fastaFileSupplier, startOffset));
    }

    @Override
    public NucleotideSequence getSubSequence(String id, Range includeRange) throws DataStoreException {
        return this.getSequence(id, record -> record.newInputStream(this.fastaFileSupplier, includeRange));
    }

    @Override
    public <E extends Throwable> void forEach(ThrowingBiConsumer<String, NucleotideFastaRecord, E> consumer) throws IOException, E {
        this.delegate.forEach(consumer);
    }

    @Override
    public StreamingIterator<String> idIterator() throws DataStoreException {
        return this.delegate.idIterator();
    }

    @Override
    public NucleotideFastaRecord get(String id) throws DataStoreException {
        return (NucleotideFastaRecord)this.delegate.get(id);
    }

    @Override
    public boolean contains(String id) throws DataStoreException {
        return this.delegate.contains(id);
    }

    @Override
    public long getNumberOfRecords() throws DataStoreException {
        return this.delegate.getNumberOfRecords();
    }

    @Override
    public boolean isClosed() {
        return this.delegate.isClosed();
    }

    @Override
    public StreamingIterator<NucleotideFastaRecord> iterator() throws DataStoreException {
        return this.delegate.iterator();
    }

    @Override
    public StreamingIterator<DataStoreEntry<NucleotideFastaRecord>> entryIterator() throws DataStoreException {
        return this.delegate.entryIterator();
    }

    @Override
    public void close() throws IOException {
        this.delegate.close();
    }

    private static interface InputStreamFactory {
        public InputStream get(FastaIndexRecord var1) throws IOException;
    }
}

