/*
 * Decompiled with CFR 0.152.
 */
package org.jcvi.jillion.fasta.nt;

import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.function.Predicate;
import org.jcvi.jillion.core.datastore.DataStoreFilter;
import org.jcvi.jillion.core.datastore.DataStoreFilters;
import org.jcvi.jillion.core.io.IOUtil;
import org.jcvi.jillion.core.residue.nt.NucleotideSequenceBuilder;
import org.jcvi.jillion.core.util.Builder;
import org.jcvi.jillion.fasta.FastaFileParser;
import org.jcvi.jillion.fasta.FastaParser;
import org.jcvi.jillion.fasta.FastaRecordVisitor;
import org.jcvi.jillion.fasta.FastaVisitor;
import org.jcvi.jillion.fasta.FastaVisitorCallback;
import org.jcvi.jillion.fasta.nt.NucleotideFastaFileDataStore;
import org.jcvi.jillion.fasta.nt.NucleotideFastaRecord;
import org.jcvi.jillion.fasta.nt.NucleotideFastaRecordBuilder;
import org.jcvi.jillion.internal.fasta.nt.AdaptedNucleotideFastaDataStore;

final class DefaultNucleotideFastaFileDataStore {
    private DefaultNucleotideFastaFileDataStore() {
    }

    private static NucleotideFastaDataStoreBuilderVisitorImpl2 createBuilder(Predicate<String> filter, Predicate<NucleotideFastaRecord> recordFilter) {
        return new NucleotideFastaDataStoreBuilderVisitorImpl2(filter, recordFilter);
    }

    public static NucleotideFastaFileDataStore create(File fastaFile) throws IOException {
        return DefaultNucleotideFastaFileDataStore.create(fastaFile, (Predicate<String>)DataStoreFilters.alwaysAccept(), null);
    }

    public static NucleotideFastaFileDataStore create(File fastaFile, Predicate<String> filter, Predicate<NucleotideFastaRecord> recordFilter) throws IOException {
        FastaParser parser = FastaFileParser.create(fastaFile);
        return DefaultNucleotideFastaFileDataStore.create(parser, filter, recordFilter);
    }

    public static NucleotideFastaFileDataStore create(FastaParser parser, Predicate<String> filter, Predicate<NucleotideFastaRecord> recordFilter) throws IOException {
        NucleotideFastaDataStoreBuilderVisitorImpl2 builder = DefaultNucleotideFastaFileDataStore.createBuilder(filter, recordFilter);
        if (parser instanceof FastaFileParser) {
            ((FastaFileParser)parser).getFile().ifPresent(file -> builder.setSourceFile((File)file));
        }
        parser.parse(builder);
        return builder.build();
    }

    public static NucleotideFastaFileDataStore create(InputStream in) throws IOException {
        return DefaultNucleotideFastaFileDataStore.create(in, DataStoreFilters.alwaysAccept(), null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static NucleotideFastaFileDataStore create(InputStream in, DataStoreFilter filter, Predicate<NucleotideFastaRecord> recordFilter) throws IOException {
        try {
            NucleotideFastaDataStoreBuilderVisitorImpl2 builder = DefaultNucleotideFastaFileDataStore.createBuilder(filter, recordFilter);
            FastaFileParser.create(in).parse(builder);
            NucleotideFastaFileDataStore nucleotideFastaFileDataStore = builder.build();
            return nucleotideFastaFileDataStore;
        }
        finally {
            IOUtil.closeAndIgnoreErrors((Closeable)in);
        }
    }

    private static final class NucleotideFastaDataStoreBuilderVisitorImpl2
    implements FastaVisitor,
    Builder<NucleotideFastaFileDataStore> {
        private final Map<String, NucleotideFastaRecord> fastaRecords = new LinkedHashMap<String, NucleotideFastaRecord>();
        private final Predicate<String> filter;
        private final ReusableNucleotideFastaRecordVisitor currentVisitor;
        private File fastaFile = null;

        public NucleotideFastaDataStoreBuilderVisitorImpl2(Predicate<String> filter, Predicate<NucleotideFastaRecord> recordFilter) {
            this.filter = filter;
            this.currentVisitor = new ReusableNucleotideFastaRecordVisitor(recordFilter);
        }

        @Override
        public FastaRecordVisitor visitDefline(FastaVisitorCallback callback, String id, String optionalComment) {
            if (!this.filter.test(id)) {
                return null;
            }
            this.currentVisitor.initialize(id, optionalComment);
            return this.currentVisitor;
        }

        public void setSourceFile(File fastaFile) {
            this.fastaFile = fastaFile;
        }

        @Override
        public void visitEnd() {
        }

        @Override
        public void halted() {
        }

        @Override
        public NucleotideFastaFileDataStore build() {
            return new AdaptedNucleotideFastaDataStore(this.fastaRecords, this.fastaFile);
        }

        private final class ReusableNucleotideFastaRecordVisitor
        implements FastaRecordVisitor {
            private String currentId;
            private String currentComment;
            private NucleotideSequenceBuilder builder;
            private final Predicate<NucleotideFastaRecord> recordFilter;

            public ReusableNucleotideFastaRecordVisitor(Predicate<NucleotideFastaRecord> recordFilter) {
                this.recordFilter = recordFilter;
            }

            public void initialize(String id, String optionalComment) {
                this.currentId = id;
                this.currentComment = optionalComment;
                this.builder = new NucleotideSequenceBuilder();
            }

            @Override
            public void visitBodyLine(String line) {
                this.builder.append(line);
            }

            @Override
            public void visitEnd() {
                NucleotideFastaRecord record = (NucleotideFastaRecord)((NucleotideFastaRecordBuilder)new NucleotideFastaRecordBuilder(this.currentId, this.builder.build()).comment(this.currentComment)).build();
                if (this.recordFilter == null || this.recordFilter.test(record)) {
                    NucleotideFastaDataStoreBuilderVisitorImpl2.this.fastaRecords.put(this.currentId, record);
                }
            }

            @Override
            public void halted() {
            }
        }
    }
}

