/*
 * Decompiled with CFR 0.152.
 */
package org.jcvi.jillion.fasta.aa;

import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.charset.Charset;
import java.util.Comparator;
import org.jcvi.jillion.core.datastore.DataStoreException;
import org.jcvi.jillion.core.residue.aa.AminoAcid;
import org.jcvi.jillion.core.residue.aa.ProteinSequence;
import org.jcvi.jillion.core.residue.aa.ProteinSequenceBuilder;
import org.jcvi.jillion.core.util.iter.StreamingIterator;
import org.jcvi.jillion.fasta.FastaWriter;
import org.jcvi.jillion.fasta.aa.ProteinFastaRecord;
import org.jcvi.jillion.fasta.aa.ProteinFastaRecordBuilder;
import org.jcvi.jillion.fasta.aa.ProteinFastaWriter;
import org.jcvi.jillion.internal.fasta.InMemorySortedFastaWriter;
import org.jcvi.jillion.internal.fasta.TmpDirSortedFastaWriter;
import org.jcvi.jillion.internal.fasta.aa.LargeProteinFastaFileDataStore;
import org.jcvi.jillion.shared.fasta.AbstractResidueFastaWriter;

public final class ProteinFastaWriterBuilder
extends AbstractResidueFastaWriter.Builder<AminoAcid, ProteinSequence, ProteinSequenceBuilder, ProteinFastaRecord, ProteinFastaWriter, ProteinFastaWriterBuilder> {
    public ProteinFastaWriterBuilder(File outputFile) throws IOException {
        super(outputFile);
    }

    public ProteinFastaWriterBuilder(OutputStream out) {
        super(out);
    }

    @Override
    protected ProteinFastaWriterBuilder getThis() {
        return this;
    }

    @Override
    protected ProteinFastaWriter createTmpDirSortedWriterWriter(FastaWriter<AminoAcid, ProteinSequence, ProteinFastaRecord> delegate, Comparator<ProteinFastaRecord> comparator, int cacheSize, File tmpDir) {
        return new TmpDirSortedProteinFastaWriter(delegate, comparator, cacheSize, tmpDir);
    }

    @Override
    protected ProteinFastaWriter createInMemorySortedWriterWriter(FastaWriter<AminoAcid, ProteinSequence, ProteinFastaRecord> delegate, Comparator<ProteinFastaRecord> comparator) {
        return new InMemorySortedProteinFastaWriter(delegate, comparator);
    }

    @Override
    protected ProteinFastaWriter create(OutputStream out, int numberOfResiduesPerLine, Charset charSet, String eol) {
        return new ProteinFastaWriterImpl(out, numberOfResiduesPerLine, charSet, eol);
    }

    private static final class TmpDirSortedProteinFastaWriter
    extends TmpDirSortedFastaWriter<AminoAcid, ProteinSequence, ProteinFastaRecord>
    implements ProteinFastaWriter {
        public TmpDirSortedProteinFastaWriter(FastaWriter<AminoAcid, ProteinSequence, ProteinFastaRecord> finalWriter, Comparator<ProteinFastaRecord> comparator, int cacheSize, File tmpDir) {
            super(finalWriter, comparator, tmpDir, cacheSize);
        }

        @Override
        protected StreamingIterator<ProteinFastaRecord> createStreamingIteratorFor(File tmpFastaFile) throws IOException, DataStoreException {
            return LargeProteinFastaFileDataStore.create(tmpFastaFile).iterator();
        }

        @Override
        protected FastaWriter<AminoAcid, ProteinSequence, ProteinFastaRecord> createNewTmpWriter(File tmpFile) throws IOException {
            return new ProteinFastaWriterBuilder(tmpFile).build();
        }

        @Override
        protected ProteinFastaRecord createFastaRecord(String id, ProteinSequence sequence, String optionalComment) {
            return (ProteinFastaRecord)((ProteinFastaRecordBuilder)new ProteinFastaRecordBuilder(id, sequence).comment(optionalComment)).build();
        }
    }

    private static final class InMemorySortedProteinFastaWriter
    extends InMemorySortedFastaWriter<AminoAcid, ProteinSequence, ProteinFastaRecord>
    implements ProteinFastaWriter {
        public InMemorySortedProteinFastaWriter(FastaWriter<AminoAcid, ProteinSequence, ProteinFastaRecord> writer, Comparator<ProteinFastaRecord> comparator) {
            super(writer, comparator);
        }

        @Override
        protected ProteinFastaRecord createRecord(String id, ProteinSequence sequence, String optionalComment) {
            return (ProteinFastaRecord)((ProteinFastaRecordBuilder)new ProteinFastaRecordBuilder(id, sequence).comment(optionalComment)).build();
        }
    }

    private static final class ProteinFastaWriterImpl
    extends AbstractResidueFastaWriter<AminoAcid, ProteinSequence, ProteinSequenceBuilder, ProteinFastaRecord>
    implements ProteinFastaWriter {
        private ProteinFastaWriterImpl(OutputStream out, int numberOfResiduesPerLine, Charset charSet, String eol) {
            super(out, numberOfResiduesPerLine, charSet, eol);
        }
    }
}

