/*
 * Decompiled with CFR 0.152.
 */
package org.jcvi.jillion.fasta.aa;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.function.Predicate;
import org.jcvi.jillion.core.datastore.DataStoreProviderHint;
import org.jcvi.jillion.core.io.InputStreamSupplier;
import org.jcvi.jillion.core.residue.aa.AminoAcid;
import org.jcvi.jillion.core.residue.aa.ProteinSequence;
import org.jcvi.jillion.core.residue.aa.ProteinSequenceDataStore;
import org.jcvi.jillion.fasta.FastaParser;
import org.jcvi.jillion.fasta.aa.ProteinFastaFileDataStore;
import org.jcvi.jillion.fasta.aa.ProteinFastaRecord;
import org.jcvi.jillion.internal.fasta.aa.DefaultProteinFastaDataStore;
import org.jcvi.jillion.internal.fasta.aa.IndexedProteinFastaFileDataStore;
import org.jcvi.jillion.internal.fasta.aa.LargeProteinFastaFileDataStore;
import org.jcvi.jillion.shared.fasta.AbstractFastaFileDataStoreBuilder;

public final class ProteinFastaFileDataStoreBuilder
extends AbstractFastaFileDataStoreBuilder<AminoAcid, ProteinSequence, ProteinFastaRecord, ProteinSequenceDataStore, ProteinFastaFileDataStore> {
    public ProteinFastaFileDataStoreBuilder(FastaParser parser) {
        super(parser);
    }

    public ProteinFastaFileDataStoreBuilder(File fastaFile) throws IOException {
        super(fastaFile);
    }

    public ProteinFastaFileDataStoreBuilder(InputStreamSupplier supplier) throws IOException {
        super(supplier);
    }

    public ProteinFastaFileDataStoreBuilder(InputStream in) throws IOException {
        super(in);
    }

    @Override
    protected ProteinFastaFileDataStore createNewInstance(FastaParser parser, DataStoreProviderHint hint, Predicate<String> filter, Predicate<ProteinFastaRecord> recordFilter) throws IOException {
        if (parser.isReadOnceOnly()) {
            return DefaultProteinFastaDataStore.create(parser, filter, recordFilter);
        }
        switch (hint) {
            case RANDOM_ACCESS_OPTIMIZE_SPEED: {
                return DefaultProteinFastaDataStore.create(parser, filter, recordFilter);
            }
            case RANDOM_ACCESS_OPTIMIZE_MEMORY: {
                return parser.canCreateMemento() ? IndexedProteinFastaFileDataStore.create(parser, filter, recordFilter) : DefaultProteinFastaDataStore.create(parser, filter, recordFilter);
            }
            case ITERATION_ONLY: {
                return LargeProteinFastaFileDataStore.create(parser, filter, recordFilter);
            }
        }
        throw new IllegalArgumentException("unknown provider hint :" + (Object)((Object)hint));
    }

    public ProteinFastaFileDataStoreBuilder filter(Predicate<String> filter) {
        super.filter(filter);
        return this;
    }

    public ProteinFastaFileDataStoreBuilder hint(DataStoreProviderHint hint) {
        super.hint(hint);
        return this;
    }

    public ProteinFastaFileDataStoreBuilder filterRecords(Predicate<ProteinFastaRecord> filter) {
        super.filterRecords(filter);
        return this;
    }

    @Override
    public ProteinFastaFileDataStore build() throws IOException {
        return (ProteinFastaFileDataStore)super.build();
    }
}

