/*
 * Decompiled with CFR 0.152.
 */
package org.jcvi.jillion.fasta;

import java.io.Closeable;
import java.io.IOException;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import org.jcvi.jillion.core.Sequence;
import org.jcvi.jillion.core.io.IOUtil;
import org.jcvi.jillion.fasta.FastaRecord;
import org.jcvi.jillion.fasta.FastaWriter;

public final class SplitFastaWriter {
    public static <S, T extends Sequence<S>, F extends FastaRecord<S, T>, W extends FastaWriter<S, T, F>> W roundRobin(Class<W> interfaceClass, int numberOfFiles, FastaRecordWriterFactory<W> supplier) {
        RoundRobinSplitFastaWriter writer = new RoundRobinSplitFastaWriter(numberOfFiles, supplier);
        return (W)((FastaWriter)Proxy.newProxyInstance(writer.getClass().getClassLoader(), new Class[]{interfaceClass}, new InvocationHandlerImpl(writer)));
    }

    public static <S, T extends Sequence<S>, F extends FastaRecord<S, T>, W extends FastaWriter<S, T, F>> W rollover(Class<W> interfaceClass, int maxRecordsPerFile, FastaRecordWriterFactory<W> supplier) {
        RolloverSplitFastaWriter writer = new RolloverSplitFastaWriter(maxRecordsPerFile, supplier);
        return (W)((FastaWriter)Proxy.newProxyInstance(writer.getClass().getClassLoader(), new Class[]{interfaceClass}, new InvocationHandlerImpl(writer)));
    }

    public static <S, T extends Sequence<S>, F extends FastaRecord<S, T>, W extends FastaWriter<S, T, F>, K> W deconvolve(Class<W> interfaceClass, Function<FastaRecord<S, T>, K> deconvolutionFunction, DeconvolveFastaRecordWriterFactory<K, W> supplier) {
        DeconvolutionFastaWriter writer = new DeconvolutionFastaWriter(deconvolutionFunction, supplier);
        return (W)((FastaWriter)Proxy.newProxyInstance(writer.getClass().getClassLoader(), new Class[]{interfaceClass}, new InvocationHandlerImpl(writer)));
    }

    private SplitFastaWriter() {
    }

    private static final class RoundRobinSplitFastaWriter<S, T extends Sequence<S>, F extends FastaRecord<S, T>, W extends FastaWriter<S, T, F>>
    implements FastaWriter<S, T, F> {
        private final FastaRecordWriterFactory<W> supplier;
        private int currentIndex = 0;
        private volatile boolean closed = false;
        private final FastaWriter<S, T, F>[] writers;

        private RoundRobinSplitFastaWriter(int numberOfFiles, FastaRecordWriterFactory<W> supplier) {
            Objects.requireNonNull(supplier);
            if (numberOfFiles < 1) {
                throw new IllegalArgumentException("records per File must be >=1");
            }
            this.writers = new FastaWriter[numberOfFiles];
            this.supplier = supplier;
        }

        private void checkNotClosed() throws IOException {
            if (this.closed) {
                throw new IOException("already closed");
            }
        }

        private W getCurrentWriter() throws IOException {
            this.checkNotClosed();
            FastaWriter writer = this.writers[this.currentIndex];
            if (writer == null) {
                this.writers[this.currentIndex] = writer = (FastaWriter)this.supplier.create(this.currentIndex + 1);
            }
            this.currentIndex = (this.currentIndex + 1) % this.writers.length;
            return (W)writer;
        }

        @Override
        public void close() throws IOException {
            if (!this.closed) {
                for (FastaWriter<S, T, F> writer : this.writers) {
                    IOUtil.closeAndIgnoreErrors(writer);
                }
            }
            this.closed = true;
        }

        @Override
        public void write(F record) throws IOException {
            this.getCurrentWriter().write(record);
        }

        @Override
        public void write(String id, T sequence) throws IOException {
            this.getCurrentWriter().write(id, sequence);
        }

        @Override
        public void write(String id, T sequence, String optionalComment) throws IOException {
            this.getCurrentWriter().write(id, sequence, optionalComment);
        }
    }

    private static final class RolloverSplitFastaWriter<S, T extends Sequence<S>, F extends FastaRecord<S, T>, W extends FastaWriter<S, T, F>>
    implements FastaWriter<S, T, F> {
        private final FastaRecordWriterFactory<W> supplier;
        private final int recordsPerFile;
        private int splitFileNumber = 0;
        private int currentRecordCount;
        private W currentWriter;
        private volatile boolean closed = false;

        private RolloverSplitFastaWriter(int recordsPerFile, FastaRecordWriterFactory<W> supplier) {
            Objects.requireNonNull(supplier);
            if (recordsPerFile < 1) {
                throw new IllegalArgumentException("records per File must be >=1");
            }
            this.supplier = supplier;
            this.recordsPerFile = recordsPerFile;
            this.currentRecordCount = recordsPerFile;
        }

        private void checkNotClosed() throws IOException {
            if (this.closed) {
                throw new IOException("already closed");
            }
        }

        @Override
        public void close() throws IOException {
            if (!this.closed && this.currentWriter != null) {
                this.currentWriter.close();
            }
            this.closed = true;
        }

        @Override
        public void write(F record) throws IOException {
            this.updateCurrentWriterIfNeeded();
            this.currentWriter.write(record);
            ++this.currentRecordCount;
        }

        private void updateCurrentWriterIfNeeded() throws IOException {
            this.checkNotClosed();
            if (this.currentRecordCount == this.recordsPerFile) {
                if (this.currentWriter != null) {
                    this.currentWriter.close();
                }
                ++this.splitFileNumber;
                this.currentRecordCount = 0;
                this.currentWriter = (FastaWriter)this.supplier.create(this.splitFileNumber);
            }
        }

        @Override
        public void write(String id, T sequence) throws IOException {
            this.updateCurrentWriterIfNeeded();
            this.currentWriter.write(id, sequence);
            ++this.currentRecordCount;
        }

        @Override
        public void write(String id, T sequence, String optionalComment) throws IOException {
            this.updateCurrentWriterIfNeeded();
            this.currentWriter.write(id, sequence, optionalComment);
            ++this.currentRecordCount;
        }
    }

    private static final class DeconvolutionFastaWriter<S, T extends Sequence<S>, F extends FastaRecord<S, T>, W extends FastaWriter<S, T, F>, K>
    implements FastaWriter<S, T, F> {
        private volatile boolean closed = false;
        private final Map<K, W> writers = new HashMap<K, W>();
        private final Function<FastaRecord<S, T>, K> deconvolutionFunction;
        private final DeconvolveFastaRecordWriterFactory<K, W> supplier;

        public DeconvolutionFastaWriter(Function<FastaRecord<S, T>, K> deconvolutionFunction, DeconvolveFastaRecordWriterFactory<K, W> supplier) {
            Objects.requireNonNull(deconvolutionFunction);
            Objects.requireNonNull(supplier);
            this.deconvolutionFunction = deconvolutionFunction;
            this.supplier = supplier;
        }

        @Override
        public void close() throws IOException {
            if (this.closed) {
                return;
            }
            this.closed = true;
            for (FastaWriter writer : this.writers.values()) {
                IOUtil.closeAndIgnoreErrors((Closeable)writer);
            }
        }

        private void checkNotClosed() throws IOException {
            if (this.closed) {
                throw new IOException("already closed");
            }
        }

        @Override
        public void write(F record) throws IOException {
            this.privateWrite((FastaRecord<S, T>)record);
        }

        private void privateWrite(FastaRecord<S, T> record) throws IOException {
            this.checkNotClosed();
            Objects.requireNonNull(record);
            K key = this.deconvolutionFunction.apply(record);
            if (key == null) {
                return;
            }
            FastaWriter writer = (FastaWriter)this.writers.get(key);
            if (writer == null) {
                writer = (FastaWriter)this.supplier.create(key);
                this.writers.put(key, writer);
            }
            writer.write(record.getId(), record.getSequence(), record.getComment());
        }

        @Override
        public void write(String id, T sequence) throws IOException {
            this.write(id, sequence, null);
        }

        @Override
        public void write(String id, T sequence, String optionalComment) throws IOException {
            Objects.requireNonNull(id, "id can not be null");
            Objects.requireNonNull(sequence, "sequence can not be null");
            FastaRecordImpl record = new FastaRecordImpl(id, optionalComment, sequence);
            this.privateWrite(record);
        }
    }

    private static final class InvocationHandlerImpl<S, T extends Sequence<S>, F extends FastaRecord<S, T>, W extends FastaWriter<S, T, F>>
    implements InvocationHandler {
        private final FastaWriter<S, T, F> delegate;

        @Override
        public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
            String name = method.getName();
            if ("write".equals(name)) {
                if (args.length == 1) {
                    this.delegate.write((FastaRecord)args[0]);
                    return null;
                }
                if (args.length == 2) {
                    this.delegate.write((String)args[0], (Sequence)args[1]);
                    return null;
                }
                if (args.length == 3) {
                    this.delegate.write((String)args[0], (Sequence)args[1], (String)args[2]);
                    return null;
                }
            }
            return method.invoke(this.delegate, args);
        }

        public InvocationHandlerImpl(FastaWriter<S, T, F> delegate) {
            this.delegate = delegate;
        }
    }

    private static final class FastaRecordImpl<S, T extends Sequence<S>>
    implements FastaRecord<S, T> {
        private final String id;
        private final String comment;
        private final T sequence;

        public FastaRecordImpl(String id, String comment, T sequence) {
            this.id = id;
            this.comment = comment;
            this.sequence = sequence;
        }

        @Override
        public String getId() {
            return this.id;
        }

        @Override
        public String getComment() {
            return this.comment;
        }

        @Override
        public T getSequence() {
            return this.sequence;
        }
    }

    @FunctionalInterface
    public static interface DeconvolveFastaRecordWriterFactory<K, T> {
        public T create(K var1) throws IOException;
    }

    @FunctionalInterface
    public static interface FastaRecordWriterFactory<T> {
        public T create(int var1) throws IOException;
    }
}

