/*
 * Decompiled with CFR 0.152.
 */
package org.jcvi.jillion.fasta;

import java.io.IOException;
import java.util.Objects;
import org.jcvi.jillion.core.Sequence;
import org.jcvi.jillion.fasta.FastaRecord;
import org.jcvi.jillion.fasta.FastaWriter;

class FastaWriterAdapterImpl<S, T extends Sequence<S>, F extends FastaRecord<S, T>>
implements FastaWriter<S, T, F> {
    private final FastaWriter<S, T, F> delegate;
    private final FastaWriter.FastaRecordAdapter<S, T, F> adapter;

    public FastaWriterAdapterImpl(FastaWriter<S, T, F> delegate, FastaWriter.FastaRecordAdapter<S, T, F> adapter) {
        this.delegate = Objects.requireNonNull(delegate);
        this.adapter = Objects.requireNonNull(adapter);
    }

    @Override
    public void close() throws IOException {
        this.delegate.close();
    }

    @Override
    public void write(String id, T sequence, String optionalComment) throws IOException {
        F adapted = this.adapter.adapt(id, sequence, optionalComment);
        if (adapted != null) {
            this.delegate.write(adapted);
        }
    }
}

