/*
 * Decompiled with CFR 0.152.
 */
package org.jcvi.jillion.fasta;

import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jcvi.jillion.core.io.IOUtil;
import org.jcvi.jillion.core.io.InputStreamSupplier;
import org.jcvi.jillion.fasta.FastaParser;
import org.jcvi.jillion.fasta.FastaRecordVisitor;
import org.jcvi.jillion.fasta.FastaVisitor;
import org.jcvi.jillion.fasta.FastaVisitorCallback;
import org.jcvi.jillion.internal.core.io.LineParser;
import org.jcvi.jillion.internal.core.io.OpenAwareInputStream;
import org.jcvi.jillion.internal.core.io.TextLineParser;

public abstract class FastaFileParser
implements FastaParser {
    private static final Pattern DEFLINE_LINE_PATTERN = Pattern.compile("^>(\\S+)(\\s+(.*))?");
    private static final Pattern REDUNDANT_DEFLINE_LINE_PATTERN = Pattern.compile("^(\\S+)(\\s+(.*))?");
    private static final char CONTROL_A = '\u0001';

    public static FastaParser create(File fastaFile) throws IOException {
        return new FileFastaParser(fastaFile);
    }

    public static FastaParser create(InputStreamSupplier inputStreamSupplier) throws IOException {
        return new FileFastaParser(inputStreamSupplier);
    }

    public static FastaParser create(InputStream inputStream) {
        return new InputStreamFastaParser(inputStream);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void parse(FastaVisitor visitor) throws IOException {
        this.checkNotNull(visitor);
        InputStream in = null;
        try {
            in = this.getInputStream();
            TextLineParser parser = new TextLineParser(in);
            this.parseFile(parser, visitor);
        }
        finally {
            IOUtil.closeAndIgnoreErrors((Closeable)in);
        }
    }

    protected abstract InputStream getInputStream() throws IOException;

    public abstract Optional<File> getFile();

    protected void checkNotNull(FastaVisitor visitor) {
        if (visitor == null) {
            throw new NullPointerException("visitor can not be null");
        }
    }

    final void parseFile(TextLineParser parser, FastaVisitor visitor) throws IOException {
        this.parseFile(parser, visitor, 0);
    }

    final void parseFile(TextLineParser parser, FastaVisitor visitor, int initialRedundantIndex) throws IOException {
        AtomicBoolean keepParsing = new AtomicBoolean(true);
        FastaRecordVisitor recordVisitor = null;
        long currentOffset = parser.getPosition();
        AbstractFastaVisitorCallback callback = this.createNewCallback(currentOffset, keepParsing);
        int currentInitialRedundantStartIndex = initialRedundantIndex;
        while (keepParsing.get() && parser.hasNextLine()) {
            String line = parser.nextLine();
            String trimmedLine = line.trim();
            if (!trimmedLine.isEmpty()) {
                Matcher matcher = DEFLINE_LINE_PATTERN.matcher(trimmedLine);
                if (matcher.find()) {
                    if (recordVisitor != null) {
                        recordVisitor.visitEnd();
                        if (!keepParsing.get()) {
                            recordVisitor = null;
                            continue;
                        }
                    }
                    if (line.indexOf(1) == -1) {
                        String id = matcher.group(1);
                        String comment = matcher.group(3);
                        callback = this.createNewCallback(currentOffset, keepParsing);
                        recordVisitor = visitor.visitDefline(callback, id, comment);
                    } else {
                        this.handleNonRedundantRecord(parser, trimmedLine, visitor, currentOffset, keepParsing, currentInitialRedundantStartIndex);
                        currentInitialRedundantStartIndex = 0;
                    }
                } else if (recordVisitor != null) {
                    recordVisitor.visitBodyLine(line);
                }
            }
            currentOffset = parser.getPosition();
        }
        this.handleEndOfFile(visitor, keepParsing, recordVisitor);
    }

    private void handleNonRedundantRecord(LineParser parser, String defline, FastaVisitor visitor, long offsetOfBeginningOfDefline, AtomicBoolean keepParsing, int initialRedundantStartIndex) throws IOException {
        String nextLine;
        String[] redundantDeflines = defline.substring(1).split("[\u0001]");
        ArrayList<String> bodyLines = new ArrayList<String>();
        while (parser.hasNextLine() && (nextLine = parser.peekLine()).charAt(0) != '>') {
            bodyLines.add(parser.nextLine());
        }
        for (int i = initialRedundantStartIndex; keepParsing.get() && i < redundantDeflines.length; ++i) {
            String redundantDefline = redundantDeflines[i];
            Matcher matcher = REDUNDANT_DEFLINE_LINE_PATTERN.matcher(redundantDefline);
            if (!matcher.find()) {
                throw new IOException("error parsing redundant defline [" + i + "] from " + defline);
            }
            String id = matcher.group(1);
            String comment = matcher.group(3);
            AbstractFastaVisitorCallback redundantCallback = this.createNewRedundantCallback(offsetOfBeginningOfDefline, i, keepParsing);
            FastaRecordVisitor recordVisitor = visitor.visitDefline(redundantCallback, id, comment);
            if (recordVisitor == null) continue;
            for (int j = 0; keepParsing.get() && j < bodyLines.size(); ++j) {
                recordVisitor.visitBodyLine((String)bodyLines.get(j));
            }
            if (keepParsing.get()) {
                recordVisitor.visitEnd();
                continue;
            }
            recordVisitor.halted();
        }
    }

    protected void handleEndOfFile(FastaVisitor visitor, AtomicBoolean keepParsing, FastaRecordVisitor recordVisitor) {
        if (recordVisitor != null) {
            if (keepParsing.get()) {
                recordVisitor.visitEnd();
            } else {
                recordVisitor.halted();
            }
        }
        if (keepParsing.get()) {
            visitor.visitEnd();
        } else {
            visitor.halted();
        }
    }

    protected abstract AbstractFastaVisitorCallback createNewCallback(long var1, AtomicBoolean var3);

    protected abstract AbstractFastaVisitorCallback createNewRedundantCallback(long var1, int var3, AtomicBoolean var4);

    private static class InputStreamFastaParser
    extends FastaFileParser {
        private final OpenAwareInputStream inputStream;
        private boolean hasParsedBefore = false;

        public InputStreamFastaParser(InputStream inputStream) {
            this.inputStream = new OpenAwareInputStream(inputStream);
        }

        @Override
        protected AbstractFastaVisitorCallback createNewCallback(long currentOffset, AtomicBoolean keepParsing) {
            return new NoMementoCallback(keepParsing);
        }

        @Override
        protected AbstractFastaVisitorCallback createNewRedundantCallback(long offsetOfBeginningOfDefline, int i, AtomicBoolean keepParsing) {
            return new NoMementoCallback(keepParsing);
        }

        @Override
        public boolean isReadOnceOnly() {
            return true;
        }

        @Override
        public synchronized void parse(FastaVisitor visitor) throws IOException {
            super.parse(visitor);
        }

        @Override
        public void parse(FastaVisitor visitor, FastaVisitorCallback.FastaVisitorMemento memento) throws IOException {
            throw new UnsupportedOperationException("can not use mementos with inputstream");
        }

        @Override
        protected InputStream getInputStream() throws IOException {
            if (!this.hasParsedBefore) {
                return this.inputStream;
            }
            this.hasParsedBefore = true;
            if (this.canParse()) {
                return this.inputStream;
            }
            throw new IllegalStateException("can not accept visitor - inputstream is closed");
        }

        @Override
        public boolean canParse() {
            return this.inputStream.isOpen();
        }

        @Override
        public boolean canCreateMemento() {
            return false;
        }

        @Override
        public Optional<File> getFile() {
            return Optional.empty();
        }
    }

    private static class FileFastaParser
    extends FastaFileParser {
        private final InputStreamSupplier fileSupplier;
        private final File fastaFile;

        public FileFastaParser(File fastaFile) throws IOException {
            this.fileSupplier = InputStreamSupplier.forFile(fastaFile);
            this.fastaFile = fastaFile;
        }

        public FileFastaParser(InputStreamSupplier fileSupplier) {
            Objects.requireNonNull(fileSupplier);
            this.fileSupplier = fileSupplier;
            this.fastaFile = null;
        }

        @Override
        public Optional<File> getFile() {
            return Optional.ofNullable(this.fastaFile);
        }

        @Override
        public boolean isReadOnceOnly() {
            return false;
        }

        @Override
        public boolean canCreateMemento() {
            return true;
        }

        @Override
        protected AbstractFastaVisitorCallback createNewCallback(long currentOffset, AtomicBoolean keepParsing) {
            return new MementoCallback(currentOffset, keepParsing);
        }

        @Override
        public void parse(FastaVisitor visitor, FastaVisitorCallback.FastaVisitorMemento memento) throws IOException {
            if (!(memento instanceof OffsetMemento)) {
                throw new IllegalStateException("unknown memento instance : " + memento);
            }
            long startOffset = ((OffsetMemento)memento).getOffset();
            try (InputStream inputStream = this.fileSupplier.get(startOffset);){
                TextLineParser parser = new TextLineParser(inputStream, startOffset);
                if (memento instanceof RedundantOffsetMemento) {
                    int redundantIndex = ((RedundantOffsetMemento)memento).getRedundantIndex();
                    this.parseFile(parser, visitor, redundantIndex);
                } else {
                    this.parseFile(parser, visitor);
                }
            }
        }

        @Override
        protected InputStream getInputStream() throws IOException {
            return this.fileSupplier.get();
        }

        @Override
        public boolean canParse() {
            return true;
        }

        @Override
        protected AbstractFastaVisitorCallback createNewRedundantCallback(long offsetOfBeginningOfDefline, int redundantIndex, AtomicBoolean keepParsing) {
            return new RedundantMementoCallback(offsetOfBeginningOfDefline, redundantIndex, keepParsing);
        }
    }

    private static class RedundantOffsetMemento
    extends OffsetMemento {
        private final int redundantIndex;

        public RedundantOffsetMemento(long offset, int redundantIndex) {
            super(offset);
            this.redundantIndex = redundantIndex;
        }

        public int getRedundantIndex() {
            return this.redundantIndex;
        }
    }

    private static class OffsetMemento
    implements FastaVisitorCallback.FastaVisitorMemento {
        private final long offset;

        public OffsetMemento(long offset) {
            this.offset = offset;
        }

        public final long getOffset() {
            return this.offset;
        }
    }

    private static class RedundantMementoCallback
    extends AbstractFastaVisitorCallback {
        private final long offset;
        private final int redundantIndex;

        public RedundantMementoCallback(long offset, int redundantIndex, AtomicBoolean keepParsing) {
            super(keepParsing);
            this.offset = offset;
            this.redundantIndex = redundantIndex;
        }

        @Override
        public boolean canCreateMemento() {
            return true;
        }

        @Override
        public FastaVisitorCallback.FastaVisitorMemento createMemento() {
            return new RedundantOffsetMemento(this.offset, this.redundantIndex);
        }
    }

    private static class MementoCallback
    extends AbstractFastaVisitorCallback {
        private final long offset;

        public MementoCallback(long offset, AtomicBoolean keepParsing) {
            super(keepParsing);
            this.offset = offset;
        }

        @Override
        public boolean canCreateMemento() {
            return true;
        }

        @Override
        public FastaVisitorCallback.FastaVisitorMemento createMemento() {
            return new OffsetMemento(this.offset);
        }
    }

    private static class NoMementoCallback
    extends AbstractFastaVisitorCallback {
        public NoMementoCallback(AtomicBoolean keepParsing) {
            super(keepParsing);
        }

        @Override
        public boolean canCreateMemento() {
            return false;
        }

        @Override
        public FastaVisitorCallback.FastaVisitorMemento createMemento() {
            throw new UnsupportedOperationException("can not create memento");
        }
    }

    private static abstract class AbstractFastaVisitorCallback
    implements FastaVisitorCallback {
        private final AtomicBoolean keepParsing;

        public AbstractFastaVisitorCallback(AtomicBoolean keepParsing) {
            this.keepParsing = keepParsing;
        }

        @Override
        public void haltParsing() {
            this.keepParsing.set(false);
        }
    }
}

