/*
 * Decompiled with CFR 0.152.
 */
package org.jcvi.jillion.fasta;

import java.util.Objects;
import org.jcvi.jillion.core.Range;
import org.jcvi.jillion.core.Sequence;
import org.jcvi.jillion.core.SequenceBuilder;
import org.jcvi.jillion.core.datastore.DataStore;
import org.jcvi.jillion.core.datastore.DataStoreException;
import org.jcvi.jillion.fasta.FastaRecord;

public interface FastaDataStore<S, T extends Sequence<S>, F extends FastaRecord<S, T>, D extends DataStore<T>>
extends DataStore<F> {
    default public T getSequence(String id) throws DataStoreException {
        FastaRecord record = (FastaRecord)this.get(id);
        if (record == null) {
            return null;
        }
        return record.getSequence();
    }

    default public T getSubSequence(String id, long startOffset) throws DataStoreException {
        if (startOffset < 0L) {
            throw new IllegalArgumentException("start offset can not be negative");
        }
        FastaRecord record = (FastaRecord)this.get(id);
        if (record == null) {
            return null;
        }
        SequenceBuilder builder = record.getSequence().toBuilder();
        if (builder.getLength() - 1L < startOffset) {
            throw new IllegalArgumentException("start offset is beyond sequence length : " + startOffset);
        }
        return (T)builder.delete(Range.ofLength(startOffset)).build();
    }

    default public T getSubSequence(String id, Range includeRange) throws DataStoreException {
        Objects.requireNonNull(includeRange);
        FastaRecord record = (FastaRecord)this.get(id);
        if (record == null) {
            return null;
        }
        return (T)record.getSequence().toBuilder().trim(includeRange).build();
    }

    public D asSequenceDataStore();
}

