/*
 * Decompiled with CFR 0.152.
 */
package org.jcvi.jillion.experimental.trace.archive2;

import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.jcvi.jillion.core.io.IOUtil;
import org.jcvi.jillion.experimental.trace.archive2.DefaultTraceArchiveInfo;
import org.jcvi.jillion.experimental.trace.archive2.DefaultTraceArchiveRecord;
import org.jcvi.jillion.experimental.trace.archive2.TraceArchiveInfo;
import org.jcvi.jillion.experimental.trace.archive2.TraceArchiveRecord;
import org.jcvi.jillion.experimental.trace.archive2.TraceInfoField;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public final class XmlTraceArchiveInfoFactory {
    private XmlTraceArchiveInfoFactory() {
    }

    public static TraceArchiveInfo create(File traceinfoXml) throws IOException {
        TraceArchiveInfo traceArchiveInfo;
        DefaultTraceArchiveInfo.Builder builder = new DefaultTraceArchiveInfo.Builder();
        TraceInfoParser parser = new TraceInfoParser(builder);
        SAXParserFactory factory = SAXParserFactory.newInstance();
        FileInputStream inputStream = null;
        try {
            inputStream = new FileInputStream(traceinfoXml);
            SAXParser saxParser = factory.newSAXParser();
            saxParser.parse((InputStream)inputStream, (DefaultHandler)parser);
            traceArchiveInfo = builder.build();
        }
        catch (Throwable t) {
            try {
                throw new IOException("error parsing traceInfo", t);
            }
            catch (Throwable throwable) {
                IOUtil.closeAndIgnoreErrors(inputStream);
                throw throwable;
            }
        }
        IOUtil.closeAndIgnoreErrors((Closeable)inputStream);
        return traceArchiveInfo;
    }

    private static class TraceInfoParser
    extends DefaultHandler {
        private final DefaultTraceArchiveInfo.Builder instance;
        private DefaultTraceArchiveRecord.Builder currentArchiveRecordBuilder;
        private String currentAttributeName;
        private boolean inExtendedData = false;
        private StringBuilder characterBuffer = new StringBuilder();

        public TraceInfoParser(DefaultTraceArchiveInfo.Builder instance) {
            this.instance = instance;
        }

        @Override
        public void characters(char[] ch, int start, int length) throws SAXException {
            if (this.characterBuffer != null) {
                this.characterBuffer.append(new String(ch, start, length));
            }
        }

        @Override
        public void endElement(String uri, String localName, String name) throws SAXException {
            String elementName = this.getElementName(localName, name);
            if (this.inExtendedData && TraceInfoField.EXTENDED_DATA.toString().equals(elementName)) {
                this.inExtendedData = false;
                this.characterBuffer = null;
            } else if (this.characterBuffer != null && this.currentArchiveRecordBuilder != null && this.currentAttributeName != null) {
                if (this.inExtendedData) {
                    this.currentArchiveRecordBuilder.putExtendedData(this.currentAttributeName, this.characterBuffer.toString());
                } else {
                    this.currentArchiveRecordBuilder.put(TraceInfoField.parseTraceInfoField(this.currentAttributeName), this.characterBuffer.toString());
                }
                this.characterBuffer = null;
            }
            if ("trace".equals(elementName)) {
                TraceArchiveRecord record = this.currentArchiveRecordBuilder.build();
                this.instance.addRecord(record);
                this.currentArchiveRecordBuilder = null;
                this.currentAttributeName = null;
            }
        }

        @Override
        public void startElement(String uri, String localName, String name, Attributes attributes) throws SAXException {
            String elementName = this.getElementName(localName, name);
            if (TraceInfoField.EXTENDED_DATA.toString().equals(elementName)) {
                this.inExtendedData = true;
            }
            if ("trace".equals(elementName)) {
                this.currentArchiveRecordBuilder = new DefaultTraceArchiveRecord.Builder();
            } else if (this.currentArchiveRecordBuilder != null) {
                this.currentAttributeName = this.inExtendedData ? attributes.getValue("name") : elementName;
                this.characterBuffer = new StringBuilder();
            }
        }

        private String getElementName(String localName, String name) {
            String elementName = localName;
            if ("".equals(elementName)) {
                elementName = name;
            }
            return elementName;
        }
    }
}

