/*
 * Decompiled with CFR 0.152.
 */
package org.jcvi.jillion.experimental.trace.archive2;

import java.io.IOException;
import java.io.OutputStream;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.Locale;
import java.util.Map;
import java.util.TreeMap;
import org.jcvi.jillion.core.io.IOUtil;
import org.jcvi.jillion.experimental.trace.archive2.TraceArchiveInfo;
import org.jcvi.jillion.experimental.trace.archive2.TraceArchiveRecord;
import org.jcvi.jillion.experimental.trace.archive2.TraceInfoField;

public final class TraceInfoWriterUtil {
    private static final String BEGIN_XML = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n<trace_volume>\n";
    private static final String END_XML = "</trace_volume>\n";
    private static final DateFormat TRACE_ARCHIVE_DATE_FORMAT = new SimpleDateFormat("yyyy-mm-dd-HH:mm:ss", Locale.US);

    private TraceInfoWriterUtil() {
    }

    public static synchronized String formatDate(Date date) {
        return TRACE_ARCHIVE_DATE_FORMAT.format(date);
    }

    public static void writeTraceInfoXML(OutputStream out, TraceArchiveInfo info, String volumeName, Date volumeDate, String volumeVersion) throws IOException {
        TraceInfoWriterUtil.writeTraceInfoXML(out, info, volumeName, volumeDate, volumeVersion, true);
    }

    public static void writeTraceInfoXML(OutputStream out, TraceArchiveInfo info, String volumeName, Date volumeDate, String volumeVersion, boolean duplicateCommonSections) throws IOException {
        TraceInfoWriterUtil.writeString(out, BEGIN_XML);
        TraceInfoWriterUtil.writeString(out, "\t" + TraceInfoWriterUtil.beginAndEndTag("volume_name", volumeName));
        TraceInfoWriterUtil.writeString(out, "\t" + TraceInfoWriterUtil.beginAndEndTag("volume_date", TraceInfoWriterUtil.formatDate(volumeDate)));
        TraceInfoWriterUtil.writeString(out, "\t" + TraceInfoWriterUtil.beginAndEndTag("volume_version", volumeVersion));
        Map<TraceInfoField, String> commonMap = info.getCommonFields();
        if (!duplicateCommonSections && !commonMap.isEmpty()) {
            TraceInfoWriterUtil.writeString(out, TraceInfoWriterUtil.beginTag("common_fields"));
            for (Map.Entry entry : commonMap.entrySet()) {
                TraceInfoWriterUtil.writeString(out, "\t" + TraceInfoWriterUtil.beginAndEndTag(entry.getKey(), entry.getValue()));
            }
            TraceInfoWriterUtil.writeString(out, TraceInfoWriterUtil.endTag("common_fields"));
        }
        for (TraceArchiveRecord traceArchiveRecord : info.getRecordList()) {
            TraceInfoWriterUtil.writeString(out, "\t" + TraceInfoWriterUtil.beginTag("trace"));
            Map<TraceInfoField, String> entries = duplicateCommonSections ? TraceInfoWriterUtil.getEntiresToWrite(traceArchiveRecord, commonMap) : TraceInfoWriterUtil.getEntiresToWrite(traceArchiveRecord);
            for (Map.Entry<TraceInfoField, String> entry : entries.entrySet()) {
                TraceInfoWriterUtil.writeString(out, "\t\t" + TraceInfoWriterUtil.beginAndEndTag((Object)entry.getKey(), entry.getValue()));
            }
            TraceInfoWriterUtil.writeExtendedData(out, traceArchiveRecord);
            TraceInfoWriterUtil.writeString(out, "\t" + TraceInfoWriterUtil.endTag("trace"));
        }
        TraceInfoWriterUtil.writeString(out, END_XML);
    }

    private static Map<TraceInfoField, String> getEntiresToWrite(TraceArchiveRecord record) {
        return TraceInfoWriterUtil.getEntiresToWrite(record, Collections.emptyMap());
    }

    private static Map<TraceInfoField, String> getEntiresToWrite(TraceArchiveRecord record, Map<TraceInfoField, String> commonMap) {
        TreeMap<TraceInfoField, String> list = new TreeMap<TraceInfoField, String>(new Comparator<TraceInfoField>(){

            @Override
            public int compare(TraceInfoField o1, TraceInfoField o2) {
                return o1.name().compareTo(o2.name());
            }
        });
        if (!commonMap.isEmpty()) {
            list.putAll(commonMap);
        }
        for (Map.Entry<TraceInfoField, String> entry : record.entrySet()) {
            list.put(entry.getKey(), entry.getValue());
        }
        return list;
    }

    private static void writeExtendedData(OutputStream out, TraceArchiveRecord record) throws IOException {
        Map<String, String> extendedData = record.getExtendedData();
        if (!extendedData.isEmpty()) {
            TraceInfoWriterUtil.writeString(out, TraceInfoWriterUtil.beginTag((Object)TraceInfoField.EXTENDED_DATA));
            for (Map.Entry<String, String> extendedEntry : extendedData.entrySet()) {
                TraceInfoWriterUtil.writeString(out, String.format("\t<field name='%s'>%s</field>%n", extendedEntry.getKey(), extendedEntry.getValue()));
            }
            TraceInfoWriterUtil.writeString(out, TraceInfoWriterUtil.endTag((Object)TraceInfoField.EXTENDED_DATA));
        }
    }

    private static void writeString(OutputStream out, String value) throws IOException {
        out.write(value.getBytes(IOUtil.UTF_8));
    }

    private static String beginAndEndTag(Object key, Object value) {
        return String.format("<%s>%s</%s>%n", key, value, key);
    }

    private static String beginTag(Object value) {
        return String.format("<%s>%n", value);
    }

    private static String endTag(Object value) {
        return String.format("</%s>%n", value);
    }
}

