/*
 * Decompiled with CFR 0.152.
 */
package org.jcvi.jillion.experimental.trace.archive2;

import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintWriter;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Collections;
import java.util.Date;
import java.util.HashSet;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import org.jcvi.jillion.core.io.IOUtil;
import org.jcvi.jillion.core.util.DateUtil;
import org.jcvi.jillion.experimental.trace.archive2.DefaultTraceArchiveInfo;
import org.jcvi.jillion.experimental.trace.archive2.DefaultTraceArchiveRecord;
import org.jcvi.jillion.experimental.trace.archive2.TraceArchiveInfo;
import org.jcvi.jillion.experimental.trace.archive2.TraceArchiveRecordBuilder;
import org.jcvi.jillion.experimental.trace.archive2.TraceInfoField;
import org.jcvi.jillion.experimental.trace.archive2.TraceInfoWriterUtil;
import org.jcvi.jillion.fasta.nt.NucleotideFastaWriter;
import org.jcvi.jillion.fasta.nt.NucleotideFastaWriterBuilder;
import org.jcvi.jillion.fasta.pos.PositionFastaWriter;
import org.jcvi.jillion.fasta.pos.PositionFastaWriterBuilder;
import org.jcvi.jillion.fasta.qual.QualityFastaWriter;
import org.jcvi.jillion.fasta.qual.QualityFastaWriterBuilder;
import org.jcvi.jillion.trace.chromat.Chromatogram;
import org.jcvi.jillion.trace.chromat.ChromatogramFactory;

public final class TraceArchiveWriter
implements Closeable {
    private static final String README_TEXT = "JCVI Trace Volume Generated: %s%nIn instances where two basecallers are reported both callers were used in%nconjuction to create the basecall and/or assign quality values.%n%nThis volume contains:%n. MD5            MD5 file signatures%n. README         This file%n. TRACEINFO.XML  Auxiliary information in XML format%n. fasta          directory containing basecalls%n. peak           directory containing peak index values%n. qual           directory containing quality scores%n. traces         directory containing %d trace file(s)%n";
    private static final DateFormat DATE_TIME_FORMATTER = new SimpleDateFormat("yyyy-MM-dd-HH:mm:ss", Locale.US);
    private final File rootDir;
    private final TraceArchiveRecordCallback recordCallback;
    private final DefaultTraceArchiveInfo.Builder traceInfoBuilder;
    private final Set<String> traceNamesSeen = new HashSet<String>();
    private final String volumeName;
    private final String volumeVersion;
    private final Date volumeDate;

    public TraceArchiveWriter(File rootDir, TraceArchiveRecordCallback recordFactory, String volumeName, Date volumeDate, String volumeVersion) throws IOException {
        this(rootDir, Collections.emptyMap(), recordFactory, volumeName, volumeDate, volumeVersion);
    }

    public TraceArchiveWriter(File rootDir, Map<TraceInfoField, String> commonFields, TraceArchiveRecordCallback recordCallback, String volumeName, Date volumeDate, String volumeVersion) throws IOException {
        if (rootDir != null) {
            IOUtil.recursiveDelete(rootDir);
        }
        IOUtil.mkdirs(rootDir);
        if (recordCallback == null) {
            throw new NullPointerException("TraceArchiveRecordFactory instance can not be null");
        }
        if (commonFields == null) {
            throw new NullPointerException("common fields Map can not be null");
        }
        this.volumeDate = volumeDate == null ? null : new Date(volumeDate.getTime());
        this.volumeName = volumeName;
        this.volumeVersion = volumeVersion;
        this.rootDir = rootDir;
        this.recordCallback = recordCallback;
        this.traceInfoBuilder = new DefaultTraceArchiveInfo.Builder();
        for (Map.Entry<TraceInfoField, String> entry : commonFields.entrySet()) {
            this.traceInfoBuilder.addCommonField(entry.getKey(), entry.getValue());
        }
        IOUtil.mkdirs(new File(rootDir, "fasta"));
        IOUtil.mkdirs(new File(rootDir, "peak"));
        IOUtil.mkdirs(new File(rootDir, "qual"));
        IOUtil.mkdirs(new File(rootDir, "traces"));
    }

    public void addTrace(String traceName, File traceFile) throws IOException, TraceArchiveRecordDataException {
        if (traceName == null) {
            throw new NullPointerException("traceName can not be null");
        }
        if (traceFile == null) {
            throw new NullPointerException("traceFile can not be null");
        }
        DefaultTraceArchiveRecord.Builder recordBuilder = new DefaultTraceArchiveRecord.Builder();
        if (this.traceNamesSeen.contains(traceName)) {
            throw new IllegalArgumentException("already added a trace with the trace name " + traceName);
        }
        this.traceNamesSeen.add(traceName);
        recordBuilder.put(TraceInfoField.TRACE_NAME, traceName);
        Chromatogram chromo = this.parseChromatogram(traceName, traceFile);
        this.handleSeqFasta(recordBuilder, traceName, chromo);
        this.handleQualFasta(recordBuilder, traceName, chromo);
        this.handlePeakFasta(recordBuilder, traceName, chromo);
        this.copyTraceFile(recordBuilder, traceName, traceFile);
        this.recordCallback.addMetaData(traceName, traceFile, recordBuilder);
        this.traceInfoBuilder.addRecord(recordBuilder.build());
    }

    private void copyTraceFile(TraceArchiveRecordBuilder recordBuilder, String traceName, File traceFile) throws FileNotFoundException, IOException {
        String pathToTraceFile = String.format("./traces/%s.ztr", traceName);
        recordBuilder.put(TraceInfoField.TRACE_FILE, pathToTraceFile);
        try (FileInputStream in = new FileInputStream(traceFile);
             FileOutputStream out = new FileOutputStream(new File(this.rootDir, pathToTraceFile));){
            IOUtil.copy(in, out);
        }
    }

    private String createMd5For(File f) throws IOException {
        MessageDigest md5;
        try {
            md5 = MessageDigest.getInstance("MD5");
        }
        catch (NoSuchAlgorithmException e) {
            throw new IOException("could not compute MD5", e);
        }
        try (FileInputStream in = new FileInputStream(f);){
            byte[] bytes = IOUtil.toByteArray(in);
            String string = this.toPaddedHexString(md5.digest(bytes));
            return string;
        }
    }

    private String toPaddedHexString(byte[] digest) {
        StringBuilder builder = new StringBuilder(digest.length * 2);
        for (int i = 0; i < digest.length; ++i) {
            String hex = Integer.toHexString(0xFF & digest[i]);
            if (hex.length() == 1) {
                builder.append('0');
            }
            builder.append(hex);
        }
        return builder.toString();
    }

    public int getNumberOfTracesWritten() {
        return this.traceNamesSeen.size();
    }

    @Override
    public void close() throws IOException {
        TraceArchiveInfo info = this.traceInfoBuilder.build();
        File xmlFile = this.createTraceInfoFile(info);
        File readMeFile = this.createReadmeFile();
        this.createMd5File(xmlFile, readMeFile);
    }

    private File createTraceInfoFile(TraceArchiveInfo info) throws IOException {
        File xmlFile = new File(this.rootDir, "TRACEINFO.XML");
        try (FileOutputStream out = new FileOutputStream(xmlFile);){
            TraceInfoWriterUtil.writeTraceInfoXML(out, info, this.volumeName, this.volumeDate, this.volumeVersion);
        }
        return xmlFile;
    }

    private File createReadmeFile() throws IOException {
        File readMeFile = new File(this.rootDir, "README");
        this.writeReadmeText(readMeFile);
        return readMeFile;
    }

    private void createMd5File(File xmlFile, File readMeFile) throws FileNotFoundException, IOException {
        try (PrintWriter md5Writer = new PrintWriter(new File(this.rootDir, "MD5"), "UTF-8");){
            md5Writer.println(this.createMd5For(xmlFile) + "\tTRACEINFO.XML");
            md5Writer.println(this.createMd5For(readMeFile) + "\tREADME");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeReadmeText(File readMeFile) throws IOException {
        try (PrintWriter writer = new PrintWriter(readMeFile, "UTF-8");){
            DateFormat dateFormat = DATE_TIME_FORMATTER;
            synchronized (dateFormat) {
                writer.printf(README_TEXT, DATE_TIME_FORMATTER.format(DateUtil.getCurrentDate()), this.traceNamesSeen.size());
            }
        }
    }

    private void handleSeqFasta(TraceArchiveRecordBuilder recordBuilder, String traceName, Chromatogram chromo) throws FileNotFoundException, IOException {
        String fastaFilePath = String.format("./fasta/%s.fasta", traceName);
        try (NucleotideFastaWriter writer = new NucleotideFastaWriterBuilder(new File(this.rootDir, fastaFilePath)).build();){
            writer.write(traceName, chromo.getNucleotideSequence());
            recordBuilder.put(TraceInfoField.BASE_FILE, fastaFilePath);
        }
    }

    private void handleQualFasta(TraceArchiveRecordBuilder recordBuilder, String traceName, Chromatogram chromo) throws FileNotFoundException, IOException {
        String qualFastaFilePath = String.format("./qual/%s.qual", traceName);
        try (QualityFastaWriter writer = (QualityFastaWriter)new QualityFastaWriterBuilder(new File(this.rootDir, qualFastaFilePath)).build();){
            writer.write(traceName, chromo.getQualitySequence());
            recordBuilder.put(TraceInfoField.QUAL_FILE, qualFastaFilePath);
        }
    }

    private void handlePeakFasta(TraceArchiveRecordBuilder recordBuilder, String traceName, Chromatogram chromo) throws FileNotFoundException, IOException {
        String peakFastaFilePath = String.format("./peak/%s.peak", traceName);
        try (PositionFastaWriter writer = (PositionFastaWriter)new PositionFastaWriterBuilder(new File(this.rootDir, peakFastaFilePath)).build();){
            writer.write(traceName, chromo.getPeakSequence());
            recordBuilder.put(TraceInfoField.PEAK_FILE, peakFastaFilePath);
        }
    }

    private Chromatogram parseChromatogram(String traceName, File traceFile) throws IOException {
        return ChromatogramFactory.create(traceName, traceFile);
    }

    public static class TraceArchiveRecordDataException
    extends Exception {
        private static final long serialVersionUID = 1L;

        public TraceArchiveRecordDataException(String message, Throwable cause) {
            super(message, cause);
        }

        public TraceArchiveRecordDataException(String message) {
            super(message);
        }
    }

    public static interface TraceArchiveRecordCallback {
        public void addMetaData(String var1, File var2, TraceArchiveRecordBuilder var3) throws TraceArchiveRecordDataException;
    }
}

