/*
 * Decompiled with CFR 0.152.
 */
package org.jcvi.jillion.experimental.trace.archive2;

import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import org.jcvi.jillion.experimental.trace.archive2.TraceArchiveRecord;
import org.jcvi.jillion.experimental.trace.archive2.TraceArchiveRecordBuilder;
import org.jcvi.jillion.experimental.trace.archive2.TraceInfoField;

public class DefaultTraceArchiveRecord
implements TraceArchiveRecord {
    private final Map<TraceInfoField, String> map;
    private final Map<String, String> extendedData;

    protected DefaultTraceArchiveRecord(Map<TraceInfoField, String> map, Map<String, String> extendedData) {
        if (map == null) {
            throw new IllegalArgumentException("map can not be null");
        }
        if (extendedData == null) {
            throw new IllegalArgumentException("extendedData can not be null");
        }
        this.map = map;
        this.extendedData = extendedData;
    }

    @Override
    public Map<String, String> getExtendedData() {
        return Collections.unmodifiableMap(this.extendedData);
    }

    @Override
    public Set<Map.Entry<TraceInfoField, String>> entrySet() {
        return this.map.entrySet();
    }

    @Override
    public String getAttribute(TraceInfoField traceInfoField) {
        return this.map.get((Object)traceInfoField);
    }

    @Override
    public boolean contains(TraceInfoField traceInfoField) {
        return this.map.containsKey((Object)traceInfoField);
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + this.map.entrySet().hashCode();
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof DefaultTraceArchiveRecord)) {
            return false;
        }
        DefaultTraceArchiveRecord other = (DefaultTraceArchiveRecord)obj;
        HashMap<TraceInfoField, String> otherMap = new HashMap<TraceInfoField, String>();
        for (Map.Entry<TraceInfoField, String> entry : other.entrySet()) {
            otherMap.put(entry.getKey(), entry.getValue());
        }
        return this.map.equals(otherMap);
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        for (Map.Entry<TraceInfoField, String> entry : this.map.entrySet()) {
            builder.append(String.format("%s = %s%n", new Object[]{entry.getKey(), entry.getValue()}));
        }
        return builder.toString();
    }

    public static class Builder
    implements TraceArchiveRecordBuilder {
        private final Map<TraceInfoField, String> map = new LinkedHashMap<TraceInfoField, String>();
        private final Map<String, String> extendedData = new HashMap<String, String>();

        public Builder() {
        }

        public Builder(TraceArchiveRecord record) {
            for (Map.Entry<TraceInfoField, String> entry : record.entrySet()) {
                this.map.put(entry.getKey(), entry.getValue());
            }
            for (Map.Entry<Object, String> entry : record.getExtendedData().entrySet()) {
                this.extendedData.put((String)entry.getKey(), entry.getValue());
            }
        }

        @Override
        public TraceArchiveRecordBuilder put(TraceInfoField traceInfoField, String value) {
            this.map.put(traceInfoField, value);
            return this;
        }

        @Override
        public TraceArchiveRecordBuilder putExtendedData(String key, String value) {
            this.extendedData.put(key, value);
            return this;
        }

        public TraceArchiveRecordBuilder removeExtendedData(String key) {
            this.extendedData.remove(key);
            return this;
        }

        @Override
        public TraceArchiveRecordBuilder putAll(Map<TraceInfoField, String> map) {
            this.map.putAll(map);
            return this;
        }

        public TraceArchiveRecordBuilder remove(TraceInfoField traceInfoField) {
            this.map.remove((Object)traceInfoField);
            return this;
        }

        @Override
        public TraceArchiveRecord build() {
            return new DefaultTraceArchiveRecord(this.map, this.extendedData);
        }
    }
}

