/*
 * Decompiled with CFR 0.152.
 */
package org.jcvi.jillion.experimental.trace.archive2;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.jcvi.jillion.experimental.trace.archive2.TraceArchiveInfo;
import org.jcvi.jillion.experimental.trace.archive2.TraceArchiveRecord;
import org.jcvi.jillion.experimental.trace.archive2.TraceInfoField;

public final class DefaultTraceArchiveInfo
implements TraceArchiveInfo {
    private final Map<String, TraceArchiveRecord> records;
    private final Map<TraceInfoField, String> commonFields;

    private DefaultTraceArchiveInfo(Map<String, TraceArchiveRecord> records, Map<TraceInfoField, String> commonFields) {
        this.records = records;
        this.commonFields = commonFields;
    }

    @Override
    public Map<TraceInfoField, String> getCommonFields() {
        return Collections.unmodifiableMap(this.commonFields);
    }

    @Override
    public List<TraceArchiveRecord> getRecordList() {
        return new ArrayList<TraceArchiveRecord>(this.records.values());
    }

    @Override
    public TraceArchiveRecord get(String traceName) {
        return this.records.get(traceName);
    }

    public static class Builder
    implements org.jcvi.jillion.core.util.Builder<TraceArchiveInfo> {
        private final Map<String, TraceArchiveRecord> records = new LinkedHashMap<String, TraceArchiveRecord>();
        private final Map<TraceInfoField, String> commonFields = new LinkedHashMap<TraceInfoField, String>();

        public Builder addAllRecords(Collection<? extends TraceArchiveRecord> records) {
            for (TraceArchiveRecord traceArchiveRecord : records) {
                this.addRecord(traceArchiveRecord);
            }
            return this;
        }

        public Builder addRecord(TraceArchiveRecord r) {
            if (r == null) {
                throw new NullPointerException("TraceArchiveRecord can not be null");
            }
            String traceName = r.getAttribute(TraceInfoField.TRACE_NAME);
            if (traceName == null) {
                throw new IllegalArgumentException("trace archive record must have a value for 'trace_name'");
            }
            this.records.put(traceName, r);
            return this;
        }

        public Builder addCommonField(TraceInfoField key, String value) {
            if (key == null) {
                throw new NullPointerException("common field key can not be null");
            }
            if (value == null) {
                throw new NullPointerException("common field value can not be null");
            }
            this.commonFields.put(key, value);
            return this;
        }

        @Override
        public TraceArchiveInfo build() {
            return new DefaultTraceArchiveInfo(this.records, this.commonFields);
        }
    }
}

