/*
 * Decompiled with CFR 0.152.
 */
package org.jcvi.jillion.experimental.primer;

public enum SaltCorrectionStrategy {
    SCHILDKRAUT_LIFSON(16.6),
    SANTALUCIA_1996(12.5),
    NONE(0.0){

        @Override
        public double adjustTemperature(double initialTm, double mM) {
            return initialTm;
        }
    };

    private static final double MICRO_MOLAR_CONVERSION = 1000.0;
    private final double adjustmentConstant;

    private SaltCorrectionStrategy(double adjustmentConstant) {
        this.adjustmentConstant = adjustmentConstant;
    }

    public double adjustTemperature(double initialTm, double mM) {
        if (mM < 0.0) {
            throw new IllegalArgumentException("concentration can not be negative");
        }
        return this.adjustmentConstant * Math.log10(mM / 1000.0) + initialTm;
    }
}

