/*
 * Decompiled with CFR 0.152.
 */
package org.jcvi.jillion.experimental.primer;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.jcvi.jillion.align.NucleotideSubstitutionMatrix;
import org.jcvi.jillion.align.NucleotideSubstitutionMatrixBuilder;
import org.jcvi.jillion.align.pairwise.NucleotidePairwiseSequenceAlignment;
import org.jcvi.jillion.align.pairwise.PairwiseAlignmentBuilder;
import org.jcvi.jillion.core.DirectedRange;
import org.jcvi.jillion.core.Direction;
import org.jcvi.jillion.core.Range;
import org.jcvi.jillion.core.datastore.DataStoreException;
import org.jcvi.jillion.core.io.IOUtil;
import org.jcvi.jillion.core.residue.nt.NucleotideSequence;
import org.jcvi.jillion.core.residue.nt.NucleotideSequenceBuilder;
import org.jcvi.jillion.core.residue.nt.NucleotideSequenceDataStore;
import org.jcvi.jillion.core.util.iter.StreamingIterator;
import org.jcvi.jillion.fasta.nt.NucleotideFastaDataStore;
import org.jcvi.jillion.fasta.nt.NucleotideFastaRecord;

public class PrimerDetector {
    private final int minLength;
    private final double minPercentIdentity;
    private final boolean alsoCheckReverseCompliment;
    private final Integer maxNumMismatches;
    private int gapOpenPenalty = -17;
    private int gapExtendPenalty = -5;
    private static final NucleotideSubstitutionMatrix MATRIX = new NucleotideSubstitutionMatrixBuilder(-14.0f).setMatch(5.0f).ambiguityScore(2.0f).build();

    public PrimerDetector(int minLength, double minPercentIdentity) {
        this(minLength, minPercentIdentity, true);
    }

    private PrimerDetector(int minLength, int maxAllowedMismatches, boolean alsoCheckReverseCompliment, int gapOpenPenalty) {
        this.minLength = minLength;
        this.minPercentIdentity = 0.0;
        this.alsoCheckReverseCompliment = alsoCheckReverseCompliment;
        this.maxNumMismatches = maxAllowedMismatches;
        this.gapOpenPenalty = gapOpenPenalty;
    }

    public PrimerDetector(int minLength, double minPercentIdentity, boolean alsoCheckReverseCompliment) {
        this.minLength = minLength;
        this.minPercentIdentity = minPercentIdentity;
        this.alsoCheckReverseCompliment = alsoCheckReverseCompliment;
        this.maxNumMismatches = null;
    }

    public List<DirectedRange> detect(NucleotideSequence sequence, NucleotideSequenceDataStore primersDataStore) {
        if (sequence.getLength() == 0L) {
            return Collections.emptyList();
        }
        ArrayList<DirectedRange> ranges = new ArrayList<DirectedRange>();
        StreamingIterator iter = null;
        try {
            Iterable primer;
            iter = primersDataStore.iterator();
            while (iter.hasNext()) {
                DirectedRange range;
                boolean reverseIsCandidate;
                NucleotidePairwiseSequenceAlignment reverseAlignment;
                primer = (NucleotideSequence)iter.next();
                if (primer.getLength() < (long)this.minLength) continue;
                NucleotidePairwiseSequenceAlignment forwardAlignment = PairwiseAlignmentBuilder.createNucleotideAlignmentBuilder(primer, sequence, MATRIX).gapPenalty(this.gapOpenPenalty, this.gapExtendPenalty).build();
                if (this.alsoCheckReverseCompliment) {
                    NucleotideSequence reversePrimer = new NucleotideSequenceBuilder((NucleotideSequence)primer).reverseComplement().build();
                    reverseAlignment = PairwiseAlignmentBuilder.createNucleotideAlignmentBuilder(reversePrimer, sequence, MATRIX).gapPenalty(this.gapOpenPenalty, this.gapExtendPenalty).build();
                } else {
                    reverseAlignment = NullAlignment.INSTANCE;
                }
                if (this.maxNumMismatches == null) {
                    Direction direction;
                    NucleotidePairwiseSequenceAlignment bestAlignment;
                    boolean reverseValid;
                    boolean forwardValid = forwardAlignment.getPercentIdentity() > this.minPercentIdentity && forwardAlignment.getAlignmentLength() >= this.minLength;
                    boolean bl = reverseValid = reverseAlignment.getPercentIdentity() > this.minPercentIdentity && reverseAlignment.getAlignmentLength() >= this.minLength;
                    if (!forwardValid && !reverseValid) continue;
                    if (forwardValid && !reverseValid) {
                        bestAlignment = forwardAlignment;
                        direction = Direction.FORWARD;
                    } else if (!forwardValid && reverseValid) {
                        bestAlignment = reverseAlignment;
                        direction = Direction.REVERSE;
                    } else if (reverseAlignment.getScore() > forwardAlignment.getScore()) {
                        bestAlignment = reverseAlignment;
                        direction = Direction.REVERSE;
                    } else {
                        bestAlignment = forwardAlignment;
                        direction = Direction.FORWARD;
                    }
                    DirectedRange range2 = DirectedRange.create(bestAlignment.getSubjectRange().asRange(), direction);
                    ranges.add(range2);
                    continue;
                }
                int maxAllowedMismatches = this.maxNumMismatches;
                boolean forwardIsCandidate = forwardAlignment.getAlignmentLength() >= this.minLength && forwardAlignment.getNumberOfMismatches() <= maxAllowedMismatches;
                boolean bl = reverseIsCandidate = reverseAlignment.getAlignmentLength() >= this.minLength && reverseAlignment.getNumberOfMismatches() <= maxAllowedMismatches;
                if (forwardIsCandidate && reverseIsCandidate) {
                    if (reverseAlignment.getScore() > forwardAlignment.getScore()) {
                        range = DirectedRange.create(reverseAlignment.getSubjectRange().asRange(), Direction.REVERSE);
                        ranges.add(range);
                        continue;
                    }
                    range = DirectedRange.create(forwardAlignment.getSubjectRange().asRange(), Direction.FORWARD);
                    ranges.add(range);
                    continue;
                }
                if (forwardIsCandidate) {
                    range = DirectedRange.create(forwardAlignment.getSubjectRange().asRange(), Direction.FORWARD);
                    ranges.add(range);
                    continue;
                }
                if (!reverseIsCandidate) continue;
                range = DirectedRange.create(reverseAlignment.getSubjectRange().asRange(), Direction.REVERSE);
                ranges.add(range);
            }
            primer = ranges;
            return primer;
        }
        catch (DataStoreException e) {
            throw new IllegalStateException("error iterating over nucleotide sequences", e);
        }
        finally {
            IOUtil.closeAndIgnoreErrors(iter);
        }
    }

    public List<PrimerHit> detect(NucleotideSequence sequence, NucleotideFastaDataStore primersDataStore) {
        ArrayList<PrimerHit> hits = new ArrayList<PrimerHit>();
        StreamingIterator iter = null;
        try {
            Object fasta;
            iter = primersDataStore.iterator();
            while (iter.hasNext()) {
                DirectedRange range;
                boolean reverseIsCandidate;
                NucleotidePairwiseSequenceAlignment reverseAlignment;
                fasta = (NucleotideFastaRecord)iter.next();
                NucleotideSequence primer = (NucleotideSequence)fasta.getSequence();
                if (primer.getLength() < (long)this.minLength) continue;
                NucleotidePairwiseSequenceAlignment forwardAlignment = PairwiseAlignmentBuilder.createNucleotideAlignmentBuilder(primer, sequence, MATRIX).gapPenalty(this.gapOpenPenalty, -1.0f).build();
                if (this.alsoCheckReverseCompliment) {
                    NucleotideSequence reversePrimer = new NucleotideSequenceBuilder(primer).reverseComplement().build();
                    reverseAlignment = PairwiseAlignmentBuilder.createNucleotideAlignmentBuilder(reversePrimer, sequence, MATRIX).gapPenalty(this.gapOpenPenalty, -1.0f).build();
                } else {
                    reverseAlignment = NullAlignment.INSTANCE;
                }
                if (this.maxNumMismatches == null) {
                    Direction direction;
                    NucleotidePairwiseSequenceAlignment bestAlignment;
                    if (!(forwardAlignment.getPercentIdentity() > this.minPercentIdentity) && !(reverseAlignment.getPercentIdentity() > this.minPercentIdentity)) continue;
                    if (reverseAlignment.getScore() > forwardAlignment.getScore()) {
                        bestAlignment = reverseAlignment;
                        direction = Direction.REVERSE;
                    } else {
                        bestAlignment = forwardAlignment;
                        direction = Direction.FORWARD;
                    }
                    DirectedRange range2 = DirectedRange.create(bestAlignment.getSubjectRange().asRange(), direction);
                    hits.add(new PrimerHit(fasta.getId(), range2));
                    continue;
                }
                int maxAllowedMismatches = this.maxNumMismatches;
                int numberOfMissingForwardBases = Math.max(0, this.minLength - forwardAlignment.getAlignmentLength());
                int numberOfMissingReverseBases = Math.max(0, this.minLength - reverseAlignment.getAlignmentLength());
                int numberOfForwardMismatchesAndMissingBases = forwardAlignment.getNumberOfMismatches() + numberOfMissingForwardBases;
                int numberOfReverseMismatchesAndMissingBases = reverseAlignment.getNumberOfMismatches() + numberOfMissingReverseBases;
                boolean forwardIsCandidate = numberOfForwardMismatchesAndMissingBases <= maxAllowedMismatches;
                boolean bl = reverseIsCandidate = numberOfReverseMismatchesAndMissingBases <= maxAllowedMismatches;
                if (forwardIsCandidate && reverseIsCandidate) {
                    if (reverseAlignment.getScore() > forwardAlignment.getScore()) {
                        range = DirectedRange.create(new Range.Builder(reverseAlignment.getSubjectRange().asRange()).expandBegin(numberOfMissingReverseBases).build(), Direction.REVERSE);
                        hits.add(new PrimerHit(fasta.getId(), range));
                        continue;
                    }
                    range = DirectedRange.create(new Range.Builder(forwardAlignment.getSubjectRange().asRange()).expandEnd(numberOfMissingForwardBases).build(), Direction.FORWARD);
                    hits.add(new PrimerHit(fasta.getId(), range));
                    continue;
                }
                if (forwardIsCandidate) {
                    range = DirectedRange.create(new Range.Builder(forwardAlignment.getSubjectRange().asRange()).expandEnd(numberOfMissingForwardBases).build(), Direction.FORWARD);
                    hits.add(new PrimerHit(fasta.getId(), range));
                    continue;
                }
                if (!reverseIsCandidate) continue;
                range = DirectedRange.create(new Range.Builder(reverseAlignment.getSubjectRange().asRange()).expandBegin(numberOfMissingReverseBases).build(), Direction.REVERSE);
                hits.add(new PrimerHit(fasta.getId(), range));
            }
            fasta = hits;
            return fasta;
        }
        catch (DataStoreException e) {
            throw new IllegalStateException("error iterating over nucleotide sequences", e);
        }
        finally {
            IOUtil.closeAndIgnoreErrors(iter);
        }
    }

    public static PrimerDetector create(int minLength, int maxAllowedMismatches) {
        return new PrimerDetector(minLength, maxAllowedMismatches, true, -200);
    }

    private static enum NullAlignment implements NucleotidePairwiseSequenceAlignment
    {
        INSTANCE;


        @Override
        public float getScore() {
            return 0.0f;
        }

        @Override
        public double getPercentIdentity() {
            return 0.0;
        }

        @Override
        public int getAlignmentLength() {
            return 0;
        }

        @Override
        public int getNumberOfMismatches() {
            return 0;
        }

        @Override
        public int getNumberOfGapOpenings() {
            return 0;
        }

        @Override
        public NucleotideSequence getGappedQueryAlignment() {
            return null;
        }

        @Override
        public NucleotideSequence getGappedSubjectAlignment() {
            return null;
        }

        @Override
        public DirectedRange getQueryRange() {
            return null;
        }

        @Override
        public DirectedRange getSubjectRange() {
            return null;
        }
    }

    public static final class PrimerHit {
        private final String id;
        private final DirectedRange directedRange;

        private PrimerHit(String id, DirectedRange directedRange) {
            this.id = id;
            this.directedRange = directedRange;
        }

        public String getId() {
            return this.id;
        }

        public DirectedRange getDirectedRange() {
            return this.directedRange;
        }

        public String toString() {
            return "PrimerHit [id=" + this.id + ", directedRange=" + this.directedRange + "]";
        }
    }
}

