/*
 * Decompiled with CFR 0.152.
 */
package org.jcvi.jillion.experimental.primer;

import java.io.Serializable;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;
import org.jcvi.jillion.core.residue.nt.Nucleotide;
import org.jcvi.jillion.core.residue.nt.NucleotideSequence;
import org.jcvi.jillion.core.residue.nt.NucleotideSequenceBuilder;
import org.jcvi.jillion.core.util.iter.IteratorUtil;
import org.jcvi.jillion.core.util.iter.PeekableIterator;

public enum OptimalMeltingTemperatureEstimator {
    MARMUR{

        @Override
        public double estimateTm(NucleotideSequence sequence, double nM) {
            int gc = 0;
            int at = 0;
            for (Nucleotide base : sequence) {
                switch (base) {
                    case Adenine: 
                    case Thymine: {
                        ++at;
                        break;
                    }
                    case Cytosine: 
                    case Guanine: {
                        ++gc;
                        break;
                    }
                }
            }
            return 4 * gc + 2 * at;
        }
    }
    ,
    WALLACE{

        @Override
        public double estimateTm(NucleotideSequence sequence, double nM) {
            int a = 0;
            int c = 0;
            int g = 0;
            int t = 0;
            for (Nucleotide base : sequence) {
                switch (base) {
                    case Adenine: {
                        ++a;
                        break;
                    }
                    case Thymine: {
                        ++t;
                        break;
                    }
                    case Cytosine: {
                        ++c;
                        break;
                    }
                    case Guanine: {
                        ++g;
                        break;
                    }
                }
            }
            return (double)64.9f + 41.0 * ((double)(g + c) - 16.4) / (double)(a + t + g + c);
        }
    }
    ,
    BRESLAUR{
        private final LookupTable deltaS = new LookupTable.Builder().aa(240).ac(173).ag(208).at(239).ca(129).cc(266).cg(278).ct(208).ga(135).gc(267).gg(266).gt(173).ta(169).tc(135).tg(129).tt(240).build();
        private final LookupTable deltaH = new LookupTable.Builder().aa(91).ac(65).ag(78).at(86).ca(58).cc(110).cg(119).ct(78).ga(56).gc(111).gg(110).gt(65).ta(60).tc(56).tg(58).tt(91).build();

        @Override
        public double estimateTm(NucleotideSequence sequence, double molarConcentration) {
            return this.estimateTm(sequence, molarConcentration, this.deltaH, this.deltaS);
        }

        @Override
        protected InitialValues getSymmetryCorrection() {
            return new InitialValues(13.4, 0.0);
        }

        @Override
        protected InitialValues getInitialValuesFor(NucleotideSequence sequence) {
            if (this.hasGorC(sequence)) {
                return new InitialValues(167.7, 0.0);
            }
            return new InitialValues(201.3, 0.0);
        }
    }
    ,
    ALLAWI_SANTALUCIA{
        private final LookupTable deltaH = new LookupTable.Builder().aa(79).ac(84).ag(78).at(72).ca(85).cc(80).cg(106).ct(78).ga(82).gc(98).gg(80).gt(84).ta(72).tc(82).tg(85).tt(79).build();
        private final LookupTable deltaS = new LookupTable.Builder().aa(222).ac(224).ag(210).at(204).ca(227).cc(199).cg(272).ct(210).ga(222).gc(244).gg(199).gt(224).ta(213).tc(222).tg(227).tt(222).build();

        @Override
        public double estimateTm(NucleotideSequence sequence, double molarConcentration) {
            return this.estimateTm(sequence, molarConcentration, this.deltaH, this.deltaS);
        }

        @Override
        protected InitialValues getSymmetryCorrection() {
            return new InitialValues(14.0, 0.0);
        }

        @Override
        protected InitialValues getInitialValuesFor(NucleotideSequence sequence) {
            Nucleotide firstBase = (Nucleotide)sequence.get(0L);
            Nucleotide lastBase = (Nucleotide)sequence.get(sequence.getLength() - 1L);
            double entropy = 0.0;
            double enthalpy = 0.0;
            if (firstBase == Nucleotide.Guanine || firstBase == Nucleotide.Cytosine) {
                entropy += 28.0;
                enthalpy -= 1.0;
            } else if (firstBase == Nucleotide.Adenine || firstBase == Nucleotide.Thymine) {
                entropy -= 41.0;
                enthalpy -= 23.0;
            }
            if (lastBase == Nucleotide.Guanine || lastBase == Nucleotide.Cytosine) {
                entropy += 28.0;
                enthalpy -= 1.0;
            } else if (lastBase == Nucleotide.Adenine || lastBase == Nucleotide.Thymine) {
                entropy -= 41.0;
                enthalpy -= 23.0;
            }
            return new InitialValues(entropy, enthalpy);
        }
    }
    ,
    SANTALUCIA_1998{
        private final LookupTable deltaH = new LookupTable.Builder().aa(79).ac(84).ag(78).at(72).ca(85).cc(80).cg(106).ct(78).ga(82).gc(98).gg(80).gt(84).ta(72).tc(82).tg(85).tt(79).build();
        private final LookupTable deltaS = new LookupTable.Builder().aa(222).ac(224).ag(210).at(204).ca(227).cc(199).cg(272).ct(210).ga(222).gc(244).gg(199).gt(224).ta(213).tc(222).tg(227).tt(222).build();

        @Override
        public double estimateTm(NucleotideSequence sequence, double molarConcentration) {
            return this.estimateTm(sequence, molarConcentration, this.deltaH, this.deltaS);
        }

        @Override
        protected InitialValues getInitialValuesFor(NucleotideSequence sequence) {
            double entropy = 0.0;
            double enthalpy = 0.0;
            entropy = this.hasGorC(sequence) ? (entropy += 59.0) : (entropy += 90.0);
            Nucleotide firstBase = (Nucleotide)sequence.get(0L);
            if (firstBase == Nucleotide.Thymine || firstBase == Nucleotide.Adenine) {
                entropy -= 41.0;
                enthalpy -= 23.0;
            } else {
                entropy += 28.0;
                enthalpy -= 1.0;
            }
            return new InitialValues(entropy, enthalpy);
        }

        @Override
        protected InitialValues getSymmetryCorrection() {
            return new InitialValues(14.0, 0.0);
        }
    }
    ,
    SANTALUCIA_1996{
        private final LookupTable deltaH = new LookupTable.Builder().aa(84).ac(86).ag(61).at(65).ca(74).cc(67).cg(101).ct(61).ga(77).gc(111).gg(67).gt(86).ta(63).tc(77).tg(74).tt(84).build();
        private final LookupTable deltaS = new LookupTable.Builder().aa(236).ac(230).ag(161).at(188).ca(193).cc(156).cg(255).ct(161).ga(203).gc(284).gg(156).gt(230).ta(185).tc(203).tg(193).tt(236).build();

        @Override
        public double estimateTm(NucleotideSequence sequence, double molarConcentration) {
            return this.estimateTm(sequence, molarConcentration, this.deltaH, this.deltaS);
        }

        @Override
        protected InitialValues getInitialValuesFor(NucleotideSequence sequence) {
            double entropy = 0.0;
            double enthalpy = 0.0;
            entropy = this.hasGorC(sequence) ? (entropy += 59.0) : (entropy += 90.0);
            return new InitialValues(entropy, enthalpy -= (double)(40 * this.getNumberOfTerminal5primerTs(sequence)));
        }

        private int getNumberOfTerminal5primerTs(NucleotideSequence sequence) {
            NucleotideSequence reversedSeq = new NucleotideSequenceBuilder(sequence).reverse().build();
            Iterator iter = reversedSeq.iterator();
            boolean done = false;
            int numberOfTerminalTs = 0;
            while (!done && iter.hasNext()) {
                if (iter.next() == Nucleotide.Thymine) {
                    ++numberOfTerminalTs;
                    continue;
                }
                done = true;
            }
            return numberOfTerminalTs;
        }

        @Override
        protected InitialValues getSymmetryCorrection() {
            return new InitialValues(14.0, 0.0);
        }
    }
    ,
    SUGIMOTO{
        private final LookupTable deltaH = new LookupTable.Builder().aa(80).ac(94).ag(66).at(56).ca(82).cc(109).cg(118).ct(66).ga(88).gc(105).gg(109).gt(94).ta(66).tc(88).tg(82).tt(80).build();
        private final LookupTable deltaS = new LookupTable.Builder().aa(219).ac(255).ag(164).at(152).ca(210).cc(284).cg(290).ct(164).ga(235).gc(264).gg(284).gt(255).ta(184).tc(235).tg(210).tt(219).build();

        @Override
        public double estimateTm(NucleotideSequence sequence, double molarConcentration) {
            return this.estimateTm(sequence, molarConcentration, this.deltaH, this.deltaS);
        }

        @Override
        protected InitialValues getInitialValuesFor(NucleotideSequence sequence) {
            return new InitialValues(90.0, -6.0);
        }

        @Override
        protected InitialValues getSymmetryCorrection() {
            return new InitialValues(14.0, 0.0);
        }
    };

    private static final double NON_SYMMETRIC_MOLAR_ADJUSTMENT = 4.0E9;
    private static final double SYMMETRIC_MOLAR_ADJUSTMENT = 1.0E9;
    private static final double ABSOLUTE_ZERO_CONVERSION = 273.15;
    private static final double ENTROPY_CONVERSION = -0.1;
    private static final double ENTHALPY_CONVERRSION = -100.0;
    private static final double R = 1.987;

    protected final double estimateTm(NucleotideSequence sequence, double nM, LookupTable enthalpyLookup, LookupTable entropyLookup) {
        double adjustedMolarConcentration;
        this.verifyOnlyHasACGT(sequence);
        if (nM < 0.0) {
            throw new IllegalArgumentException("concentration must be >0");
        }
        InitialValues initialValues = this.getInitialValuesFor(sequence);
        double totalEntropy = initialValues.getInitialEntropy();
        double totalEnthalpy = initialValues.getInitialEnthalpy();
        if (OptimalMeltingTemperatureEstimator.isSymmetric(sequence)) {
            InitialValues symmetryPenalty = this.getSymmetryCorrection();
            totalEntropy += symmetryPenalty.getInitialEntropy();
            totalEnthalpy += symmetryPenalty.getInitialEnthalpy();
            adjustedMolarConcentration = nM / 1.0E9;
        } else {
            adjustedMolarConcentration = nM / 4.0E9;
        }
        PeekableIterator iter = IteratorUtil.createPeekableIterator(sequence.iterator());
        Nucleotide previous = (Nucleotide)iter.next();
        while (iter.hasNext()) {
            Nucleotide next = (Nucleotide)iter.next();
            NucleotideSequence diNucleotide = new NucleotideSequenceBuilder(2).append(previous).append(next).build();
            totalEnthalpy += (double)enthalpyLookup.lookup(diNucleotide);
            totalEntropy += (double)entropyLookup.lookup(diNucleotide);
            previous = next;
        }
        double tempInKelvin = (totalEnthalpy *= -100.0) / ((totalEntropy *= -0.1) + 1.987 * Math.log(adjustedMolarConcentration));
        return tempInKelvin - 273.15;
    }

    protected InitialValues getSymmetryCorrection() {
        return new InitialValues();
    }

    protected InitialValues getInitialValuesFor(NucleotideSequence sequence) {
        return new InitialValues();
    }

    private void verifyOnlyHasACGT(NucleotideSequence sequence) {
        for (Nucleotide n : sequence) {
            if (n == Nucleotide.Adenine || n == Nucleotide.Cytosine || n == Nucleotide.Guanine || n == Nucleotide.Thymine) continue;
            throw new IllegalArgumentException(String.format("invalid base %s can only contain ACGTs", n));
        }
    }

    private static boolean isSymmetric(NucleotideSequence sequence) {
        NucleotideSequence complement = new NucleotideSequenceBuilder(sequence).reverseComplement().build();
        return sequence.equals(complement);
    }

    public abstract double estimateTm(NucleotideSequence var1, double var2);

    protected boolean hasGorC(NucleotideSequence sequence) {
        boolean hasGC = false;
        for (Nucleotide n : sequence) {
            if (n != Nucleotide.Guanine && n != Nucleotide.Cytosine) continue;
            hasGC = true;
            break;
        }
        return hasGC;
    }

    private static final class LookupTable
    implements Serializable {
        private static final long serialVersionUID = 1L;
        private final Map<NucleotideSequence, Integer> map;

        LookupTable(Map<NucleotideSequence, Integer> map) {
            this.map = map;
        }

        public int lookup(NucleotideSequence diNucleotide) {
            Integer value = this.map.get(diNucleotide);
            if (value == null) {
                throw new NoSuchElementException("no value " + diNucleotide + " in lookup table");
            }
            return value;
        }

        private static final class Builder {
            private final Map<NucleotideSequence, Integer> map = new HashMap<NucleotideSequence, Integer>(10);

            private Builder() {
            }

            public Builder aa(int value) {
                Integer boxedValue = value;
                this.map.put(new NucleotideSequenceBuilder("AA").build(), boxedValue);
                return this;
            }

            public Builder ac(int value) {
                Integer boxedValue = value;
                this.map.put(new NucleotideSequenceBuilder("AC").build(), boxedValue);
                return this;
            }

            public Builder ag(int value) {
                Integer boxedValue = value;
                this.map.put(new NucleotideSequenceBuilder("AG").build(), boxedValue);
                return this;
            }

            public Builder at(int value) {
                Integer boxedValue = value;
                this.map.put(new NucleotideSequenceBuilder("AT").build(), boxedValue);
                return this;
            }

            public Builder ca(int value) {
                Integer boxedValue = value;
                this.map.put(new NucleotideSequenceBuilder("CA").build(), boxedValue);
                return this;
            }

            public Builder cc(int value) {
                Integer boxedValue = value;
                this.map.put(new NucleotideSequenceBuilder("CC").build(), boxedValue);
                return this;
            }

            public Builder cg(int value) {
                Integer boxedValue = value;
                this.map.put(new NucleotideSequenceBuilder("CG").build(), boxedValue);
                return this;
            }

            public Builder ct(int value) {
                Integer boxedValue = value;
                this.map.put(new NucleotideSequenceBuilder("CT").build(), boxedValue);
                return this;
            }

            public Builder ga(int value) {
                Integer boxedValue = value;
                this.map.put(new NucleotideSequenceBuilder("GA").build(), boxedValue);
                return this;
            }

            public Builder gc(int value) {
                Integer boxedValue = value;
                this.map.put(new NucleotideSequenceBuilder("GC").build(), boxedValue);
                return this;
            }

            public Builder gg(int value) {
                Integer boxedValue = value;
                this.map.put(new NucleotideSequenceBuilder("GG").build(), boxedValue);
                return this;
            }

            public Builder gt(int value) {
                Integer boxedValue = value;
                this.map.put(new NucleotideSequenceBuilder("GT").build(), boxedValue);
                return this;
            }

            public Builder ta(int value) {
                Integer boxedValue = value;
                this.map.put(new NucleotideSequenceBuilder("TA").build(), boxedValue);
                return this;
            }

            public Builder tc(int value) {
                Integer boxedValue = value;
                this.map.put(new NucleotideSequenceBuilder("TC").build(), boxedValue);
                return this;
            }

            public Builder tg(int value) {
                Integer boxedValue = value;
                this.map.put(new NucleotideSequenceBuilder("TG").build(), boxedValue);
                return this;
            }

            public Builder tt(int value) {
                Integer boxedValue = value;
                this.map.put(new NucleotideSequenceBuilder("TT").build(), boxedValue);
                return this;
            }

            public LookupTable build() {
                return new LookupTable(this.map);
            }
        }
    }

    private static final class InitialValues {
        private double initialEntropy;
        private double initialEnthalpy;

        public InitialValues() {
            this(0.0, 0.0);
        }

        public InitialValues(double initialEntropy, double initialEnthalpy) {
            this.initialEntropy = initialEntropy;
            this.initialEnthalpy = initialEnthalpy;
        }

        public final double getInitialEntropy() {
            return this.initialEntropy;
        }

        public final double getInitialEnthalpy() {
            return this.initialEnthalpy;
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            long temp = Double.doubleToLongBits(this.initialEnthalpy);
            result = 31 * result + (int)(temp ^ temp >>> 32);
            temp = Double.doubleToLongBits(this.initialEntropy);
            result = 31 * result + (int)(temp ^ temp >>> 32);
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (!(obj instanceof InitialValues)) {
                return false;
            }
            InitialValues other = (InitialValues)obj;
            if (Double.doubleToLongBits(this.initialEnthalpy) != Double.doubleToLongBits(other.initialEnthalpy)) {
                return false;
            }
            return Double.doubleToLongBits(this.initialEntropy) == Double.doubleToLongBits(other.initialEntropy);
        }
    }
}

