/*
 * Decompiled with CFR 0.152.
 */
package org.jcvi.jillion.experimental.plate;

import java.io.Serializable;
import java.util.Comparator;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jcvi.jillion.experimental.plate.PlateFormat;
import org.jcvi.jillion.internal.core.util.JillionUtil;

public final class Well
implements Comparable<Well> {
    private static final Pattern WELL_NAME_PATTERN = Pattern.compile("([A-P])(\\d+)");
    private static final Well[][] CACHE = new Well[16][24];
    private final char row;
    private final byte column;

    public static Well create(String wellName) {
        if (wellName == null) {
            throw new NullPointerException("input can not be null");
        }
        Matcher m = WELL_NAME_PATTERN.matcher(wellName);
        if (m.find()) {
            char row = m.group(1).charAt(0);
            byte col = Byte.parseByte(m.group(2));
            if (col > 24) {
                throw new IllegalArgumentException("invalid column " + col);
            }
            return Well.getWell(row, col);
        }
        throw new IllegalArgumentException("string does not contain a parseable Well : " + wellName);
    }

    private static synchronized Well getWell(char row, int column) {
        Well newWell;
        int rowIndex = row - 65;
        int columIndex = column - 1;
        if (CACHE[rowIndex][columIndex] != null) {
            return CACHE[rowIndex][columIndex];
        }
        Well.CACHE[rowIndex][columIndex] = newWell = new Well(row, column);
        return newWell;
    }

    public static Well compute384Well(int i, IndexOrder order) {
        return Well.computeWell(PlateFormat._384, i, order);
    }

    public static Well compute96Well(int i, IndexOrder order) {
        return Well.computeWell(PlateFormat._96, i, order);
    }

    public static Well computeWell(PlateFormat format, int i, IndexOrder order) {
        if (format == null) {
            throw new NullPointerException("format can not be null");
        }
        return order.getWell(i, format);
    }

    private static void verifyPositiveIndex(int index) {
        if (index < 0) {
            throw new IllegalArgumentException("index can not be <0");
        }
    }

    private Well(char row, int column) {
        if (row > 'P' || row < 'A') {
            throw new IllegalArgumentException("invalid row " + row);
        }
        if (column < 1 || column > 24) {
            throw new IllegalArgumentException("invalid column " + column);
        }
        this.row = row;
        this.column = (byte)column;
    }

    public char getRow() {
        return this.row;
    }

    public byte getColumn() {
        return this.column;
    }

    public int get96WellIndex() {
        return this.get96WellIndex(IndexOrder.ROW_MAJOR);
    }

    public int get384WellIndex() {
        return this.get384WellIndex(IndexOrder.ROW_MAJOR);
    }

    public int get96WellIndex(IndexOrder order) {
        return this.getWellIndex(PlateFormat._96, order);
    }

    public int get384WellIndex(IndexOrder order) {
        return this.getWellIndex(PlateFormat._384, order);
    }

    public int getWellIndex(PlateFormat format, IndexOrder order) {
        return order.getIndex(this, format);
    }

    public int getQuadrantIndex(PlateFormat format, IndexOrder order) {
        return order.getQuadrantIndex(this, format);
    }

    public int get96WellQuadrantIndex(IndexOrder order) {
        return this.getQuadrantIndex(PlateFormat._96, order);
    }

    public int get384WellQuadrantIndex(IndexOrder order) {
        return this.getQuadrantIndex(PlateFormat._384, order);
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + this.row;
        result = 31 * result + this.column;
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof Well)) {
            return false;
        }
        Well other = (Well)obj;
        return this.row == other.row && this.column == other.column;
    }

    public String toString() {
        return this.toZeroPaddedString();
    }

    public String toUnpaddedString() {
        return new StringBuilder(3).append(this.row).append(String.format("%d", this.column)).toString();
    }

    public String toZeroPaddedString() {
        return new StringBuilder(3).append(this.row).append(String.format("%02d", this.column)).toString();
    }

    @Override
    public int compareTo(Well o) {
        return this.toZeroPaddedString().compareTo(o.toZeroPaddedString());
    }

    private static final class IndexOrderComparator
    implements Comparator<Well>,
    Serializable {
        private static final long serialVersionUID = 8181294609649588216L;
        private final PlateFormat type;
        private final IndexOrder order;

        private IndexOrderComparator(PlateFormat type, IndexOrder order) {
            this.type = type;
            this.order = order;
        }

        @Override
        public int compare(Well o1, Well o2) {
            return JillionUtil.compare(o1.getWellIndex(this.type, this.order), o2.getWellIndex(this.type, this.order));
        }
    }

    public static enum IndexOrder {
        ROW_MAJOR{

            @Override
            int getIndex(Well well, PlateFormat type) {
                return (well.getRow() - 65) * type.getNumberOfColumns() + well.getColumn() - 1;
            }

            @Override
            Well getWell(int index, PlateFormat type) {
                Well.verifyPositiveIndex(index);
                int modIndex = index % type.getNumberOfWells();
                int column = modIndex % type.getNumberOfColumns() + 1;
                char row = (char)(65 + modIndex % type.getNumberOfWells() / type.getNumberOfColumns());
                return Well.getWell(row, column);
            }
        }
        ,
        COLUMN_MAJOR{

            @Override
            int getIndex(Well well, PlateFormat type) {
                return (well.getColumn() - 1) * type.getNumberOfRows() + (well.getRow() - 65);
            }

            @Override
            Well getWell(int index, PlateFormat type) {
                Well.verifyPositiveIndex(index);
                int modIndex = index % type.getNumberOfWells();
                char row = (char)(65 + modIndex % type.getNumberOfRows());
                int column = modIndex / type.getNumberOfRows() + 1;
                return Well.getWell(row, column);
            }
        }
        ,
        CHECKERBOARD{

            @Override
            int getIndex(Well well, PlateFormat type) {
                int column = well.getColumn() - 1;
                int row = well.getRow() - 65;
                int quadrantIndex = this.computeQuadrantIndex(column, row);
                int fullRows = this.computeNumberOfFilledRows(type, row);
                int partialRow = column / 2 + 1 - 1;
                int offsetIntoQuadrant = fullRows + partialRow;
                return type.getNumberOfWellsPerQuadrant() * quadrantIndex + offsetIntoQuadrant;
            }

            private int computeNumberOfFilledRows(PlateFormat type, int row) {
                return row > 1 ? row / 2 * type.getNumberOfColumns() / 2 : 0;
            }

            private int computeQuadrantIndex(int column, int row) {
                int block = row % 2 == 0 ? (column % 2 == 0 ? 0 : 1) : (column % 2 == 0 ? 2 : 3);
                return block;
            }

            @Override
            Well getWell(int index, PlateFormat type) {
                Well.verifyPositiveIndex(index);
                int modIndex = index % type.getNumberOfWells();
                int quadrantIndex = modIndex / type.getNumberOfWellsPerQuadrant();
                int offsetIntoQuadrant = modIndex % type.getNumberOfWellsPerQuadrant();
                int rowIndex = offsetIntoQuadrant / (type.getNumberOfColumns() / 2) * 2 + quadrantIndex / 2;
                int column = offsetIntoQuadrant % (type.getNumberOfColumns() / 2) * 2 + 1 + quadrantIndex % 2;
                char row = (char)(65 + rowIndex);
                return Well.getWell(row, column);
            }
        }
        ,
        HAMILTON_OPTIMIZED_COLUMN_MAJOR{

            @Override
            int getIndex(Well well, PlateFormat type) {
                int rowOffset = well.getRow() - 65;
                int rowIndex = rowOffset / 2;
                if (rowOffset % 2 != 0) {
                    rowIndex += type.getNumberOfRows() / 2;
                }
                return (well.getColumn() - 1) * type.getNumberOfRows() + rowIndex;
            }

            @Override
            Well getWell(int index, PlateFormat type) {
                Well.verifyPositiveIndex(index);
                int modIndex = index % type.getNumberOfWells();
                int colIndex = modIndex / type.getNumberOfRows();
                int rowIndex = modIndex % type.getNumberOfRows();
                rowIndex = rowIndex >= type.getNumberOfRows() / 2 ? rowIndex % (type.getNumberOfRows() / 2) * 2 + 1 : rowIndex % (type.getNumberOfRows() / 2) * 2;
                char row = (char)(65 + rowIndex);
                int column = colIndex + 1;
                return Well.getWell(row, column);
            }
        }
        ,
        ABI_3130_16_CAPILLARIES{

            @Override
            int getIndex(Well well, PlateFormat type) {
                if (type != PlateFormat._96) {
                    throw new IllegalArgumentException("only 96 well plates supported");
                }
                int rowIndex = well.getRow() - 65;
                int colIndex = well.getColumn() - 1;
                int capilaryIndex = colIndex / 2;
                return capilaryIndex * 16 + rowIndex * 2 + colIndex % 2;
            }

            @Override
            Well getWell(int index, PlateFormat type) {
                Well.verifyPositiveIndex(index);
                if (type != PlateFormat._96) {
                    throw new IllegalArgumentException("only 96 well plates supported");
                }
                int modIndex = index % type.getNumberOfWells();
                int capilaryIndex = modIndex / 16;
                int i = modIndex % 16;
                char row = (char)(65 + i / 2);
                int column = modIndex % 2 + capilaryIndex * 2 + 1;
                return Well.getWell(row, column);
            }
        };


        abstract int getIndex(Well var1, PlateFormat var2);

        abstract Well getWell(int var1, PlateFormat var2);

        public Comparator<Well> create96WellComparator() {
            return this.createWellComparator(PlateFormat._96);
        }

        public Comparator<Well> create384WellComparator() {
            return this.createWellComparator(PlateFormat._384);
        }

        public Comparator<Well> createWellComparator(PlateFormat format) {
            return new IndexOrderComparator(format, this);
        }

        public int getQuadrantIndex(Well well, PlateFormat type) {
            int wellIndex = this.getIndex(well, type);
            return wellIndex / type.getNumberOfWellsPerQuadrant();
        }
    }
}

