/*
 * Decompiled with CFR 0.152.
 */
package org.jcvi.jillion.experimental.plate;

import java.util.NoSuchElementException;
import java.util.SortedSet;
import java.util.TreeSet;
import org.jcvi.jillion.experimental.plate.PlateFormat;
import org.jcvi.jillion.experimental.plate.Well;

public final class PlatePopulator {
    private final Well.IndexOrder indexOrder;
    private final SortedSet<Well> unusedWells;
    private final PlateFormat format;

    public PlatePopulator(Well.IndexOrder indexOrder, PlateFormat format) {
        if (indexOrder == null) {
            throw new NullPointerException("index order can not be null");
        }
        if (format == null) {
            throw new NullPointerException("plate format can not be null");
        }
        this.indexOrder = indexOrder;
        this.format = format;
        this.unusedWells = new TreeSet<Well>(indexOrder.createWellComparator(format));
        this.newPlate();
    }

    public boolean isUnused(Well well) {
        if (well == null) {
            throw new NullPointerException("well can not be null");
        }
        return this.unusedWells.contains(well);
    }

    public void use(Well well) {
        if (well == null) {
            throw new NullPointerException("well can not be null");
        }
        if (!this.isUnused(well)) {
            throw new IllegalArgumentException("already used " + well);
        }
        this.unusedWells.remove(well);
    }

    public int getNumberOfUnusedWells() {
        return this.unusedWells.size();
    }

    public boolean isFull() {
        return this.unusedWells.isEmpty();
    }

    public Well nextUnusedWell() {
        if (this.isFull()) {
            throw new NoSuchElementException("no more unused wells");
        }
        return this.unusedWells.first();
    }

    public void finishedPlate() {
        this.unusedWells.clear();
    }

    public void newPlate() {
        this.finishedPlate();
        for (int i = 0; i < this.format.getNumberOfWells(); ++i) {
            this.unusedWells.add(Well.computeWell(this.format, i, this.indexOrder));
        }
    }
}

