/*
 * Decompiled with CFR 0.152.
 */
package org.jcvi.jillion.experimental.plate;

public enum PlateFormat {
    _384(384, 24),
    _96(96, 12);

    private final int numberOfWells;
    private final int numberOfColumns;
    private final int numberOfRows;

    private PlateFormat(int numberOfWells, int numberOfColumns) {
        this.numberOfWells = numberOfWells;
        this.numberOfColumns = numberOfColumns;
        this.numberOfRows = numberOfWells / numberOfColumns;
    }

    public static PlateFormat getFormatFor(int numberOfWells) {
        if (numberOfWells < 1) {
            throw new IllegalArgumentException("number of wells must be positive");
        }
        for (PlateFormat f : PlateFormat.values()) {
            if (numberOfWells != f.getNumberOfRows()) continue;
            return f;
        }
        throw new IllegalArgumentException("no plate format for " + numberOfWells);
    }

    public int getNumberOfWells() {
        return this.numberOfWells;
    }

    public int getNumberOfColumns() {
        return this.numberOfColumns;
    }

    public int getNumberOfRows() {
        return this.numberOfRows;
    }

    public int getNumberOfWellsPerQuadrant() {
        return this.numberOfWells / 4;
    }
}

