/*
 * Decompiled with CFR 0.152.
 */
package org.jcvi.jillion.experimental.ncbi.submit.assemblyArchive;

import java.io.BufferedOutputStream;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.math.BigInteger;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.SortedSet;
import java.util.TreeSet;
import org.jcvi.jillion.assembly.AssembledRead;
import org.jcvi.jillion.assembly.Contig;
import org.jcvi.jillion.assembly.consed.ace.AceContig;
import org.jcvi.jillion.assembly.util.SliceMap;
import org.jcvi.jillion.assembly.util.SliceMapBuilder;
import org.jcvi.jillion.assembly.util.consensus.ConicConsensusCaller;
import org.jcvi.jillion.assembly.util.consensus.ConsensusResult;
import org.jcvi.jillion.core.Range;
import org.jcvi.jillion.core.io.IOUtil;
import org.jcvi.jillion.core.qual.PhredQuality;
import org.jcvi.jillion.core.qual.QualitySequence;
import org.jcvi.jillion.core.qual.QualitySequenceDataStore;
import org.jcvi.jillion.core.residue.nt.NucleotideSequence;
import org.jcvi.jillion.core.residue.nt.NucleotideSequenceBuilder;
import org.jcvi.jillion.core.residue.nt.ReferenceMappedNucleotideSequence;
import org.jcvi.jillion.core.util.iter.StreamingIterator;
import org.jcvi.jillion.experimental.ncbi.submit.assemblyArchive.AssemblyArchiveConformation;
import org.jcvi.jillion.experimental.ncbi.submit.assemblyArchive.AssemblyArchiveMetaData;
import org.jcvi.jillion.experimental.ncbi.submit.assemblyArchive.AssemblyArchiveType;
import org.jcvi.jillion.experimental.ncbi.submit.assemblyArchive.AssemblyArchiveWriter;
import org.jcvi.jillion.internal.core.util.GrowableIntArray;

public class AssemblyArchiveWriterBuilder {
    private final File outputDirectory;
    private final QualitySequenceDataStore qualityDataStore;
    private final AssemblyArchiveMetaData sampleMetaData;
    private AssemblyArchiveFilenameFactory filenamefactory = null;
    private boolean crossLinkContigSubmission = true;

    public AssemblyArchiveWriterBuilder(File outputDirectory, QualitySequenceDataStore qualityDataStore, AssemblyArchiveMetaData sampleMetaData) {
        if (outputDirectory == null) {
            throw new NullPointerException("output directory can not be null");
        }
        if (qualityDataStore == null) {
            throw new NullPointerException("quality sequence datastore can not be null");
        }
        if (sampleMetaData == null) {
            throw new NullPointerException("sampleMetaData datastore can not be null");
        }
        this.outputDirectory = outputDirectory;
        this.qualityDataStore = qualityDataStore;
        this.sampleMetaData = sampleMetaData;
    }

    public AssemblyArchiveWriterBuilder writeContigDataToSeparateFiles(AssemblyArchiveFilenameFactory factory) {
        this.filenamefactory = factory;
        return this;
    }

    public AssemblyArchiveWriterBuilder crossLinkContigSubmission(boolean value) {
        this.crossLinkContigSubmission = value;
        return this;
    }

    public AssemblyArchiveWriter build() throws IOException {
        return new Writer(this);
    }

    private static class ReadSorter
    implements Comparator<AssembledRead> {
        private final AssemblyArchiveWriter.TraceNameLookup lookup;

        public ReadSorter(AssemblyArchiveWriter.TraceNameLookup lookup) {
            this.lookup = lookup;
        }

        @Override
        public int compare(AssembledRead o1, AssembledRead o2) {
            String o2Ti;
            int rangeCmp = Range.Comparators.ARRIVAL.compare(o1.asRange(), o2.asRange());
            if (rangeCmp != 0) {
                return rangeCmp;
            }
            String o1Ti = this.lookup.getTraceNameByContigReadId(o1.getId());
            int tiCmp = o1Ti.compareTo(o2Ti = this.lookup.getTraceNameByContigReadId(o2.getId()));
            if (tiCmp != 0) {
                return tiCmp;
            }
            return o1.getId().compareTo(o2.getId());
        }
    }

    public static interface AssemblyArchiveFilenameFactory {
        public String createConsensusGapFileNameFor(Contig<?> var1);

        public String createConsensusQualityFileNameFor(Contig<?> var1);

        public String createConsensusSequenceFileNameFor(Contig<?> var1);
    }

    private static final class Writer
    implements AssemblyArchiveWriter {
        private static final DateFormat DATE_FORMATTER = new SimpleDateFormat("MM/dd/yy HH:mm:ss", Locale.US);
        private final File outputDirectory;
        private final AssemblyArchiveFilenameFactory filenamefactory;
        private final boolean crossLinkContigSubmission;
        private final AssemblyArchiveMetaData sampleMetaData;
        private final QualitySequenceDataStore qualityDataStore;
        private long numberOfTotalReads = 0L;
        private long numberOfTotalReadBases = 0L;
        private long numberOfTotalConsensusBases = 0L;
        private List<String> contigNames = new ArrayList<String>();
        private List<File> extraFilesCreated = new ArrayList<File>();
        private final File tempFile;
        private final java.io.Writer tempOut;
        private AssemblyArchiveType overallType = AssemblyArchiveType.NEW;
        private static final String EOL = String.format("%n", new Object[0]);

        public Writer(AssemblyArchiveWriterBuilder builder) throws IOException {
            this.outputDirectory = builder.outputDirectory;
            this.filenamefactory = builder.filenamefactory;
            this.crossLinkContigSubmission = builder.crossLinkContigSubmission;
            this.qualityDataStore = builder.qualityDataStore;
            this.sampleMetaData = builder.sampleMetaData;
            IOUtil.mkdirs(this.outputDirectory);
            this.tempFile = File.createTempFile("asmArchive", null, this.outputDirectory);
            this.tempOut = IOUtil.createNewBufferedWriter(this.tempFile, "UTF-8");
        }

        @Override
        public void close() throws IOException {
            this.tempOut.close();
            File xmlFile = this.writeAssemblyFile();
            this.writeManifestFile(xmlFile);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private File writeManifestFile(File xmlFile) throws IOException {
            File manifestFile = new File(this.outputDirectory, "MANIFEST");
            PrintWriter writer = new PrintWriter(IOUtil.createNewBufferedWriter(manifestFile, "UTF-8"));
            try {
                for (File f : this.extraFilesCreated) {
                    writer.printf("%s: %s%n", f.getName(), this.computeMd5(f));
                }
                writer.printf("%s: %s%n", xmlFile.getName(), this.computeMd5(xmlFile));
                File file = manifestFile;
                return file;
            }
            finally {
                IOUtil.closeAndIgnoreErrors((Closeable)writer);
            }
        }

        private String computeMd5(File f) throws IOException {
            MessageDigest m;
            try {
                m = MessageDigest.getInstance("MD5");
            }
            catch (NoSuchAlgorithmException e) {
                throw new IllegalStateException("error getting MD5 algorithm", e);
            }
            m.reset();
            m.update(IOUtil.toByteArray(f));
            byte[] digest = m.digest();
            String hexString = new BigInteger(1, digest).toString(16);
            return this.padString(hexString);
        }

        private String padString(String hexString) {
            int length = hexString.length();
            int padding = 32 - length;
            if (padding == 0) {
                return hexString;
            }
            char[] pads = new char[padding];
            Arrays.fill(pads, '0');
            return new StringBuilder(32).append(pads).append(hexString).toString();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private File writeAssemblyFile() throws IOException {
            File xmlFile = new File(this.outputDirectory, "ASSEMBLY.xml");
            BufferedOutputStream out = new BufferedOutputStream(new FileOutputStream(xmlFile));
            try {
                double coverage = (double)this.numberOfTotalReadBases / (double)this.numberOfTotalConsensusBases;
                String header = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>" + EOL + String.format("<assembly submitter_reference=\"%s\" type=\"%s\">%n", new Object[]{this.sampleMetaData.getSubmitterReference(), this.overallType}) + Writer.createTag("center_name", this.sampleMetaData.getCenterName()) + Writer.createTag("date", Writer.formatDate(this.sampleMetaData.getSubmissionDate())) + Writer.createTag("organism", this.sampleMetaData.getOrganismName()) + Writer.createTag("description", this.sampleMetaData.getDescription()) + Writer.createTag("structure", this.sampleMetaData.getStructure()) + Writer.createTag("ncontigs", this.contigNames.size()) + Writer.createTag("nconbases", this.numberOfTotalConsensusBases) + Writer.createTag("ntraces", this.numberOfTotalReads) + Writer.createTag("nbasecalls", this.numberOfTotalReadBases) + Writer.createTag("coverage", String.format("%.2f", coverage));
                ((OutputStream)out).write(header.getBytes(IOUtil.UTF_8));
                FileInputStream tempIn = new FileInputStream(this.tempFile);
                try {
                    IOUtil.copy(tempIn, out);
                }
                finally {
                    IOUtil.closeAndIgnoreErrors((Closeable)tempIn);
                }
                ((OutputStream)out).write(("</assembly>" + EOL).getBytes(IOUtil.UTF_8));
                IOUtil.delete(this.tempFile);
                File file = xmlFile;
                return file;
            }
            finally {
                IOUtil.closeAndIgnoreErrors((Closeable)out);
            }
        }

        private static synchronized String formatDate(Date date) {
            return DATE_FORMATTER.format(date);
        }

        @Override
        public void write(String submitterReference, AssemblyArchiveConformation conformation, AssemblyArchiveType type, Contig<? extends AssembledRead> superContig, AssemblyArchiveWriter.TraceNameLookup lookup) throws IOException {
            if (submitterReference == null) {
                throw new NullPointerException("submitter ref can not be null");
            }
            if (conformation == null) {
                throw new NullPointerException("contig conformation can not be null");
            }
            if (type == null) {
                throw new NullPointerException("contig submission type can not be null");
            }
            if (superContig == null) {
                throw new NullPointerException("super contig can not be null");
            }
            if (lookup == null) {
                throw new NullPointerException("TraceNameLookup can not be null");
            }
            if (type != AssemblyArchiveType.NEW) {
                this.overallType = AssemblyArchiveType.UPDATE;
            }
            this.contigNames.add(superContig.getId());
            this.writeContigHeader(submitterReference, conformation, type);
            this.handleConsensus(submitterReference, conformation, type, superContig);
            this.handleReads(superContig, lookup);
            this.tempOut.write(String.format("</contig>%n", new Object[0]));
        }

        private void handleReads(Contig<? extends AssembledRead> superContig, AssemblyArchiveWriter.TraceNameLookup lookup) throws IOException {
            NucleotideSequence consensusSequence = superContig.getConsensusSequence();
            SortedSet<AssembledRead> sortedReads = this.sortReads(superContig, lookup);
            for (AssembledRead read : sortedReads) {
                Range validRange = read.getReadInfo().getValidRange();
                StringBuilder readRecord = new StringBuilder(300);
                long readStart = read.getGappedStartOffset();
                long readEnd = read.getGappedEndOffset();
                ReferenceMappedNucleotideSequence readSequence = read.getNucleotideSequence();
                List<Integer> readGapOffsets = readSequence.getGapOffsets();
                readRecord.append("<trace>").append(EOL).append(Writer.createTag("trace_name", lookup.getTraceNameByContigReadId(read.getId()), 1)).append(Writer.createTag("nbasecalls", readSequence.getUngappedLength(), 1)).append("\t<valid>").append(EOL).append(Writer.createTag("start", validRange.getBegin() + 1L, 2)).append(Writer.createTag("stop", validRange.getEnd() + 1L, 2)).append("\t</valid>").append(EOL).append(String.format("\t<tiling direction = \"%s\">", new Object[]{read.getDirection()})).append(EOL).append(Writer.createTag("start", readStart + 1L, 2)).append(Writer.createTag("stop", readEnd + 1L, 2)).append("\t</tiling>").append(EOL).append("\t<traceconsensus>").append(EOL).append(Writer.createTag("start", consensusSequence.getUngappedOffsetFor((int)readStart) + 1, 2)).append(Writer.createTag("stop", consensusSequence.getUngappedOffsetFor((int)readEnd) + 1, 2)).append("\t</traceconsensus>").append(EOL);
                if (!readGapOffsets.isEmpty()) {
                    readRecord.append(Writer.createTag("ntracegaps", readGapOffsets.size(), 1)).append(String.format("\t<tracegaps source=\"INLINE\">%s</tracegaps>%n", this.createDeltaGapString(readGapOffsets)));
                }
                readRecord.append("</trace>").append(EOL);
                this.tempOut.write(readRecord.toString());
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private SortedSet<AssembledRead> sortReads(Contig<? extends AssembledRead> superContig, AssemblyArchiveWriter.TraceNameLookup lookup) {
            TreeSet<AssembledRead> sortedReads = new TreeSet<AssembledRead>(new ReadSorter(lookup));
            StreamingIterator<? extends AssembledRead> readIter = superContig.getReadIterator();
            try {
                while (readIter.hasNext()) {
                    sortedReads.add(readIter.next());
                }
                TreeSet<AssembledRead> treeSet = sortedReads;
                return treeSet;
            }
            finally {
                IOUtil.closeAndIgnoreErrors(readIter);
            }
        }

        private void handleConsensus(String submitterReference, AssemblyArchiveConformation conformation, AssemblyArchiveType type, Contig<? extends AssembledRead> superContig) throws IOException, FileNotFoundException {
            long numberOfReads = superContig.getNumberOfReads();
            this.numberOfTotalReads += numberOfReads;
            this.tempOut.write(Writer.createTag("ntraces", numberOfReads));
            NucleotideSequence consensusSequence = superContig.getConsensusSequence();
            long ungappedLength = consensusSequence.getUngappedLength();
            this.numberOfTotalConsensusBases += ungappedLength;
            this.tempOut.write(Writer.createTag("nconbases", ungappedLength));
            long numberOfReadBases = this.getNumberOfReadBases(superContig);
            this.numberOfTotalReadBases += numberOfReadBases;
            this.tempOut.write(Writer.createTag("nbasecalls", numberOfReadBases));
            List<Integer> gapOffsets = consensusSequence.getGapOffsets();
            if (!gapOffsets.isEmpty()) {
                this.tempOut.write(Writer.createTag("ncongaps", gapOffsets.size()));
            }
            String deltaGapString = this.createDeltaGapString(gapOffsets);
            String consensusQualities = this.computeConsensusQualities(superContig);
            if (this.writeContigDataToSeparateFiles()) {
                if (!gapOffsets.isEmpty()) {
                    String consensusGapFilename = this.filenamefactory.createConsensusGapFileNameFor(superContig);
                    File consensusGapFile = new File(this.outputDirectory, consensusGapFilename);
                    this.extraFilesCreated.add(consensusGapFile);
                    this.writeSourceFile(consensusGapFile, deltaGapString);
                    this.tempOut.write(String.format("<congaps source=\"FILE\">%s</congaps>%n", consensusGapFile.getName()));
                }
                String consensusQualFilename = this.filenamefactory.createConsensusQualityFileNameFor(superContig);
                File consensusQualFile = new File(this.outputDirectory, consensusQualFilename);
                this.extraFilesCreated.add(consensusQualFile);
                this.writeSourceFile(consensusQualFile, consensusQualities);
                if (this.crossLinkContigSubmission) {
                    this.tempOut.write(String.format("<consensus source=\"ACCESSION\"></consensus>%n", new Object[0]));
                } else {
                    String consensusFilename = this.filenamefactory.createConsensusSequenceFileNameFor(superContig);
                    File consensusFile = new File(this.outputDirectory, consensusFilename);
                    this.extraFilesCreated.add(consensusFile);
                    this.writeSourceFile(consensusFile, new NucleotideSequenceBuilder(consensusSequence).ungap().toString());
                }
                this.tempOut.write(String.format("<conqualities source=\"FILE\">%s</conqualities>%n", consensusQualFile.getName()));
            } else {
                if (!gapOffsets.isEmpty()) {
                    this.tempOut.write(String.format("<congaps source=\"INLINE\">%s</congaps>%n", deltaGapString));
                }
                if (this.crossLinkContigSubmission) {
                    this.tempOut.write(String.format("<consensus source=\"ACCESSION\"></consensus>%n", new Object[0]));
                } else {
                    this.tempOut.write(String.format("<consensus source=\"INLINE\">%s</consensus>%n", new NucleotideSequenceBuilder(consensusSequence).ungap().toString()));
                }
                this.tempOut.write(String.format("<conqualities source=\"INLINE\">%s</conqualities>%n", consensusQualities));
            }
        }

        private String computeConsensusQualities(Contig<?> superContig) {
            if (superContig instanceof AceContig) {
                QualitySequence quals = ((AceContig)superContig).getConsensusQualitySequence();
                StringBuilder builder = new StringBuilder((int)quals.getLength() * 5);
                Iterator qualIter = quals.iterator();
                if (qualIter.hasNext()) {
                    // empty if block
                }
                while (qualIter.hasNext()) {
                    builder.append(" " + ((PhredQuality)qualIter.next()).getQualityScore());
                }
                return builder.toString();
            }
            SliceMap sliceMap = new SliceMapBuilder(superContig, this.qualityDataStore).build();
            NucleotideSequence consensusSequence = superContig.getConsensusSequence();
            GrowableIntArray gapOffsets = new GrowableIntArray(consensusSequence.getGapOffsets());
            StringBuilder builder = new StringBuilder((int)consensusSequence.getLength() * 5);
            ConicConsensusCaller consensusCaller = new ConicConsensusCaller(PhredQuality.valueOf(30));
            int i = 0;
            while ((long)i < sliceMap.getSize()) {
                if (gapOffsets.binarySearch(i) < 0) {
                    ConsensusResult consensus = consensusCaller.callConsensus(sliceMap.getSlice(i));
                    builder.append(" " + consensus.getConsensusQuality());
                }
                ++i;
            }
            return builder.substring(1);
        }

        private void writeSourceFile(File file, String data) throws IOException {
            PrintWriter pw = new PrintWriter(IOUtil.createNewBufferedWriter(file, "UTF-8"));
            pw.print(data);
            pw.close();
        }

        private boolean writeContigDataToSeparateFiles() {
            return this.filenamefactory != null;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private long getNumberOfReadBases(Contig<? extends AssembledRead> superContig) {
            StreamingIterator<? extends AssembledRead> readIter = superContig.getReadIterator();
            long numberOfReadBases = 0L;
            try {
                while (readIter.hasNext()) {
                    numberOfReadBases += readIter.next().getNucleotideSequence().getUngappedLength();
                }
            }
            finally {
                IOUtil.closeAndIgnoreErrors(readIter);
            }
            return numberOfReadBases;
        }

        private String createDeltaGapString(List<Integer> gapOffsets) {
            int previous = 0;
            StringBuilder sb = new StringBuilder();
            for (Integer index : gapOffsets) {
                sb.append(index - previous);
                sb.append(' ');
                previous = index + 1;
            }
            return sb.toString().trim();
        }

        private void writeContigHeader(String submitterReference, AssemblyArchiveConformation conformation, AssemblyArchiveType type) throws IOException {
            this.tempOut.write(String.format("<contig submitter_reference=\"%s\" conformation=\"%s\" type =\"%s\">%n", new Object[]{submitterReference, conformation, type}));
        }

        private static String createTag(String field, int value, int level) {
            return Writer.createTag(field, Integer.toString(value), level);
        }

        private static String createTag(String field, int value) {
            return Writer.createTag(field, value, 0);
        }

        private static String createTag(String field, long value, int level) {
            return Writer.createTag(field, Long.toString(value), level);
        }

        private static String createTag(String field, long value) {
            return Writer.createTag(field, value, 0);
        }

        private static String createTag(String field, String value) {
            return Writer.createTag(field, value, 0);
        }

        private static String createTag(String field, String value, int level) {
            StringBuilder builder = new StringBuilder(field.length() + value.length() + 6);
            for (int i = 0; i < level; ++i) {
                builder.append('\t');
            }
            return builder.append('<').append(field).append('>').append(value).append("</").append(field).append('>').append(EOL).toString();
        }
    }
}

