/*
 * Decompiled with CFR 0.152.
 */
package org.jcvi.jillion.experimental.assembly.agp;

import java.io.File;
import java.io.FileNotFoundException;
import org.jcvi.jillion.assembly.DefaultScaffoldDataStore;
import org.jcvi.jillion.assembly.Scaffold;
import org.jcvi.jillion.assembly.ScaffoldDataStore;
import org.jcvi.jillion.assembly.ScaffoldDataStoreBuilder;
import org.jcvi.jillion.core.DirectedRange;
import org.jcvi.jillion.core.Direction;
import org.jcvi.jillion.core.Range;
import org.jcvi.jillion.experimental.assembly.agp.AgpFileVisitor;
import org.jcvi.jillion.experimental.assembly.agp.AgpParser;
import org.jcvi.jillion.experimental.assembly.agp.ScaffoldDataStoreBuilderAgpVisitor;

public final class DefaultAgpScaffoldDataStore {
    private DefaultAgpScaffoldDataStore() {
    }

    public static ScaffoldDataStoreBuilderAgpVisitor createBuilder() {
        return new Builder();
    }

    public static ScaffoldDataStore create(File agpFile) throws FileNotFoundException {
        ScaffoldDataStoreBuilderAgpVisitor builder = DefaultAgpScaffoldDataStore.createBuilder();
        AgpParser.parseAgpFile(agpFile, (AgpFileVisitor)builder);
        return (ScaffoldDataStore)builder.build();
    }

    private static final class Builder
    implements ScaffoldDataStoreBuilderAgpVisitor {
        ScaffoldDataStoreBuilder builder = DefaultScaffoldDataStore.createBuilder();

        private Builder() {
        }

        @Override
        public void visitContigEntry(String scaffoldId, Range contigRange, String contigId, Direction dir) {
            this.builder.addPlacedContig(scaffoldId, contigId, DirectedRange.create(contigRange, dir));
        }

        @Override
        public void visitLine(String line) {
        }

        @Override
        public void visitEndOfFile() {
        }

        @Override
        public void visitFile() {
        }

        @Override
        public ScaffoldDataStoreBuilder addScaffold(Scaffold scaffold) {
            this.builder.addScaffold(scaffold);
            return this;
        }

        @Override
        public ScaffoldDataStoreBuilder addPlacedContig(String scaffoldId, String contigId, DirectedRange directedRange) {
            this.builder.addPlacedContig(scaffoldId, contigId, directedRange);
            return this;
        }

        @Override
        public ScaffoldDataStore build() {
            return (ScaffoldDataStore)this.builder.build();
        }
    }
}

