/*
 * Decompiled with CFR 0.152.
 */
package org.jcvi.jillion.experimental.assembly.agp;

import java.io.IOException;
import java.io.OutputStream;
import org.jcvi.jillion.assembly.PlacedContig;
import org.jcvi.jillion.assembly.Scaffold;
import org.jcvi.jillion.assembly.util.CoverageMap;
import org.jcvi.jillion.assembly.util.CoverageRegion;
import org.jcvi.jillion.core.Range;
import org.jcvi.jillion.core.io.IOUtil;

public final class AgpWriter {
    private AgpWriter() {
    }

    public static void writeScaffold(Scaffold scaffold, OutputStream out) throws IOException {
        CoverageMap<PlacedContig> coverageMap = scaffold.getContigCoverageMap();
        String scaffoldId = scaffold.getId();
        int partNumber = 1;
        for (CoverageRegion coverageRegion : coverageMap) {
            if (coverageRegion.getCoverageDepth() == 0) {
                AgpWriter.writeNs(scaffoldId, partNumber, coverageRegion.asRange(), out);
                ++partNumber;
                continue;
            }
            for (PlacedContig contig : coverageRegion) {
                AgpWriter.writeContig(scaffoldId, partNumber, contig, out);
                ++partNumber;
            }
        }
    }

    private static void writeContig(String scaffoldId, int partNumber, PlacedContig contig, OutputStream out) throws IOException {
        Range range = contig.asRange();
        String line = String.format("%s\t%d\t%d\t%d\tW\t%s\t1\t%d\t+%n", scaffoldId, range.getBegin(Range.CoordinateSystem.RESIDUE_BASED), range.getEnd(Range.CoordinateSystem.RESIDUE_BASED), partNumber, contig.getContigId(), range.getLength());
        out.write(line.getBytes(IOUtil.UTF_8));
    }

    private static void writeNs(String scaffoldId, int partNumber, Range range, OutputStream out) throws IOException {
        String line = String.format("%s\t%d\t%d\t%d\tN\t%d\tcontig\tno\tna%n", scaffoldId, range.getBegin(Range.CoordinateSystem.RESIDUE_BASED), range.getEnd(Range.CoordinateSystem.RESIDUE_BASED), partNumber, range.getLength());
        out.write(line.getBytes(IOUtil.UTF_8));
    }
}

