/*
 * Decompiled with CFR 0.152.
 */
package org.jcvi.jillion.experimental.assembly.agp;

import java.io.BufferedInputStream;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.util.Scanner;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jcvi.jillion.core.Direction;
import org.jcvi.jillion.core.Range;
import org.jcvi.jillion.core.io.IOUtil;
import org.jcvi.jillion.experimental.assembly.agp.AgpFileVisitor;

public final class AgpParser {
    private static final Pattern CONTIG_PATTERN = Pattern.compile("(\\S+)\\s+(\\d+)\\s+(\\d+)\\s+\\d+\\s+([A,D,F,G,N,O,P,U,W])\\s+(\\S+)\\s+(\\d+)\\s+(\\d+)\\s+([+,-])");

    private AgpParser() {
    }

    public static void parseAgpFile(File agpFile, AgpFileVisitor visitor) throws FileNotFoundException {
        AgpParser.parseAgpFile(agpFile, visitor, Range.CoordinateSystem.RESIDUE_BASED);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void parseAgpFile(File agpFile, AgpFileVisitor visitor, Range.CoordinateSystem agpFileCoordinateSystem) throws FileNotFoundException {
        BufferedInputStream agpStream = null;
        try {
            agpStream = new BufferedInputStream(new FileInputStream(agpFile));
            AgpParser.parseAgpFile(agpStream, visitor, agpFileCoordinateSystem);
        }
        catch (Throwable throwable) {
            IOUtil.closeAndIgnoreErrors(agpStream);
            throw throwable;
        }
        IOUtil.closeAndIgnoreErrors((Closeable)agpStream);
    }

    public static void parseAgpFile(InputStream in, AgpFileVisitor visitor) {
        AgpParser.parseAgpFile(in, visitor, Range.CoordinateSystem.RESIDUE_BASED);
    }

    public static void parseAgpFile(InputStream in, AgpFileVisitor visitor, Range.CoordinateSystem agpFileCoordinateSystem) {
        Scanner scanner = new Scanner(in, "UTF-8");
        while (scanner.hasNextLine()) {
            String line = scanner.nextLine();
            Matcher matcher = CONTIG_PATTERN.matcher(line);
            if (!matcher.find()) continue;
            String scaffoldId = matcher.group(1);
            Range contigRange = Range.of(agpFileCoordinateSystem, Long.parseLong(matcher.group(2)), Long.parseLong(matcher.group(3)));
            String contigId = matcher.group(5);
            Direction dir = Direction.parseSequenceDirection(matcher.group(8));
            visitor.visitContigEntry(scaffoldId, contigRange, contigId, dir);
        }
        visitor.visitEndOfFile();
    }
}

