/*
 * Decompiled with CFR 0.152.
 */
package org.jcvi.jillion.experimental.align.blast.btab;

import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.math.RoundingMode;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import org.jcvi.jillion.core.DirectedRange;
import org.jcvi.jillion.core.Direction;
import org.jcvi.jillion.core.Range;
import org.jcvi.jillion.core.io.IOUtil;
import org.jcvi.jillion.core.util.JoinedStringBuilder;
import org.jcvi.jillion.experimental.align.blast.BlastHit;
import org.jcvi.jillion.experimental.align.blast.Hsp;
import org.jcvi.jillion.experimental.align.blast.btab.BtabWriter;

public final class BtabWriterBuilder {
    private final File outputFile;
    private final OutputStream outStream;
    private Date runDate = new Date();
    private boolean includePvalue = true;
    private Locale locale = Locale.getDefault();

    public BtabWriterBuilder(File outputFile) {
        if (outputFile == null) {
            throw new NullPointerException();
        }
        this.outputFile = outputFile;
        this.outStream = null;
    }

    public BtabWriterBuilder locale(Locale locale) {
        Objects.requireNonNull(locale);
        this.locale = locale;
        return this;
    }

    public BtabWriterBuilder(OutputStream out) {
        if (out == null) {
            throw new NullPointerException();
        }
        this.outputFile = null;
        this.outStream = out;
    }

    public BtabWriterBuilder setRunDate(Date date) {
        if (date == null) {
            throw new NullPointerException();
        }
        this.runDate = new Date(date.getTime());
        return this;
    }

    public BtabWriterBuilder includePvalue(boolean includePvalue) {
        this.includePvalue = includePvalue;
        return this;
    }

    public BtabWriter build() throws IOException {
        return new BtabWriterImpl(this);
    }

    private static final class BtabWriterImpl
    implements BtabWriter {
        private final PrintWriter out;
        private final String formattedRunDate;
        private final NumberFormat scientificNotationFormatter;
        private final boolean includePvalue;

        private BtabWriterImpl(BtabWriterBuilder builder) throws IOException {
            this.out = builder.outputFile == null ? new PrintWriter(IOUtil.createNewBufferedWriter(builder.outStream, "UTF-8")) : new PrintWriter(IOUtil.createNewBufferedWriter(builder.outputFile, "UTF-8"));
            this.formattedRunDate = new SimpleDateFormat("MMM dd yyyy", builder.locale).format(builder.runDate);
            this.scientificNotationFormatter = new DecimalFormat("0.0E0");
            this.scientificNotationFormatter.setRoundingMode(RoundingMode.HALF_UP);
            this.scientificNotationFormatter.setMinimumFractionDigits(5);
            this.includePvalue = builder.includePvalue;
        }

        @Override
        public void close() throws IOException {
            this.out.close();
        }

        @Override
        public void write(BlastHit hit) throws IOException {
            for (Hsp<?, ?, ?> hsp : hit.getHsps()) {
                ArrayList<String> fields = new ArrayList<String>(21);
                fields.add(hsp.getQueryId());
                fields.add(this.formattedRunDate);
                fields.add(hsp.getQueryLength() == null ? "" : hsp.getQueryLength().toString());
                fields.add(hit.getBlastProgramName());
                fields.add(hit.getBlastDbName());
                fields.add(hsp.getSubjectId());
                DirectedRange queryDirectedRange = hsp.getQueryRange();
                DirectedRange subjectDirectedRange = hsp.getSubjectRange();
                this.appendRangeCoordinates(queryDirectedRange, fields);
                this.appendRangeCoordinates(subjectDirectedRange, fields);
                double alignmentLength = hsp.getAlignmentLength();
                fields.add(String.format("%.2f", (double)hsp.getNumberOfIdentitcalMatches().intValue() / alignmentLength * 100.0));
                fields.add(String.format("%.2f", (double)hsp.getNumberOfPositiveMatches().intValue() / alignmentLength * 100.0));
                fields.add(hsp.getHspScore() == null ? "0.0" : hsp.getHspScore().toString());
                fields.add(hsp.getBitScore().toString());
                fields.add(Integer.toString((int)alignmentLength));
                fields.add(hsp.getSubjectDefinition() == null ? "" : hsp.getSubjectDefinition());
                fields.add(hsp.getHitFrame() == null ? "" : Integer.toString(hsp.getHitFrame()));
                fields.add(queryDirectedRange.getDirection() == Direction.FORWARD ? "Plus" : "Minus");
                fields.add(Integer.toString(hsp.getSubjectLength()));
                String formattedEvalue = this.scientificNotationFormatter.format(hsp.getEvalue());
                if (this.includePvalue) {
                    fields.add(formattedEvalue);
                    fields.add(formattedEvalue);
                } else {
                    fields.add(formattedEvalue + "\t");
                }
                this.out.println(JoinedStringBuilder.create(fields).glue("\t").build());
            }
        }

        private void appendRangeCoordinates(DirectedRange directedRange, List<String> fields) {
            Range range = directedRange.getRange();
            if (directedRange.getDirection() == Direction.FORWARD) {
                fields.add(Long.toString(range.getBegin(Range.CoordinateSystem.RESIDUE_BASED)));
                fields.add(Long.toString(range.getEnd(Range.CoordinateSystem.RESIDUE_BASED)));
            } else {
                fields.add(Long.toString(range.getEnd(Range.CoordinateSystem.RESIDUE_BASED)));
                fields.add(Long.toString(range.getBegin(Range.CoordinateSystem.RESIDUE_BASED)));
            }
        }
    }
}

