/*
 * Decompiled with CFR 0.152.
 */
package org.jcvi.jillion.experimental.align.blast;

import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.math.BigDecimal;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jcvi.jillion.core.DirectedRange;
import org.jcvi.jillion.core.Range;
import org.jcvi.jillion.core.io.IOUtil;
import org.jcvi.jillion.core.residue.nt.Nucleotide;
import org.jcvi.jillion.core.residue.nt.NucleotideSequence;
import org.jcvi.jillion.core.residue.nt.NucleotideSequenceBuilder;
import org.jcvi.jillion.experimental.align.blast.BlastHitImpl;
import org.jcvi.jillion.experimental.align.blast.BlastParser;
import org.jcvi.jillion.experimental.align.blast.BlastVisitor;
import org.jcvi.jillion.experimental.align.blast.Hsp;
import org.jcvi.jillion.experimental.align.blast.HspBuilder;
import org.jcvi.jillion.internal.core.io.OpenAwareInputStream;
import org.jcvi.jillion.internal.core.io.TextLineParser;

public abstract class TabularBlastParser
implements BlastParser {
    private static final Pattern TYPE_PATTERN = Pattern.compile("^# (\\S*BLAST\\S+).*");
    private static final Pattern HIT_PATTERN = Pattern.compile("(\\S+)\\s+(\\S+)\\s+(\\d+\\.?\\d*)\\s+(\\d+)\\s+(\\d+)\\s+(\\d+)\\s+(\\d+)\\s+(\\d+)\\s+(\\d+)\\s+(\\d+)\\s+(\\S+)\\s+(\\d+\\.?\\d*)");

    private TabularBlastParser() {
    }

    public static BlastParser create(File file) throws IOException {
        return new FileBasedTabularBlastParser(file);
    }

    public static BlastParser create(InputStream in) throws IOException {
        return new InputStreamBasedTabularBlastParser(in);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void parse(InputStream tabularBlastOutput, BlastVisitor visitor) throws IOException {
        TextLineParser parser = new TextLineParser(tabularBlastOutput);
        boolean parsedHeader = false;
        String type = null;
        try {
            BlastHitImpl.Builder blastHitBuilder = null;
            String prevQuery = null;
            String prevSubject = null;
            while (parser.hasNextLine()) {
                Matcher matcher;
                Matcher headerMatcher;
                String line = parser.nextLine();
                if (!parsedHeader && type == null && (headerMatcher = TYPE_PATTERN.matcher(line)).find()) {
                    type = headerMatcher.group(1);
                    parsedHeader = true;
                }
                if (!(matcher = HIT_PATTERN.matcher(line)).find()) continue;
                parsedHeader = true;
                DirectedRange queryRange = DirectedRange.parse(matcher.group(7), matcher.group(8), Range.CoordinateSystem.RESIDUE_BASED);
                DirectedRange subjectRange = DirectedRange.parse(matcher.group(9), matcher.group(10), Range.CoordinateSystem.RESIDUE_BASED);
                HspBuilder<Nucleotide, NucleotideSequence, NucleotideSequenceBuilder> hspBuilder = type == null ? HspBuilder.forBlastN() : HspBuilder.forType(type);
                String queryId = matcher.group(1);
                String subjectId = matcher.group(2);
                Object hsp = hspBuilder.query(queryId).subject(subjectId).percentIdentity(Double.parseDouble(matcher.group(3))).alignmentLength(Integer.parseInt(matcher.group(4))).numMismatches(Integer.parseInt(matcher.group(5))).numGapOpenings(Integer.parseInt(matcher.group(6))).eValue(new BigDecimal(matcher.group(11))).bitScore(new BigDecimal(matcher.group(12))).queryRange(queryRange).subjectRange(subjectRange).build();
                if (!queryId.equals(prevQuery) || !subjectId.equals(prevSubject)) {
                    if (blastHitBuilder != null) {
                        visitor.visitHit(blastHitBuilder.build());
                    }
                    blastHitBuilder = new BlastHitImpl.Builder(queryId, subjectId);
                }
                blastHitBuilder.addHsp((Hsp<?, ?, ?>)hsp);
                prevQuery = queryId;
                prevSubject = subjectId;
            }
            if (blastHitBuilder != null) {
                visitor.visitHit(blastHitBuilder.build());
            }
            visitor.visitEnd();
        }
        finally {
            IOUtil.closeAndIgnoreErrors((Closeable)parser);
        }
    }

    private static final class InputStreamBasedTabularBlastParser
    extends TabularBlastParser {
        private final OpenAwareInputStream in;

        public InputStreamBasedTabularBlastParser(InputStream in) {
            this.in = new OpenAwareInputStream(in);
        }

        @Override
        public boolean canParse() {
            return this.in.isOpen();
        }

        @Override
        public void parse(BlastVisitor visitor) throws IOException {
            if (!this.canParse()) {
                throw new IllegalStateException("can not parse inputstream, already closed");
            }
            this.parse(this.in, visitor);
        }
    }

    private static final class FileBasedTabularBlastParser
    extends TabularBlastParser {
        private final File file;

        public FileBasedTabularBlastParser(File file) {
            this.file = file;
        }

        @Override
        public boolean canParse() {
            return true;
        }

        @Override
        public void parse(BlastVisitor visitor) throws IOException {
            try (FileInputStream in = new FileInputStream(this.file);){
                this.parse(in, visitor);
            }
        }
    }
}

