/*
 * Decompiled with CFR 0.152.
 */
package org.jcvi.jillion.experimental.align.blast;

import java.math.BigDecimal;
import org.jcvi.jillion.core.DirectedRange;
import org.jcvi.jillion.core.residue.Residue;
import org.jcvi.jillion.core.residue.ResidueSequence;
import org.jcvi.jillion.core.residue.ResidueSequenceBuilder;
import org.jcvi.jillion.core.residue.aa.AminoAcid;
import org.jcvi.jillion.core.residue.aa.ProteinSequence;
import org.jcvi.jillion.core.residue.aa.ProteinSequenceBuilder;
import org.jcvi.jillion.core.residue.nt.Nucleotide;
import org.jcvi.jillion.core.residue.nt.NucleotideSequence;
import org.jcvi.jillion.core.residue.nt.NucleotideSequenceBuilder;
import org.jcvi.jillion.core.util.Builder;
import org.jcvi.jillion.experimental.align.blast.Hsp;

public final class HspBuilder<R extends Residue, S extends ResidueSequence<R, S, B>, B extends ResidueSequenceBuilder<R, S>>
implements Builder<Hsp<R, S, B>> {
    private static final double ONE_HUNDRED = 100.0;
    private String queryId;
    private String subjectId;
    private String subjectDef;
    private Double percentIdentity;
    private BigDecimal eValue;
    private BigDecimal bitScore;
    private DirectedRange queryRange;
    private DirectedRange subjectRange;
    private Integer numGapsOpenings;
    private Integer numMismatches;
    private Integer numIdentical;
    private Integer numPositive;
    private Integer alignmentLength;
    private Integer queryLength;
    private Integer subjectLength;
    private S queryAlignment;
    private S subjectAlignment;
    private Float hspScore;
    private Integer hitFrame;

    public static HspBuilder<Nucleotide, NucleotideSequence, NucleotideSequenceBuilder> forBlastN() {
        return new HspBuilder<Nucleotide, NucleotideSequence, NucleotideSequenceBuilder>();
    }

    public static HspBuilder<AminoAcid, ProteinSequence, ProteinSequenceBuilder> forBlastP() {
        return new HspBuilder<AminoAcid, ProteinSequence, ProteinSequenceBuilder>();
    }

    public static HspBuilder<AminoAcid, ProteinSequence, ProteinSequenceBuilder> forBlastX() {
        return new HspBuilder<AminoAcid, ProteinSequence, ProteinSequenceBuilder>();
    }

    public static HspBuilder<AminoAcid, ProteinSequence, ProteinSequenceBuilder> forTBlastX() {
        return new HspBuilder<AminoAcid, ProteinSequence, ProteinSequenceBuilder>();
    }

    public static HspBuilder<AminoAcid, ProteinSequence, ProteinSequenceBuilder> forTBlastN() {
        return new HspBuilder<AminoAcid, ProteinSequence, ProteinSequenceBuilder>();
    }

    public static HspBuilder<?, ?, ?> forType(String type) {
        if (type == null) {
            throw new NullPointerException("type can not be null");
        }
        if ("blastn".equalsIgnoreCase(type)) {
            return HspBuilder.forBlastN();
        }
        if ("blastp".equalsIgnoreCase(type)) {
            return HspBuilder.forBlastP();
        }
        if ("blastx".equalsIgnoreCase(type)) {
            return HspBuilder.forBlastX();
        }
        if ("tblastx".equalsIgnoreCase(type)) {
            return HspBuilder.forTBlastX();
        }
        if ("tblastn".equalsIgnoreCase(type)) {
            return HspBuilder.forTBlastN();
        }
        throw new IllegalArgumentException("unknown type :" + type);
    }

    public static <R extends Residue, S extends ResidueSequence<R, S, B>, B extends ResidueSequenceBuilder<R, S>> HspBuilder<R, S, B> copy(Hsp<R, S, B> hsp) {
        return new HspBuilder<R, S, B>(hsp);
    }

    public HspBuilder<R, S, B> copy() {
        return new HspBuilder<R, S, B>(this);
    }

    private HspBuilder(HspBuilder<R, S, B> copy) {
        this.bitScore = copy.bitScore;
        this.eValue = copy.eValue;
        this.numGapsOpenings = copy.numGapsOpenings;
        this.numMismatches = copy.numMismatches;
        this.percentIdentity = copy.percentIdentity;
        this.queryRange = copy.queryRange;
        this.subjectRange = copy.subjectRange;
        this.queryAlignment = copy.queryAlignment;
        this.queryId = copy.queryId;
        this.subjectAlignment = copy.subjectAlignment;
        this.subjectId = copy.subjectId;
        this.alignmentLength = copy.alignmentLength;
    }

    private HspBuilder(Hsp<R, S, B> copy) {
        this.bitScore(copy.getBitScore()).eValue(copy.getEvalue()).numGapOpenings(copy.getNumberOfGapOpenings()).numMismatches(copy.getNumberOfMismatches()).percentIdentity(copy.getPercentIdentity()).queryRange(copy.getQueryRange()).query(copy.getQueryId()).subject(copy.getSubjectId()).subjectRange(copy.getSubjectRange()).alignmentLength(copy.getAlignmentLength());
        if (copy.hasAlignments()) {
            this.gappedAlignments(copy.getGappedQueryAlignment(), copy.getGappedSubjectAlignment());
        }
    }

    private HspBuilder() {
    }

    private HspBuilder(String queryId) {
        this.query(queryId);
    }

    public HspBuilder<R, S, B> gappedAlignments(S queryAlignment, S subjectAlignment) {
        if (queryAlignment == null && subjectAlignment != null || subjectAlignment == null && queryAlignment != null) {
            throw new NullPointerException("gapped alignments must be either both null or neither null");
        }
        this.queryAlignment = queryAlignment;
        this.subjectAlignment = subjectAlignment;
        return this;
    }

    public HspBuilder<R, S, B> query(String queryId) {
        if (queryId == null) {
            throw new NullPointerException("query id can not be null");
        }
        String trimmed = queryId.trim();
        if (trimmed.isEmpty()) {
            throw new IllegalArgumentException("query id can not be empty");
        }
        this.queryId = trimmed;
        return this;
    }

    public HspBuilder<R, S, B> subjectDef(String subjectDef) {
        this.subjectDef = subjectDef;
        return this;
    }

    public HspBuilder<R, S, B> subject(String subjectId) {
        if (subjectId == null) {
            throw new NullPointerException("subject id can not be null");
        }
        String trimmed = subjectId.trim();
        if (trimmed.isEmpty()) {
            throw new IllegalArgumentException("query id can not be empty");
        }
        this.subjectId = trimmed;
        return this;
    }

    public HspBuilder<R, S, B> percentIdentity(double percentIdentity) {
        if (percentIdentity < 0.0) {
            throw new IllegalArgumentException("percentIdentity score must be positive: " + percentIdentity);
        }
        if (percentIdentity > 100.0) {
            throw new IllegalArgumentException("percentIdentity score must be <= 100: " + percentIdentity);
        }
        this.percentIdentity = percentIdentity;
        return this;
    }

    public HspBuilder<R, S, B> bitScore(BigDecimal bitScore) {
        if (bitScore == null) {
            throw new NullPointerException("bit score can not be null");
        }
        if (bitScore.compareTo(BigDecimal.ZERO) < 0) {
            throw new IllegalArgumentException("bit score must be positive: " + bitScore);
        }
        this.bitScore = bitScore;
        return this;
    }

    public HspBuilder<R, S, B> queryRange(DirectedRange queryRange) {
        if (queryRange == null) {
            throw new NullPointerException("queryRange can not be null");
        }
        this.queryRange = queryRange;
        return this;
    }

    public HspBuilder<R, S, B> subjectRange(DirectedRange subjectRange) {
        if (subjectRange == null) {
            throw new NullPointerException("subjectRange can not be null");
        }
        this.subjectRange = subjectRange;
        return this;
    }

    public HspBuilder<R, S, B> eValue(BigDecimal eValue) {
        if (eValue == null) {
            throw new NullPointerException("e-value can not be null");
        }
        if (eValue.compareTo(BigDecimal.ZERO) < 0) {
            throw new IllegalArgumentException("e-value score must be positive: " + eValue);
        }
        this.eValue = eValue;
        return this;
    }

    public HspBuilder<R, S, B> numGapOpenings(int numberOfGapOpenings) {
        if (numberOfGapOpenings < 0) {
            throw new IllegalArgumentException("number of gap openings can not be negative : " + numberOfGapOpenings);
        }
        this.numGapsOpenings = numberOfGapOpenings;
        return this;
    }

    public HspBuilder<R, S, B> numMismatches(int numberOfMismatches) {
        if (numberOfMismatches < 0) {
            throw new IllegalArgumentException("number of mismatches can not be negative : " + numberOfMismatches);
        }
        this.numMismatches = numberOfMismatches;
        return this;
    }

    public HspBuilder<R, S, B> numIdenticalMatches(int numIdentical) {
        if (numIdentical < 0) {
            throw new IllegalArgumentException("number of identical can not be negative : " + numIdentical);
        }
        this.numIdentical = numIdentical;
        return this;
    }

    public HspBuilder<R, S, B> numPositiveMatches(int numPositive) {
        if (numPositive < 0) {
            throw new IllegalArgumentException("number of positive matches can not be negative : " + this.numIdentical);
        }
        this.numPositive = numPositive;
        return this;
    }

    public HspBuilder<R, S, B> alignmentLength(int alignmentLength) {
        if (alignmentLength < 0) {
            throw new IllegalArgumentException("alignment length can not be negative : " + alignmentLength);
        }
        this.alignmentLength = alignmentLength;
        return this;
    }

    public HspBuilder<R, S, B> hitFrame(Integer frame) {
        this.hitFrame = frame;
        return this;
    }

    public HspBuilder<R, S, B> queryLength(int queryLength) {
        if (queryLength < 0) {
            throw new IllegalArgumentException("query length can not be negative : " + queryLength);
        }
        this.queryLength = queryLength;
        return this;
    }

    public HspBuilder<R, S, B> subjectLength(int subjectLength) {
        if (subjectLength < 0) {
            throw new IllegalArgumentException("subject length can not be negative : " + subjectLength);
        }
        this.subjectLength = subjectLength;
        return this;
    }

    public HspBuilder<R, S, B> hspScore(float hspScore) {
        if (hspScore < 0.0f) {
            throw new IllegalArgumentException("hsp score can not be negative : " + hspScore);
        }
        this.hspScore = Float.valueOf(hspScore);
        return this;
    }

    @Override
    public Hsp<R, S, B> build() {
        this.verifyAllValuesSet();
        this.sanityCheckValues();
        return new HspImpl(this);
    }

    private void sanityCheckValues() {
        if (this.numPositive != null && this.numIdentical != null && this.numPositive < this.numIdentical) {
            throw new IllegalStateException("number of matches must be >= number of identical matches");
        }
    }

    private void verifyAllValuesSet() {
        if (this.subjectId == null) {
            throw new IllegalStateException("must set subject id");
        }
        if (this.percentIdentity == null) {
            throw new IllegalStateException("must set percent identity");
        }
        if (this.bitScore == null) {
            throw new IllegalStateException("must set bit score");
        }
        if (this.eValue == null) {
            throw new IllegalStateException("must set e-value");
        }
        if (this.queryRange == null) {
            throw new IllegalStateException("must set query range");
        }
        if (this.subjectRange == null) {
            throw new IllegalStateException("must set subject range");
        }
        if (this.numGapsOpenings == null) {
            throw new IllegalStateException("must set number of gap openings");
        }
        if (this.numMismatches == null) {
            throw new IllegalStateException("must set number of mismatches");
        }
        if (this.alignmentLength == null) {
            throw new IllegalStateException("must set alignment length");
        }
    }

    private static final class HspImpl<R extends Residue, S extends ResidueSequence<R, S, B>, B extends ResidueSequenceBuilder<R, S>>
    implements Hsp<R, S, B> {
        private final String queryId;
        private final String subjectId;
        private final String subjectDef;
        private final double percentIdentity;
        private final BigDecimal eValue;
        private final BigDecimal bitScore;
        private final DirectedRange queryRange;
        private final DirectedRange subjectRange;
        private final int numGapsOpenings;
        private final int numMismatches;
        private final int alignmentLength;
        private final S queryAlignment;
        private final S subjectAlignment;
        private final Integer queryLength;
        private final Integer subjectLength;
        private final Integer numIdenticalMatches;
        private final Integer numPositiveMatches;
        private final Float hspScore;
        private final Integer hitFrame;

        private HspImpl(HspBuilder<R, S, B> builder) {
            this.queryId = ((HspBuilder)builder).queryId;
            this.subjectId = ((HspBuilder)builder).subjectId;
            this.percentIdentity = ((HspBuilder)builder).percentIdentity;
            this.bitScore = ((HspBuilder)builder).bitScore;
            this.eValue = ((HspBuilder)builder).eValue;
            this.queryRange = ((HspBuilder)builder).queryRange;
            this.subjectRange = ((HspBuilder)builder).subjectRange;
            this.numGapsOpenings = ((HspBuilder)builder).numGapsOpenings;
            this.numMismatches = ((HspBuilder)builder).numMismatches;
            this.alignmentLength = ((HspBuilder)builder).alignmentLength;
            this.queryAlignment = ((HspBuilder)builder).queryAlignment;
            this.subjectAlignment = ((HspBuilder)builder).subjectAlignment;
            this.queryLength = ((HspBuilder)builder).queryLength;
            this.hspScore = ((HspBuilder)builder).hspScore;
            this.subjectDef = ((HspBuilder)builder).subjectDef;
            this.subjectLength = ((HspBuilder)builder).subjectLength;
            this.numIdenticalMatches = ((HspBuilder)builder).numIdentical;
            this.numPositiveMatches = ((HspBuilder)builder).numPositive;
            this.hitFrame = ((HspBuilder)builder).hitFrame;
        }

        @Override
        public Integer getHitFrame() {
            return this.hitFrame;
        }

        @Override
        public Integer getNumberOfIdentitcalMatches() {
            return this.numIdenticalMatches;
        }

        @Override
        public Integer getNumberOfPositiveMatches() {
            return this.numPositiveMatches;
        }

        @Override
        public Integer getSubjectLength() {
            return this.subjectLength;
        }

        @Override
        public String getSubjectDefinition() {
            return this.subjectDef;
        }

        @Override
        public Float getHspScore() {
            return this.hspScore;
        }

        @Override
        public Integer getQueryLength() {
            return this.queryLength;
        }

        @Override
        public boolean hasAlignments() {
            return this.queryAlignment != null;
        }

        @Override
        public S getGappedQueryAlignment() {
            return this.queryAlignment;
        }

        @Override
        public S getGappedSubjectAlignment() {
            return this.subjectAlignment;
        }

        public String toString() {
            return "HspImpl [queryId=" + this.queryId + ", subjectId=" + this.subjectId + ", percentIdentity=" + this.percentIdentity + ", eValue=" + this.eValue + ", bitScore=" + this.bitScore + ", queryRange=" + this.queryRange + ", subjectRange=" + this.subjectRange + ", numGapsOpenings=" + this.numGapsOpenings + ", numMismatches=" + this.numMismatches + ", alignmentLength=" + this.alignmentLength + ", queryAlignment=" + this.queryAlignment + ", subjectAlignment=" + this.subjectAlignment + "]";
        }

        @Override
        public String getQueryId() {
            return this.queryId;
        }

        @Override
        public String getSubjectId() {
            return this.subjectId;
        }

        @Override
        public double getPercentIdentity() {
            return this.percentIdentity;
        }

        @Override
        public int getAlignmentLength() {
            return this.alignmentLength;
        }

        @Override
        public int getNumberOfMismatches() {
            return this.numMismatches;
        }

        @Override
        public int getNumberOfGapOpenings() {
            return this.numGapsOpenings;
        }

        @Override
        public DirectedRange getQueryRange() {
            return this.queryRange;
        }

        @Override
        public DirectedRange getSubjectRange() {
            return this.subjectRange;
        }

        @Override
        public BigDecimal getEvalue() {
            return this.eValue;
        }

        @Override
        public BigDecimal getBitScore() {
            return this.bitScore;
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + this.alignmentLength;
            result = 31 * result + (this.bitScore == null ? 0 : this.bitScore.hashCode());
            result = 31 * result + (this.eValue == null ? 0 : this.eValue.hashCode());
            result = 31 * result + this.numGapsOpenings;
            result = 31 * result + this.numMismatches;
            long temp = Double.doubleToLongBits(this.percentIdentity);
            result = 31 * result + (int)(temp ^ temp >>> 32);
            result = 31 * result + (this.queryAlignment == null ? 0 : this.queryAlignment.hashCode());
            result = 31 * result + (this.queryId == null ? 0 : this.queryId.hashCode());
            result = 31 * result + (this.queryRange == null ? 0 : this.queryRange.hashCode());
            result = 31 * result + (this.subjectAlignment == null ? 0 : this.subjectAlignment.hashCode());
            result = 31 * result + (this.subjectId == null ? 0 : this.subjectId.hashCode());
            result = 31 * result + (this.subjectRange == null ? 0 : this.subjectRange.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (!(obj instanceof HspImpl)) {
                return false;
            }
            HspImpl other = (HspImpl)obj;
            if (this.alignmentLength != other.alignmentLength) {
                return false;
            }
            if (this.bitScore == null ? other.bitScore != null : !this.bitScore.equals(other.bitScore)) {
                return false;
            }
            if (this.eValue == null ? other.eValue != null : !this.eValue.equals(other.eValue)) {
                return false;
            }
            if (this.numGapsOpenings != other.numGapsOpenings) {
                return false;
            }
            if (this.numMismatches != other.numMismatches) {
                return false;
            }
            if (Double.doubleToLongBits(this.percentIdentity) != Double.doubleToLongBits(other.percentIdentity)) {
                return false;
            }
            if (this.queryAlignment == null ? other.queryAlignment != null : !this.queryAlignment.equals(other.queryAlignment)) {
                return false;
            }
            if (this.queryId == null ? other.queryId != null : !this.queryId.equals(other.queryId)) {
                return false;
            }
            if (this.queryRange == null ? other.queryRange != null : !this.queryRange.equals(other.queryRange)) {
                return false;
            }
            if (this.subjectAlignment == null ? other.subjectAlignment != null : !this.subjectAlignment.equals(other.subjectAlignment)) {
                return false;
            }
            if (this.subjectId == null ? other.subjectId != null : !this.subjectId.equals(other.subjectId)) {
                return false;
            }
            return !(this.subjectRange == null ? other.subjectRange != null : !this.subjectRange.equals(other.subjectRange));
        }
    }
}

