/*
 * Decompiled with CFR 0.152.
 */
package org.jcvi.jillion.experimental.align.blast;

import java.math.BigDecimal;
import java.util.Comparator;
import org.jcvi.jillion.align.SequenceAlignment;
import org.jcvi.jillion.core.residue.Residue;
import org.jcvi.jillion.core.residue.ResidueSequence;
import org.jcvi.jillion.core.residue.ResidueSequenceBuilder;

public interface Hsp<R extends Residue, S extends ResidueSequence<R, S, B>, B extends ResidueSequenceBuilder<R, S>>
extends SequenceAlignment<R, S> {
    public String getQueryId();

    public String getSubjectId();

    public String getSubjectDefinition();

    public Integer getQueryLength();

    public Integer getSubjectLength();

    public BigDecimal getEvalue();

    public BigDecimal getBitScore();

    public Float getHspScore();

    public Integer getNumberOfIdentitcalMatches();

    public Integer getNumberOfPositiveMatches();

    public Integer getHitFrame();

    public boolean hasAlignments();

    public static enum Comparators implements Comparator<Hsp<?, ?, ?>>
    {
        BIT_SCORE_WORST_TO_BEST{

            @Override
            public int compare(Hsp<?, ?, ?> o1, Hsp<?, ?, ?> o2) {
                return o1.getBitScore().compareTo(o2.getBitScore());
            }
        }
        ,
        BIT_SCORE_BEST_TO_WORST{

            @Override
            public int compare(Hsp<?, ?, ?> o1, Hsp<?, ?, ?> o2) {
                return o2.getBitScore().compareTo(o1.getBitScore());
            }
        }
        ,
        E_VALUE_BEST_TO_WORST{

            @Override
            public int compare(Hsp<?, ?, ?> o1, Hsp<?, ?, ?> o2) {
                return o1.getEvalue().compareTo(o2.getEvalue());
            }
        }
        ,
        E_VALUE_WORST_TO_BEST{

            @Override
            public int compare(Hsp<?, ?, ?> o1, Hsp<?, ?, ?> o2) {
                return o2.getEvalue().compareTo(o1.getEvalue());
            }
        };

    }
}

