/*
 * Decompiled with CFR 0.152.
 */
package org.jcvi.jillion.experimental.align.blast;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import org.jcvi.jillion.experimental.align.blast.BlastHit;
import org.jcvi.jillion.experimental.align.blast.Hsp;

class BlastHitImpl
implements BlastHit {
    private final String queryId;
    private final String subjectId;
    private final String subjectDefline;
    private final String programName;
    private final String dbName;
    private final Integer queryLength;
    private final Integer subjectLength;
    private final List<Hsp<?, ?, ?>> hsps;

    public BlastHitImpl(Builder builder) {
        this.queryId = builder.queryId;
        this.subjectId = builder.subjectId;
        this.queryLength = builder.queryLength;
        this.subjectLength = builder.subjectLength;
        this.subjectDefline = builder.subjectDeflineComment;
        this.programName = builder.programName;
        this.dbName = builder.dbName;
        ArrayList sortedList = new ArrayList(builder.hsps);
        Collections.sort(sortedList, HspComparator.INSTANCE);
        this.hsps = Collections.unmodifiableList(sortedList);
    }

    @Override
    public String getBlastDbName() {
        return this.dbName;
    }

    @Override
    public String getBlastProgramName() {
        return this.programName;
    }

    @Override
    public String getQueryId() {
        return this.queryId;
    }

    @Override
    public String getSubjectId() {
        return this.subjectId;
    }

    @Override
    public String getSubjectDefinition() {
        return this.subjectDefline;
    }

    @Override
    public Integer getQueryLength() {
        return this.queryLength;
    }

    @Override
    public Integer getSubjectLength() {
        return this.subjectLength;
    }

    @Override
    public List<Hsp<?, ?, ?>> getHsps() {
        return this.hsps;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.dbName == null ? 0 : this.dbName.hashCode());
        result = 31 * result + (this.hsps == null ? 0 : this.hsps.hashCode());
        result = 31 * result + (this.programName == null ? 0 : this.programName.hashCode());
        result = 31 * result + (this.queryId == null ? 0 : this.queryId.hashCode());
        result = 31 * result + (this.queryLength == null ? 0 : this.queryLength.hashCode());
        result = 31 * result + (this.subjectDefline == null ? 0 : this.subjectDefline.hashCode());
        result = 31 * result + (this.subjectId == null ? 0 : this.subjectId.hashCode());
        result = 31 * result + (this.subjectLength == null ? 0 : this.subjectLength.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof BlastHitImpl)) {
            return false;
        }
        BlastHitImpl other = (BlastHitImpl)obj;
        if (this.dbName == null ? other.dbName != null : !this.dbName.equals(other.dbName)) {
            return false;
        }
        if (this.hsps == null ? other.hsps != null : !this.hsps.equals(other.hsps)) {
            return false;
        }
        if (this.programName == null ? other.programName != null : !this.programName.equals(other.programName)) {
            return false;
        }
        if (this.queryId == null ? other.queryId != null : !this.queryId.equals(other.queryId)) {
            return false;
        }
        if (this.queryLength == null ? other.queryLength != null : !this.queryLength.equals(other.queryLength)) {
            return false;
        }
        if (this.subjectDefline == null ? other.subjectDefline != null : !this.subjectDefline.equals(other.subjectDefline)) {
            return false;
        }
        if (this.subjectId == null ? other.subjectId != null : !this.subjectId.equals(other.subjectId)) {
            return false;
        }
        return !(this.subjectLength == null ? other.subjectLength != null : !this.subjectLength.equals(other.subjectLength));
    }

    public static class Builder {
        private final String queryId;
        private final String subjectId;
        private String subjectDeflineComment;
        private Integer queryLength;
        private Integer subjectLength;
        private String programName;
        private String dbName;
        private List<Hsp<?, ?, ?>> hsps = new ArrayList();

        public Builder(String queryId, String subjectId) {
            this.queryId = queryId;
            this.subjectId = subjectId;
        }

        public Builder setQueryLength(int queryLength) {
            if (queryLength < 0) {
                throw new IllegalArgumentException("query length can not be negative");
            }
            this.queryLength = queryLength;
            return this;
        }

        public Builder setSubjectDefline(String subjectDefline) {
            this.subjectDeflineComment = subjectDefline;
            return this;
        }

        public Builder setBlastProgramName(String programName) {
            this.programName = programName;
            return this;
        }

        public Builder setBlastDbName(String dbName) {
            this.dbName = dbName;
            return this;
        }

        public Builder setSubjectLength(int subjectLength) {
            if (subjectLength < 0) {
                throw new IllegalArgumentException("subject length can not be negative");
            }
            this.subjectLength = subjectLength;
            return this;
        }

        public Builder addHsp(Hsp<?, ?, ?> hsp) {
            if (hsp == null) {
                throw new NullPointerException("hsp can not be null");
            }
            this.hsps.add(hsp);
            return this;
        }

        public BlastHit build() {
            return new BlastHitImpl(this);
        }
    }

    private static enum HspComparator implements Comparator<Hsp<?, ?, ?>>
    {
        INSTANCE;


        @Override
        public int compare(Hsp<?, ?, ?> o1, Hsp<?, ?, ?> o2) {
            int eCmp = o1.getEvalue().compareTo(o2.getEvalue());
            if (eCmp != 0) {
                return eCmp;
            }
            int bitScoreCmp = o2.getBitScore().compareTo(o1.getBitScore());
            if (bitScoreCmp != 0) {
                return bitScoreCmp;
            }
            Float hsp1 = o1.getHspScore();
            Float hsp2 = o2.getHspScore();
            if (hsp1 != null && hsp2 != null) {
                return Float.compare(hsp2.floatValue(), hsp1.floatValue());
            }
            if (hsp1 == null && hsp2 == null) {
                return 0;
            }
            if (hsp1 == null) {
                return 1;
            }
            return -1;
        }
    }
}

