/*
 * Decompiled with CFR 0.152.
 */
package org.jcvi.jillion.experimental.align;

import java.io.File;
import java.io.IOException;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jcvi.jillion.core.datastore.DataStore;
import org.jcvi.jillion.core.residue.nt.NucleotideSequence;
import org.jcvi.jillion.core.residue.nt.NucleotideSequenceBuilder;
import org.jcvi.jillion.core.residue.nt.NucleotideSequenceDataStore;
import org.jcvi.jillion.core.util.Builder;
import org.jcvi.jillion.experimental.align.AlnFileParser;
import org.jcvi.jillion.experimental.align.AlnGroupVisitor;
import org.jcvi.jillion.experimental.align.AlnParser;
import org.jcvi.jillion.experimental.align.AlnVisitor;

public final class GappedNucleotideAlignmentDataStore {
    private GappedNucleotideAlignmentDataStore() {
    }

    public static NucleotideSequenceDataStore createFromAlnFile(File alnFile) throws IOException {
        return GappedNucleotideAlignmentDataStore.createFrom(AlnFileParser.create(alnFile));
    }

    public static NucleotideSequenceDataStore createFrom(AlnParser parser) throws IOException {
        GappedAlignmentDataStoreBuilder builder = new GappedAlignmentDataStoreBuilder();
        parser.parse(builder);
        return builder.build();
    }

    private static class GappedAlignmentDataStoreBuilder
    implements AlnVisitor,
    AlnGroupVisitor,
    Builder<NucleotideSequenceDataStore> {
        private final Map<String, NucleotideSequenceBuilder> builders = new LinkedHashMap<String, NucleotideSequenceBuilder>();

        private GappedAlignmentDataStoreBuilder() {
        }

        @Override
        public NucleotideSequenceDataStore build() {
            LinkedHashMap<String, NucleotideSequence> map = new LinkedHashMap<String, NucleotideSequence>(this.builders.size());
            Iterator<Map.Entry<String, NucleotideSequenceBuilder>> entrySet = this.builders.entrySet().iterator();
            if (entrySet.hasNext()) {
                Map.Entry<String, NucleotideSequenceBuilder> firstEntry = entrySet.next();
                NucleotideSequence firstSequence = firstEntry.getValue().build();
                map.put(firstEntry.getKey(), firstSequence);
                while (entrySet.hasNext()) {
                    Map.Entry<String, NucleotideSequenceBuilder> entry = entrySet.next();
                    NucleotideSequence seq = entry.getValue().setReferenceHint(firstSequence, 0).build();
                    map.put(entry.getKey(), seq);
                }
                this.builders.clear();
            }
            return DataStore.of(map, NucleotideSequenceDataStore.class);
        }

        @Override
        public void visitEnd() {
        }

        @Override
        public void halted() {
        }

        @Override
        public AlnGroupVisitor visitGroup(Set<String> ids, AlnVisitor.AlnVisitorCallback callback) {
            return this;
        }

        @Override
        public void visitAlignedSegment(String id, String gappedAlignment) {
            if (!this.builders.containsKey(id)) {
                this.builders.put(id, new NucleotideSequenceBuilder());
            }
            this.builders.get(id).append(gappedAlignment);
        }

        @Override
        public void visitEndGroup() {
        }

        @Override
        public void visitConservationInfo(List<AlnGroupVisitor.ConservationInfo> conservationInfos) {
        }

        @Override
        public void visitHeader(String header) {
        }
    }
}

