/*
 * Decompiled with CFR 0.152.
 */
package org.jcvi.jillion.experimental.align;

import java.io.BufferedReader;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.io.StringReader;
import java.util.Objects;
import org.jcvi.jillion.assembly.util.consensus.ConsensusCaller;
import org.jcvi.jillion.assembly.util.consensus.ConsensusCollectors;
import org.jcvi.jillion.core.datastore.DataStoreException;
import org.jcvi.jillion.core.io.IOUtil;
import org.jcvi.jillion.core.residue.nt.NucleotideSequence;
import org.jcvi.jillion.experimental.align.GappedNucleotideAlignmentDataStore;

public final class AlnUtil {
    private AlnUtil() {
    }

    public static boolean validHeader(String header) {
        if (header.isEmpty()) {
            return false;
        }
        Closeable parser = null;
        try (BufferedReader reader = new BufferedReader(new StringReader(header));){
            reader.readLine();
            if (reader.read() != -1) {
                boolean bl = false;
                return bl;
            }
        }
        catch (IOException e) {
            throw new IllegalStateException("error reading aln header", e);
        }
        finally {
            IOUtil.closeAndIgnoreErrors(parser);
        }
        return header.startsWith("CLUSTAL") || header.startsWith("MUSCLE");
    }

    public static NucleotideSequence computeConsensus(File alnFile, ConsensusCaller consensusCaller) throws DataStoreException, IOException {
        Objects.requireNonNull(consensusCaller);
        return GappedNucleotideAlignmentDataStore.createFromAlnFile(alnFile).entryIterator().toStream().collect(ConsensusCollectors.toDataStoreConsensus(consensusCaller));
    }
}

