/*
 * Decompiled with CFR 0.152.
 */
package org.jcvi.jillion.experimental.align;

import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import org.jcvi.jillion.core.Range;
import org.jcvi.jillion.core.Sequence;
import org.jcvi.jillion.core.io.IOUtil;
import org.jcvi.jillion.core.residue.Residue;
import org.jcvi.jillion.core.residue.aa.AminoAcid;
import org.jcvi.jillion.core.residue.aa.ProteinSequence;
import org.jcvi.jillion.core.residue.nt.Nucleotide;
import org.jcvi.jillion.core.residue.nt.NucleotideSequence;
import org.jcvi.jillion.experimental.align.AlnGroupVisitor;
import org.jcvi.jillion.experimental.align.AlnWriter;

public abstract class AlnFileWriter<R extends Residue, S extends Sequence<R>>
implements AlnWriter<R, S> {
    private static final String DEFAULT_CLUSTAL_HEADER = "CLUSTAL W";
    private static final int DEFAULT_RESIDUES_PER_GROUP = 60;
    private static final int USE_ONE_GROUP = -1;
    private final PrintWriter out;
    private final int residuesPerGroup;
    private final Map<String, S> sequences = new LinkedHashMap<String, S>();
    private long seqLength = 0L;
    private final String eol;
    private long cumulativeLength;
    private final boolean includeCumulativeCounts;
    private boolean headerWritten = false;

    public static AlnFileWriterBuilder<Nucleotide, NucleotideSequence> createNucleotideWriterBuilder(File outputFile) {
        return new NucleotideAlnFileWriterBuilder(outputFile);
    }

    public static AlnFileWriterBuilder<AminoAcid, ProteinSequence> createAminoAcidWriterBuilder(File outputFile) {
        return new AminoAcidAlnFileWriterBuilder(outputFile);
    }

    private AlnFileWriter(File outputFile, int residuesPerGroup, String eol, boolean includeCounts) throws IOException {
        IOUtil.mkdirs(outputFile.getParentFile());
        this.out = new PrintWriter(IOUtil.createNewBufferedWriter(outputFile, "UTF-8"));
        this.residuesPerGroup = residuesPerGroup;
        this.eol = eol;
        this.includeCumulativeCounts = includeCounts;
    }

    @Override
    public void close() throws IOException {
        if (!this.headerWritten) {
            this.writeHeader(DEFAULT_CLUSTAL_HEADER);
        }
        if (!this.sequences.isEmpty()) {
            if (this.residuesPerGroup == -1) {
                this.handleGroup(Range.ofLength(this.seqLength));
            } else {
                for (long i = 0L; i < this.seqLength; i += (long)this.residuesPerGroup) {
                    long newEnd;
                    Range.Builder builder = new Range.Builder(this.residuesPerGroup).shift(i);
                    Range r = builder.setEnd(newEnd = Math.min(this.seqLength - 1L, builder.getEnd())).build();
                    if (r.isEmpty()) continue;
                    this.handleGroup(r);
                }
            }
        }
        this.out.close();
    }

    private void handleGroup(Range r) {
        int i;
        String lineCount;
        if (this.sequences.isEmpty()) {
            return;
        }
        int rangeLength = (int)r.getLength();
        ArrayList iterators = new ArrayList(this.sequences.size());
        ArrayList<StringBuilder> builders = new ArrayList<StringBuilder>(this.sequences.size());
        int maxIdLength = 0;
        for (String id : this.sequences.keySet()) {
            int length = id.length();
            if (length <= maxIdLength) continue;
            maxIdLength = length;
        }
        if (this.includeCumulativeCounts) {
            this.cumulativeLength += (long)rangeLength;
            lineCount = String.format(" %d", this.cumulativeLength);
        } else {
            lineCount = "";
        }
        int lineLength = maxIdLength + 1 + this.eol.length() + rangeLength + lineCount.length();
        for (Map.Entry<String, S> entry : this.sequences.entrySet()) {
            iterators.add(((Sequence)entry.getValue()).iterator(r));
            String id = entry.getKey();
            StringBuilder builder = new StringBuilder(lineLength);
            builder.append(id);
            int padding = maxIdLength - id.length();
            for (int i2 = 0; i2 < padding; ++i2) {
                builder.append(' ');
            }
            builder.append('\t');
            builders.add(builder);
        }
        StringBuilder conservationBuilder = new StringBuilder(lineLength);
        for (i = 0; i < maxIdLength; ++i) {
            conservationBuilder.append(' ');
        }
        conservationBuilder.append('\t');
        for (i = 0; i < rangeLength; ++i) {
            Set<R> uniqueValues = this.createNewResiudeSet();
            for (int j = 0; j < iterators.size(); ++j) {
                Residue residue = (Residue)((Iterator)iterators.get(j)).next();
                ((StringBuilder)builders.get(j)).append(residue.getCharacter());
                uniqueValues.add(residue);
            }
            AlnGroupVisitor.ConservationInfo info = this.computeConservationInfo(uniqueValues);
            conservationBuilder.append(info.asChar());
        }
        for (i = 0; i < builders.size(); ++i) {
            StringBuilder builder = (StringBuilder)builders.get(i);
            if (this.includeCumulativeCounts) {
                builder.append(lineCount);
            }
            this.out.write(builder.append(this.eol).toString());
        }
        this.out.write(conservationBuilder.append(this.eol).toString());
    }

    protected abstract Set<R> createNewResiudeSet();

    protected abstract AlnGroupVisitor.ConservationInfo computeConservationInfo(Set<R> var1);

    @Override
    public void writeHeader(String header) {
        this.assertHeaderNotWrittenYet();
        this.out.write(header);
        this.out.write(this.eol);
        this.out.write(this.eol);
        this.headerWritten = true;
    }

    private void assertHeaderNotWrittenYet() {
        if (this.headerWritten) {
            throw new IllegalStateException("header can only be written once");
        }
    }

    @Override
    public void write(String id, S sequence) throws IOException {
        if (id == null) {
            throw new NullPointerException("id can not be null");
        }
        if (sequence == null) {
            throw new NullPointerException("sequence can not be null");
        }
        long currentSequenceLength = sequence.getLength();
        if (currentSequenceLength == 0L) {
            return;
        }
        if (this.sequences.isEmpty()) {
            this.seqLength = currentSequenceLength;
        } else if (this.seqLength != currentSequenceLength) {
            throw new IOException(String.format("invalid sequence length, all sequences so far have been %d residues but %s is %d", this.seqLength, id, currentSequenceLength));
        }
        if (this.sequences.containsKey(id)) {
            throw new IllegalArgumentException(String.format("id %s already has been written", id));
        }
        this.sequences.put(id, sequence);
    }

    public static final class AminoAcidAlnFileWriterBuilder
    extends AlnFileWriterBuilder<AminoAcid, ProteinSequence> {
        public AminoAcidAlnFileWriterBuilder(File outFile) {
            super(outFile);
        }

        @Override
        protected AlnFileWriter<AminoAcid, ProteinSequence> createNew(File f, int groupLength, String endOfLine, boolean includeCounts) throws IOException {
            return new AminoAcidAlnFileWriter(f, groupLength, endOfLine, includeCounts);
        }
    }

    public static final class NucleotideAlnFileWriterBuilder
    extends AlnFileWriterBuilder<Nucleotide, NucleotideSequence> {
        public NucleotideAlnFileWriterBuilder(File outFile) {
            super(outFile);
        }

        @Override
        protected AlnFileWriter<Nucleotide, NucleotideSequence> createNew(File f, int groupLength, String endOfLine, boolean includeCounts) throws IOException {
            return new NucleotideAlnFileWriter(f, groupLength, endOfLine, includeCounts);
        }
    }

    public static abstract class AlnFileWriterBuilder<R extends Residue, S extends Sequence<R>> {
        private final File outFile;
        private int residuesPerGroup = 60;
        private String eol = "\n";
        private boolean includeCumulativeCounts = false;

        private AlnFileWriterBuilder(File outFile) {
            if (outFile == null) {
                throw new NullPointerException("output File can not be null");
            }
            this.outFile = outFile;
        }

        public AlnFileWriterBuilder<R, S> setNumResiduesPerGroup(int n) {
            if (n < 1) {
                throw new IllegalArgumentException("number of residues per group must be >= 1");
            }
            this.residuesPerGroup = n;
            return this;
        }

        public AlnFileWriterBuilder<R, S> eol(String eol) {
            if (eol == null) {
                throw new NullPointerException("end of line can not be null");
            }
            this.eol = eol;
            return this;
        }

        public AlnFileWriterBuilder<R, S> forceOneGroupOnly() {
            this.residuesPerGroup = -1;
            return this;
        }

        public AlnFileWriter<R, S> build() throws IOException {
            return this.createNew(this.outFile, this.residuesPerGroup, this.eol, this.includeCumulativeCounts);
        }

        public AlnFileWriterBuilder<R, S> includeCumulativeCounts(boolean include) {
            this.includeCumulativeCounts = include;
            return this;
        }

        protected abstract AlnFileWriter<R, S> createNew(File var1, int var2, String var3, boolean var4) throws IOException;
    }

    private static final class AminoAcidAlnFileWriter
    extends AlnFileWriter<AminoAcid, ProteinSequence> {
        private static Set<AminoAcid> ALIPHATIC = EnumSet.of(AminoAcid.Glycine, new AminoAcid[]{AminoAcid.Alanine, AminoAcid.Valine, AminoAcid.Leucine, AminoAcid.Isoleucine, AminoAcid.Methionine});
        private static Set<AminoAcid> HYDROXYL_SULFHYDRYL_POLAR = EnumSet.of(AminoAcid.Serine, AminoAcid.Threonine, AminoAcid.Cysteine);
        private static Set<AminoAcid> AMIDE_SIDE_CHAINS = EnumSet.of(AminoAcid.Asparagine, AminoAcid.Glutamine);
        private static Set<AminoAcid> AROMATIC = EnumSet.of(AminoAcid.Phenylalanine, AminoAcid.Tryptophan, AminoAcid.Tyrosine);
        private static Set<AminoAcid> BASIC = EnumSet.of(AminoAcid.Histidine, AminoAcid.Lysine, AminoAcid.Arginine);
        private static Set<AminoAcid> ACIDIC = EnumSet.of(AminoAcid.Aspartic_Acid, AminoAcid.Glutamic_Acid);

        public AminoAcidAlnFileWriter(File outputFile, int residuesPerGroup, String eol, boolean includeCounts) throws IOException {
            super(outputFile, residuesPerGroup, eol, includeCounts);
        }

        @Override
        protected Set<AminoAcid> createNewResiudeSet() {
            return EnumSet.noneOf(AminoAcid.class);
        }

        @Override
        protected AlnGroupVisitor.ConservationInfo computeConservationInfo(Set<AminoAcid> values) {
            if (values.size() == 1) {
                return AlnGroupVisitor.ConservationInfo.IDENTICAL;
            }
            if (ALIPHATIC.containsAll(values) || HYDROXYL_SULFHYDRYL_POLAR.containsAll(values) || AMIDE_SIDE_CHAINS.containsAll(values) || AROMATIC.containsAll(values) || ACIDIC.containsAll(values) || BASIC.containsAll(values)) {
                return AlnGroupVisitor.ConservationInfo.CONSERVED_SUBSITUTION;
            }
            return AlnGroupVisitor.ConservationInfo.NOT_CONSERVED;
        }
    }

    private static final class NucleotideAlnFileWriter
    extends AlnFileWriter<Nucleotide, NucleotideSequence> {
        public NucleotideAlnFileWriter(File outputFile, int residuesPerGroup, String eol, boolean includeCounts) throws IOException {
            super(outputFile, residuesPerGroup, eol, includeCounts);
        }

        @Override
        protected Set<Nucleotide> createNewResiudeSet() {
            return EnumSet.noneOf(Nucleotide.class);
        }

        @Override
        protected AlnGroupVisitor.ConservationInfo computeConservationInfo(Set<Nucleotide> values) {
            if (values.size() == 1) {
                if (values.contains(Nucleotide.Gap)) {
                    return AlnGroupVisitor.ConservationInfo.NOT_CONSERVED;
                }
                return AlnGroupVisitor.ConservationInfo.IDENTICAL;
            }
            return AlnGroupVisitor.ConservationInfo.NOT_CONSERVED;
        }
    }
}

