/*
 * Decompiled with CFR 0.152.
 */
package org.jcvi.jillion.experimental.align;

import java.io.BufferedInputStream;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jcvi.jillion.core.io.IOUtil;
import org.jcvi.jillion.experimental.align.AlnGroupVisitor;
import org.jcvi.jillion.experimental.align.AlnParser;
import org.jcvi.jillion.experimental.align.AlnUtil;
import org.jcvi.jillion.experimental.align.AlnVisitor;
import org.jcvi.jillion.internal.core.io.LineParser;
import org.jcvi.jillion.internal.core.io.OpenAwareInputStream;
import org.jcvi.jillion.internal.core.io.RandomAccessFileInputStream;
import org.jcvi.jillion.internal.core.io.TextLineParser;

public abstract class AlnFileParser
implements AlnParser {
    private static final String REGEX = "^([^*\\s]+)\\s+([\\-ACGTNVHDBWMRSYKILFQPEXacgtnvhdbwmrsykilfqpex]+)(\\s+\\d+)?$";
    private static final Pattern ALIGNMENT_PATTERN = Pattern.compile("^([^*\\s]+)\\s+([\\-ACGTNVHDBWMRSYKILFQPEXacgtnvhdbwmrsykilfqpex]+)(\\s+\\d+)?$");
    private static final Pattern CONSERVATION_PATTERN = Pattern.compile("\\s+([-:\\. \\*]+)$");

    public static AlnParser create(File alnFile) throws IOException {
        return new FileBasedAlnParser(alnFile);
    }

    public static AlnParser create(InputStream alnStream) throws IOException {
        return new InputStreamBasedAlnParser(alnStream);
    }

    private AlnFileParser() {
    }

    private static List<AlnGroupVisitor.ConservationInfo> parseConservationInfo(String conservationString, int numberOfBasesPerGroup) {
        String paddedString = AlnFileParser.createPaddedConservationString(conservationString, numberOfBasesPerGroup);
        ArrayList<AlnGroupVisitor.ConservationInfo> result = new ArrayList<AlnGroupVisitor.ConservationInfo>(numberOfBasesPerGroup);
        for (int i = 0; i < paddedString.length(); ++i) {
            result.add(AlnGroupVisitor.ConservationInfo.parse(paddedString.charAt(i)));
        }
        return result;
    }

    void parse(AlnVisitor visitor, InputStream in) throws IOException {
        this.parse(visitor, in, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void parse(AlnVisitor visitor, InputStream in, boolean validateHeader) throws IOException {
        TextLineParser parser = new TextLineParser(in);
        AtomicBoolean keepParsing = new AtomicBoolean(true);
        boolean eofReached = false;
        try {
            if (!parser.hasNextLine()) {
                throw new IOException("no aln data");
            }
            if (validateHeader) {
                String header = parser.nextLine();
                if (!AlnUtil.validHeader(header)) {
                    throw new IOException("invalid aln header : " + header);
                }
                visitor.visitHeader(header);
            }
            while (keepParsing.get() && parser.hasNextLine()) {
                AlnVisitor.AlnVisitorCallback callback = this.createCallBack(parser, keepParsing);
                Group group = Group.getNextGroup(parser);
                if (group == null) continue;
                group.accept(visitor, callback, keepParsing);
            }
            eofReached = !parser.hasNextLine();
        }
        finally {
            if (eofReached && keepParsing.get()) {
                visitor.visitEnd();
            } else {
                visitor.halted();
            }
            IOUtil.closeAndIgnoreErrors((Closeable)parser);
        }
    }

    abstract AlnVisitor.AlnVisitorCallback createCallBack(TextLineParser var1, AtomicBoolean var2);

    private static String createPaddedConservationString(String conservationString, int numberOfBasesPerGroup) {
        String paddedString;
        int length = conservationString.length();
        int padding = numberOfBasesPerGroup - length;
        if (padding > 0) {
            String format = "%" + padding + "s%s";
            paddedString = String.format(format, "", conservationString);
        } else {
            paddedString = conservationString;
        }
        return paddedString;
    }

    private static final class FileBasedAlnParser
    extends AlnFileParser {
        private final File alnFile;

        public FileBasedAlnParser(File alnFile) throws IOException {
            if (!alnFile.exists()) {
                throw new FileNotFoundException(alnFile.getAbsolutePath());
            }
            this.alnFile = alnFile;
        }

        @Override
        public boolean canParse() {
            return true;
        }

        @Override
        protected AlnVisitor.AlnVisitorCallback createCallBack(TextLineParser parser, AtomicBoolean keepParsing) {
            return new AlnFileVisitorCallback(parser.getPosition(), keepParsing);
        }

        @Override
        public void parse(AlnVisitor visitor) throws IOException {
            BufferedInputStream in = null;
            try {
                in = new BufferedInputStream(new FileInputStream(this.alnFile));
                this.parse(visitor, in);
            }
            catch (Throwable throwable) {
                IOUtil.closeAndIgnoreErrors(in);
                throw throwable;
            }
            IOUtil.closeAndIgnoreErrors((Closeable)in);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void parse(AlnVisitor visitor, AlnVisitor.AlnVisitorCallback.AlnVisitorMemento memento) throws IOException {
            if (!(memento instanceof AlnFileMemento)) {
                throw new IllegalStateException("unknown memento type" + memento);
            }
            AlnFileMemento alnFileMemento = (AlnFileMemento)memento;
            if (alnFileMemento.getOuterType() != this) {
                throw new IllegalStateException("invalid memento: was not created by this parser");
            }
            BufferedInputStream in = null;
            try {
                in = new BufferedInputStream(new RandomAccessFileInputStream(this.alnFile, alnFileMemento.offset));
                this.parse(visitor, in, false);
            }
            catch (Throwable throwable) {
                IOUtil.closeAndIgnoreErrors(in);
                throw throwable;
            }
            IOUtil.closeAndIgnoreErrors((Closeable)in);
        }

        private class AlnFileMemento
        implements AlnVisitor.AlnVisitorCallback.AlnVisitorMemento {
            private long offset;

            public AlnFileMemento(long offset) {
                this.offset = offset;
            }

            public int hashCode() {
                int prime = 31;
                int result = 1;
                result = 31 * result + this.getOuterType().hashCode();
                result = 31 * result + (int)(this.offset ^ this.offset >>> 32);
                return result;
            }

            public boolean equals(Object obj) {
                if (this == obj) {
                    return true;
                }
                if (obj == null) {
                    return false;
                }
                if (!(obj instanceof AlnFileMemento)) {
                    return false;
                }
                AlnFileMemento other = (AlnFileMemento)obj;
                if (!this.getOuterType().equals(other.getOuterType())) {
                    return false;
                }
                return this.offset == other.offset;
            }

            private FileBasedAlnParser getOuterType() {
                return FileBasedAlnParser.this;
            }
        }

        private class AlnFileVisitorCallback
        implements AlnVisitor.AlnVisitorCallback {
            private final AtomicBoolean keepParsing;
            private final long offset;

            public AlnFileVisitorCallback(long offset, AtomicBoolean keepParsing) {
                this.keepParsing = keepParsing;
                this.offset = offset;
            }

            @Override
            public boolean canCreateMemento() {
                return true;
            }

            @Override
            public AlnVisitor.AlnVisitorCallback.AlnVisitorMemento createMemento() {
                return new AlnFileMemento(this.offset);
            }

            @Override
            public void haltParsing() {
                this.keepParsing.set(false);
            }
        }
    }

    private static final class NoMementoCallback
    implements AlnVisitor.AlnVisitorCallback {
        private final AtomicBoolean keepParsing;

        public NoMementoCallback(AtomicBoolean keepParsing) {
            this.keepParsing = keepParsing;
        }

        @Override
        public boolean canCreateMemento() {
            return false;
        }

        @Override
        public AlnVisitor.AlnVisitorCallback.AlnVisitorMemento createMemento() {
            throw new UnsupportedOperationException("mementos not supported");
        }

        @Override
        public void haltParsing() {
            this.keepParsing.set(false);
        }
    }

    private static final class InputStreamBasedAlnParser
    extends AlnFileParser {
        private final OpenAwareInputStream in;

        public InputStreamBasedAlnParser(InputStream in) {
            this.in = new OpenAwareInputStream(in);
        }

        @Override
        public boolean canParse() {
            return this.in.isOpen();
        }

        @Override
        public void parse(AlnVisitor visitor) throws IOException {
            try {
                this.parse(visitor, this.in);
            }
            finally {
                IOUtil.closeAndIgnoreErrors((Closeable)this.in);
            }
        }

        @Override
        public void parse(AlnVisitor visitor, AlnVisitor.AlnVisitorCallback.AlnVisitorMemento memento) throws IOException {
            throw new UnsupportedOperationException("mementos not supported");
        }

        @Override
        protected AlnVisitor.AlnVisitorCallback createCallBack(TextLineParser parser, AtomicBoolean keepParsing) {
            return new NoMementoCallback(keepParsing);
        }
    }

    private static final class Group {
        private final Map<String, String> lines;
        private final List<AlnGroupVisitor.ConservationInfo> info;

        public Group(Map<String, String> lines, List<AlnGroupVisitor.ConservationInfo> info) {
            this.lines = lines;
            this.info = info;
        }

        public void accept(AlnVisitor visitor, AlnVisitor.AlnVisitorCallback callback, AtomicBoolean keepParsing) {
            AlnGroupVisitor groupVisitor = visitor.visitGroup(this.lines.keySet(), callback);
            if (groupVisitor != null) {
                for (Map.Entry<String, String> entry : this.lines.entrySet()) {
                    if (!keepParsing.get()) continue;
                    groupVisitor.visitAlignedSegment(entry.getKey(), entry.getValue());
                }
                if (keepParsing.get()) {
                    groupVisitor.visitConservationInfo(this.info);
                }
                if (keepParsing.get()) {
                    groupVisitor.visitEndGroup();
                }
            }
        }

        static Group getNextGroup(LineParser parser) throws IOException {
            LinkedHashMap<String, String> lines = new LinkedHashMap<String, String>();
            boolean done = false;
            boolean foundGroup = false;
            List<AlnGroupVisitor.ConservationInfo> info = null;
            int numberOfBasesPerGroup = 0;
            while (parser.hasNextLine() && !done) {
                Matcher alignmentMatcher;
                String untrimmedLine = parser.nextLine();
                String trimmedLine = untrimmedLine.trim();
                if (foundGroup && trimmedLine.isEmpty()) {
                    done = true;
                }
                if ((alignmentMatcher = ALIGNMENT_PATTERN.matcher(trimmedLine)).matches()) {
                    foundGroup = true;
                    numberOfBasesPerGroup = alignmentMatcher.group(2).length();
                    lines.put(alignmentMatcher.group(1), alignmentMatcher.group(2));
                    continue;
                }
                Matcher conservationMatcher = CONSERVATION_PATTERN.matcher(untrimmedLine);
                if (!conservationMatcher.find()) continue;
                String conservationString = conservationMatcher.group(1);
                info = AlnFileParser.parseConservationInfo(conservationString, numberOfBasesPerGroup);
                done = true;
            }
            if (lines.isEmpty()) {
                return null;
            }
            if (info == null) {
                info = new ArrayList<AlnGroupVisitor.ConservationInfo>(numberOfBasesPerGroup);
                for (int i = 0; i < info.size(); ++i) {
                    info.add(AlnGroupVisitor.ConservationInfo.NOT_CONSERVED);
                }
            }
            return new Group(lines, info);
        }
    }
}

