/*
 * Decompiled with CFR 0.152.
 */
package org.jcvi.jillion.core.util.iter;

import java.util.Iterator;
import java.util.NoSuchElementException;
import org.jcvi.jillion.core.util.iter.StreamingIterator;

final class StreamingIteratorAdapter<T>
implements StreamingIterator<T> {
    private final Iterator<T> iterator;
    private volatile boolean isClosed = false;

    public static <T> StreamingIteratorAdapter<T> adapt(Iterator<T> iterator) {
        return new StreamingIteratorAdapter<T>(iterator);
    }

    private StreamingIteratorAdapter(Iterator<T> iterator) {
        if (iterator == null) {
            throw new NullPointerException("iterator can not be null");
        }
        this.iterator = iterator;
    }

    @Override
    public void close() {
        if (this.isClosed) {
            return;
        }
        if (this.iterator instanceof StreamingIterator) {
            ((StreamingIterator)this.iterator).close();
        }
        this.isClosed = true;
    }

    @Override
    public boolean hasNext() {
        if (this.isClosed) {
            return false;
        }
        return this.iterator.hasNext();
    }

    @Override
    public T next() {
        if (this.isClosed) {
            throw new NoSuchElementException("iterator has been closed");
        }
        return this.iterator.next();
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException();
    }
}

