/*
 * Decompiled with CFR 0.152.
 */
package org.jcvi.jillion.core.util.iter;

import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;

class RollOverListIterator<T>
implements Iterator<T> {
    int currentOffset;
    List<T> list;

    public RollOverListIterator(List<T> list) {
        this(list, 0);
    }

    public RollOverListIterator(List<T> list, int startOffset) {
        this.list = list;
        while (startOffset < 0) {
            startOffset = list.size() + startOffset;
        }
        this.currentOffset = startOffset % list.size();
    }

    @Override
    public boolean hasNext() {
        return !this.list.isEmpty();
    }

    @Override
    public T next() {
        if (!this.hasNext()) {
            throw new NoSuchElementException();
        }
        T ret = this.list.get(this.currentOffset++);
        if (this.currentOffset >= this.list.size()) {
            this.currentOffset = 0;
        }
        return ret;
    }
}

