/*
 * Decompiled with CFR 0.152.
 */
package org.jcvi.jillion.core.util.iter;

import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.RandomAccess;
import java.util.function.Function;
import java.util.function.Supplier;
import org.jcvi.jillion.core.util.iter.ArrayIterator;
import org.jcvi.jillion.core.util.iter.ChainedIterator;
import org.jcvi.jillion.core.util.iter.ChainedIteratorOfSuppliers;
import org.jcvi.jillion.core.util.iter.ChainedStreamingIterator;
import org.jcvi.jillion.core.util.iter.ChainedStreamingIteratorFromSuppliers;
import org.jcvi.jillion.core.util.iter.PeekableIterator;
import org.jcvi.jillion.core.util.iter.PeekableStreamingIterator;
import org.jcvi.jillion.core.util.iter.RollOverListIterator;
import org.jcvi.jillion.core.util.iter.StreamingIterator;
import org.jcvi.jillion.core.util.iter.StreamingIteratorAdapter;

public final class IteratorUtil {
    private IteratorUtil() {
    }

    public static <E> Iterator<E> createEmptyIterator() {
        return EmptyIterator.INSTANCE;
    }

    public static <E> StreamingIterator<E> createEmptyStreamingIterator() {
        return IteratorUtil.createStreamingIterator(EmptyIterator.INSTANCE);
    }

    public static <E> Iterator<E> createIteratorFromArray(E[] array) {
        return new ArrayIterator<E>(array);
    }

    public static <E> PeekableIterator<E> createPeekableIterator(Iterator<E> iter) {
        return new PeekableIteratorImpl<E>(iter);
    }

    public static <E> StreamingIterator<E> createStreamingIterator(Iterator<E> iter) {
        return StreamingIteratorAdapter.adapt(iter);
    }

    public static <E> PeekableStreamingIterator<E> createPeekableStreamingIterator(Iterator<E> iter) {
        return new PeekableStreamingIteratorImpl<E>(IteratorUtil.createStreamingIterator(iter));
    }

    public static <E> PeekableIterator<E> createPeekableIterator(Iterable<E> iter) {
        return IteratorUtil.createPeekableIterator(iter.iterator());
    }

    public static <E> StreamingIterator<E> createStreamingIterator(Iterable<E> iter) {
        return IteratorUtil.createStreamingIterator(iter.iterator());
    }

    public static <E> PeekableStreamingIterator<E> createPeekableStreamingIterator(Iterable<E> iter) {
        return IteratorUtil.createPeekableStreamingIterator(iter.iterator());
    }

    public static <E> PeekableStreamingIterator<E> createPeekableStreamingIterator(StreamingIterator<E> iter) {
        return new PeekableStreamingIteratorImpl<E>(iter);
    }

    public static <E> Iterator<E> createChainedIterator(Collection<? extends Iterator<E>> iterators) {
        return ChainedIterator.create(iterators);
    }

    public static <E> StreamingIterator<E> createChainedStreamingIterator(Collection<? extends StreamingIterator<? extends E>> iterators) {
        return new ChainedStreamingIterator(iterators);
    }

    public static <From, To> StreamingIterator<To> createStreamingIterator(StreamingIterator<From> iter, TypeAdapter<From, To> adapter) {
        return new AdaptedStreamingIterator<From, To>(iter, adapter);
    }

    public static <From, To> StreamingIterator<To> createStreamingIterator(Iterator<From> iter, TypeAdapter<From, To> adapter) {
        return new AdaptedStreamingIterator<From, To>(IteratorUtil.createStreamingIterator(iter), adapter);
    }

    public static <T, R> Iterator<R> map(final Iterator<T> iter, final Function<T, R> mapper) {
        Objects.requireNonNull(iter);
        Objects.requireNonNull(mapper);
        return new Iterator<R>(){

            @Override
            public boolean hasNext() {
                return iter.hasNext();
            }

            @Override
            public R next() {
                return mapper.apply(iter.next());
            }
        };
    }

    @SafeVarargs
    public static <T> StreamingIterator<T> chainStreamingSuppliers(Supplier<? extends StreamingIterator<? extends T>> ... suppliers) {
        return IteratorUtil.chainStreamingSuppliers(Arrays.asList(suppliers));
    }

    public static <T> StreamingIterator<T> chainStreamingSuppliers(Collection<? extends Supplier<? extends StreamingIterator<? extends T>>> suppliers) {
        return new ChainedStreamingIteratorFromSuppliers(suppliers);
    }

    @SafeVarargs
    public static <T> Iterator<T> chainSuppliers(Supplier<? extends Iterator<? extends T>> ... suppliers) {
        return IteratorUtil.chainSuppliers(Arrays.asList(suppliers));
    }

    public static <T> Iterator<T> chainSuppliers(Collection<? extends Supplier<? extends Iterator<? extends T>>> suppliers) {
        return ChainedIteratorOfSuppliers.create(suppliers);
    }

    public static <T, L extends List<T> & RandomAccess> Iterator<T> rollover(L randomAccessList) {
        return new RollOverListIterator(randomAccessList);
    }

    public static <T, L extends List<T> & RandomAccess> Iterator<T> rollover(L randomAccessList, int startOffset) {
        return new RollOverListIterator(randomAccessList, startOffset);
    }

    private static final class AdaptedStreamingIterator<From, To>
    implements StreamingIterator<To> {
        private final StreamingIterator<From> delegate;
        private final TypeAdapter<From, To> adapter;

        public AdaptedStreamingIterator(StreamingIterator<From> delegate, TypeAdapter<From, To> adapter) {
            if (delegate == null) {
                throw new NullPointerException("delegate can not be null");
            }
            if (adapter == null) {
                throw new NullPointerException("adapter can not be null");
            }
            this.delegate = delegate;
            this.adapter = adapter;
        }

        @Override
        public boolean hasNext() {
            return this.delegate.hasNext();
        }

        @Override
        public void close() {
            this.delegate.close();
        }

        @Override
        public To next() {
            return this.adapter.adapt(this.delegate.next());
        }

        @Override
        public void remove() {
            this.delegate.remove();
        }
    }

    public static interface TypeAdapter<From, To> {
        public To adapt(From var1);
    }

    private static final class EmptyIterator<E>
    implements Iterator<E> {
        static final EmptyIterator INSTANCE = new EmptyIterator();

        private EmptyIterator() {
        }

        @Override
        public boolean hasNext() {
            return false;
        }

        @Override
        public E next() {
            throw new NoSuchElementException("no elements in empty iterator");
        }

        @Override
        public void remove() {
        }
    }

    private static class PeekableStreamingIteratorImpl<T>
    implements PeekableStreamingIterator<T> {
        private final StreamingIterator<T> iter;
        private T next;
        private boolean doneIterating = false;

        PeekableStreamingIteratorImpl(StreamingIterator<T> iter) {
            if (iter == null) {
                throw new NullPointerException();
            }
            this.iter = iter;
            this.updateNext();
        }

        private void updateNext() {
            if (this.iter.hasNext()) {
                this.next = this.iter.next();
            } else {
                this.doneIterating = true;
            }
        }

        @Override
        public void close() {
            this.doneIterating = true;
            this.iter.close();
        }

        @Override
        public boolean hasNext() {
            return !this.doneIterating;
        }

        @Override
        public T next() {
            if (this.hasNext()) {
                T ret = this.next;
                this.updateNext();
                return ret;
            }
            throw new NoSuchElementException();
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException("peekable iterators can not remove");
        }

        @Override
        public T peek() {
            if (this.hasNext()) {
                return this.next;
            }
            throw new NoSuchElementException();
        }
    }

    private static class PeekableIteratorImpl<T>
    implements PeekableIterator<T> {
        private final Iterator<T> iter;
        private T next;
        private boolean doneIterating = false;

        PeekableIteratorImpl(Iterator<T> iter) {
            if (iter == null) {
                throw new NullPointerException();
            }
            this.iter = iter;
            this.updateNext();
        }

        private void updateNext() {
            if (this.iter.hasNext()) {
                this.next = this.iter.next();
            } else {
                this.doneIterating = true;
            }
        }

        @Override
        public boolean hasNext() {
            return !this.doneIterating;
        }

        @Override
        public T next() {
            T ret = this.next;
            this.updateNext();
            return ret;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException("peekable iterators can not remove");
        }

        @Override
        public T peek() {
            if (this.hasNext()) {
                return this.next;
            }
            throw new NoSuchElementException();
        }
    }
}

