/*
 * Decompiled with CFR 0.152.
 */
package org.jcvi.jillion.core.util.iter;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import org.jcvi.jillion.core.io.IOUtil;
import org.jcvi.jillion.core.util.iter.ChainedIterator;
import org.jcvi.jillion.core.util.iter.StreamingIterator;

final class ChainedStreamingIterator<T>
implements StreamingIterator<T> {
    private final List<StreamingIterator<? extends T>> delegates;
    private final Iterator<? extends T> iterator;

    public ChainedStreamingIterator(Collection<? extends StreamingIterator<? extends T>> delegates) {
        if (delegates.contains(null)) {
            throw new NullPointerException("can not contain null iterator");
        }
        this.delegates = new ArrayList<StreamingIterator<T>>(delegates);
        this.iterator = ChainedIterator.create(delegates);
    }

    @Override
    public void close() {
        for (StreamingIterator<? extends T> streamingIterator : this.delegates) {
            IOUtil.closeAndIgnoreErrors(streamingIterator);
        }
    }

    @Override
    public boolean hasNext() {
        return this.iterator.hasNext();
    }

    @Override
    public T next() {
        return this.iterator.next();
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException();
    }
}

