/*
 * Decompiled with CFR 0.152.
 */
package org.jcvi.jillion.core.util.iter;

import java.io.Closeable;
import java.util.Collection;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.function.Supplier;
import org.jcvi.jillion.core.io.IOUtil;

final class ChainedIteratorOfSuppliers<T>
implements Iterator<T>,
Closeable {
    private final Iterator<? extends Supplier<? extends Iterator<? extends T>>> chain;
    private Iterator<? extends T> currentIterator;
    private final Object endOfIterating = new Object();
    private final Object needToGetNext;
    private Object next = this.needToGetNext = new Object();

    public static <T> ChainedIteratorOfSuppliers<T> create(Collection<? extends Supplier<? extends Iterator<? extends T>>> suppliers) {
        return new ChainedIteratorOfSuppliers<T>(suppliers);
    }

    @Override
    public void close() {
        this.next = this.endOfIterating;
        if (this.currentIterator instanceof Closeable) {
            IOUtil.closeAndIgnoreErrors((Closeable)((Object)this.currentIterator));
        }
    }

    private ChainedIteratorOfSuppliers(Collection<? extends Supplier<? extends Iterator<? extends T>>> suppliers) {
        if (suppliers.contains(null)) {
            throw new NullPointerException("can not contain null iterator");
        }
        this.chain = suppliers.iterator();
        this.updateCurrentIterator();
    }

    private void updateCurrentIterator() {
        Iterator<T> newIter = null;
        while (this.chain.hasNext() && (newIter = this.chain.next().get()) == null) {
        }
        if (newIter == null) {
            this.next = this.endOfIterating;
        } else {
            this.next = this.needToGetNext;
            this.currentIterator = newIter;
        }
    }

    private void updateNext() {
        if (this.currentIterator.hasNext()) {
            this.next = this.currentIterator.next();
        } else if (this.chain.hasNext()) {
            this.updateCurrentIterator();
            this.updateNext();
        } else {
            this.next = this.endOfIterating;
        }
    }

    @Override
    public boolean hasNext() {
        if (this.next == this.endOfIterating) {
            return false;
        }
        if (this.next == this.needToGetNext) {
            this.updateNext();
            return this.hasNext();
        }
        return true;
    }

    @Override
    public T next() {
        if (!this.hasNext()) {
            throw new NoSuchElementException("no more elements in chain");
        }
        Object ret = this.next;
        this.next = this.needToGetNext;
        return (T)ret;
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException();
    }
}

