/*
 * Decompiled with CFR 0.152.
 */
package org.jcvi.jillion.core.util.iter;

import java.util.Collection;
import java.util.Iterator;
import java.util.NoSuchElementException;

final class ChainedIterator<T>
implements Iterator<T> {
    private final Iterator<? extends Iterator<? extends T>> chain;
    private Iterator<? extends T> currentIterator;
    private final Object endOfIterating = new Object();
    private final Object needToGetNext;
    private Object next = this.needToGetNext = new Object();

    public static <T> ChainedIterator<T> create(Collection<? extends Iterator<? extends T>> iterators) {
        return new ChainedIterator<T>(iterators);
    }

    private ChainedIterator(Collection<? extends Iterator<? extends T>> iterators) {
        if (iterators.contains(null)) {
            throw new NullPointerException("can not contain null iterator");
        }
        this.chain = iterators.iterator();
        this.currentIterator = this.chain.next();
    }

    private void updateNext() {
        if (this.currentIterator.hasNext()) {
            this.next = this.currentIterator.next();
        } else if (this.chain.hasNext()) {
            this.currentIterator = this.chain.next();
            this.updateNext();
        } else {
            this.next = this.endOfIterating;
        }
    }

    @Override
    public boolean hasNext() {
        if (this.next == this.endOfIterating) {
            return false;
        }
        if (this.next == this.needToGetNext) {
            this.updateNext();
            return this.hasNext();
        }
        return true;
    }

    @Override
    public T next() {
        if (!this.hasNext()) {
            throw new NoSuchElementException("no more elements in chain");
        }
        Object ret = this.next;
        this.next = this.needToGetNext;
        return (T)ret;
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException();
    }
}

